CREATE OR REPLACE VIEW mig_td_ext.vw_td_dbc_IndicesV
/*  This view is used to support some specific columns like DatabaseName,
    TableName, ColumnName and IndexType in the TD system view "dbc.IndicesV"
*/
AS
SELECT UPPER(ns.nspname) AS DatabaseName
     , UPPER(t.relname) AS TableName
     , UPPER(a.attname) AS ColumnName
	 , CASE WHEN ix.pcattnum IS NULL THEN 'x'
	        ELSE 'P'
	   END AS IndexType
  FROM pg_catalog.pg_class t
       INNER JOIN pg_catalog.pg_attribute a
	ON t.relkind     = 'r'
   AND a.attrelid    = t.oid
       INNER JOIN pg_catalog.pg_namespace ns
	ON ns.oid        = t.relnamespace
       LEFT OUTER JOIN pg_catalog.pgxc_class ix
    ON a.attrelid    = ix.pcrelid
   AND a.attnum      = ANY(ix.pcattnum)
 WHERE a.attnum > 0 
   AND NOT a.attisdropped
 ORDER BY ns.nspname, t.relname, a.attnum;
 