/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.db.migration.util.SetFilePermission;
import com.huawei.hwclouds.migration.common.FileHandler;
import com.huawei.hwclouds.migration.common.config.ApplicationPropertyLoader;
import com.huawei.hwclouds.migration.pg.DWSMigration;
import com.huawei.hwclouds.migration.pg.PgConvertor;
import com.huawei.hwclouds.migration.pg.cli.CliOptions;
import com.huawei.hwclouds.migration.pg.cli.CliParser;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMain {
    private static final Logger LOGGER = LogManager.getLogger(DWSMain.class);
    private static int range = 0;
    private static BufferedWriter writer;
    private static final List<String> FAILED_FILES;
    protected static final AtomicInteger FAILED_SQL;
    private static Path logPath;
    private static DatabaseConvertor convertor;
    private static final int MAX_QRY_LENGTH = 0x3200000;
    private static final int DEFAULT_QRY_LENGTH = 0x100000;
    private static Pattern patternCnt;
    private static Pattern patternSize;

    public static void main(String[] args) throws IOException {
        try {
            ApplicationPropertyLoader.loadProperty("application");
        }
        catch (Exception e) {
            LOGGER.error("Failed to load application.properties.");
        }
        CliParser cli = new CliParser();
        CliOptions options = null;
        try {
            options = cli.parser(args);
        }
        catch (ParserException e) {
            LOGGER.error("Failed to parse arguments.", (Throwable)e);
            return;
        }
        if (options == null) {
            LOGGER.error("Failed to parse arguments, options are empty.");
            return;
        }
        DWSMain.parseSQLs(options);
    }

    private static void executionThread(CliOptions options, Map<String, String> files) {
        int availableProc = Runtime.getRuntime().availableProcessors();
        int configureProc = DWSMain.getConfiguredProcessors(availableProc - 1);
        DWSMain.printThreadInfo(availableProc, configureProc);
        DWSMain.checkMaxFileSize(files);
        String rangeStr = ApplicationPropertyLoader.getStringProperty("MaxSqlLen").trim();
        DWSMain.doSetRange(rangeStr);
        boolean failedNumber = false;
        int countValidFiles = files.size();
        ExecutorService oracleExecutor = Executors.newFixedThreadPool(configureProc);
        ArrayList futureList = new ArrayList();
        ArrayList<String> successResultList = new ArrayList<String>();
        ArrayList<String> failedResultList = new ArrayList<String>();
        for (String val : files.values()) {
            File file = new File(val);
            String outputFile = DWSMain.getOutputFile(file, options.getOutputFolder(), options.getInputFolder());
            DWSMigration migration = new DWSMigration(file, outputFile, range, countValidFiles, successResultList, failedResultList, options);
            oracleExecutor.execute(migration);
        }
        String confValueTimeOut = ApplicationPropertyLoader.getStringProperty("Timeout");
        try {
            oracleExecutor.shutdown();
            oracleExecutor.awaitTermination(Integer.parseInt(confValueTimeOut), TimeUnit.HOURS);
            DWSMain.clearFutureList(futureList);
        }
        catch (InterruptedException e) {
            LOGGER.error("DSC timeout exception occurs due to exceeding {} hours. This paramater is configured in application.properties", (Object)confValueTimeOut);
            DWSMain.printConsoleMessage("DSC timeout exception occurs due to exceeding " + confValueTimeOut + " hours. Please reference dscError.log for details.");
            oracleExecutor.shutdownNow();
        }
        int totalFiles = files.size();
        DWSMain.printDetail(successResultList, failedResultList);
        DWSMain.printStats(countValidFiles, totalFiles);
    }

    private static void printDetail(List<String> successResultList, List<String> failedResultList) {
        LOGGER.info("Migration result detail:");
        successResultList.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        failedResultList.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    public static int getConfiguredProcessors(int defaultVal) {
        String confValue = ApplicationPropertyLoader.getStringProperty("NoOfThreads");
        if (confValue.isEmpty()) {
            return defaultVal;
        }
        Matcher isNum = patternCnt.matcher(confValue.trim());
        int numberOfProcessors = 0;
        if (isNum.matches()) {
            numberOfProcessors = Integer.parseInt(confValue.trim());
        } else {
            DWSMain.printConsoleMessage("Invalid value configured for config item: NoOfThreads, hence using the default value");
            LOGGER.error("Invalid value configured for config item: NoOfThreads, hence using the default value");
        }
        if (numberOfProcessors < 1 || numberOfProcessors > defaultVal) {
            LOGGER.warn("Invalid value configured for configuration item: NoOfThreads, the number of threads is greater than the maximum number of available threads {} or the number of threads  is less than 1", (Object)defaultVal);
            DWSMain.printConsoleMessage("Invalid value configured for configuration item: NoOfThreads, the number of threads is greater than the maximum number of available threads " + defaultVal + " or the number of threads  is less than 1");
            LOGGER.warn("Invalid value configured for config item: NoOfThreads, hence using the default value {}", (Object)defaultVal);
            return defaultVal;
        }
        return numberOfProcessors;
    }

    private static void parseSQLs(CliOptions options) {
        SqlDialect sourceDialect = options.getSourceDialect();
        switch (sourceDialect) {
            case GREENPLUM: 
            case HOLOGRES: 
            case REDSHIFT: 
            case POSTGRES: 
            case NETEZZA: {
                convertor = new PgConvertor(null);
                break;
            }
            default: {
                LOGGER.error("Only GreenPlum, Hologres, redShift, Postgres source databases are supported now");
                return;
            }
        }
        FileHandler objFileHandler = new FileHandler();
        Map<String, String> files = objFileHandler.processSQLFiles(options.getInputFolder(), new LinkedHashMap<String, String>(10));
        if (files == null || files.size() == 0) {
            LOGGER.info("DSC Application failed to start : No SQL files found in the input folder.");
            DWSMain.printConsoleMessage("DSC Application failed to start : No SQL files found in the input folder.");
            return;
        }
        DWSMain.executionThread(options, files);
    }

    public static void printConsoleMessage(String messageInp) {
        String message = messageInp;
        if (null != message) {
            try {
                writer.write(message);
                writer.write(System.lineSeparator());
                writer.flush();
            }
            catch (IOException e) {
                LOGGER.error("Error while writing message to console.");
            }
        }
    }

    private static void printThreadInfo(int availableProc, int configureProc) {
        Date startDate = new Date();
        DWSMain.printConsoleMessage("DSC process start time : " + startDate);
        LOGGER.info("DSC process start time : {}", (Object)startDate);
        LOGGER.info("Number of available processors : {}", (Object)availableProc);
        DWSMain.printConsoleMessage("Configured simultaneous processes in the tool : " + configureProc);
        LOGGER.info("Configured simultaneous processes in the tool : {}", (Object)configureProc);
    }

    private static void checkMaxFileSize(Map<String, String> files) {
        int size = 0;
        String byteVal = null;
        ArrayList<String> fileMaxSizeExceedList = new ArrayList<String>(10);
        String maxSize = ApplicationPropertyLoader.getStringProperty("MaxFileSize").trim();
        Matcher match = patternSize.matcher(maxSize);
        if (match.find()) {
            size = Integer.parseInt(match.group(1));
            byteVal = match.group(2);
        } else {
            LOGGER.info("Invalid Value Specified for MaxFileSize configuration. {}", (Object)" Hence setting the default max file size as 20MB.");
            size = 20;
            byteVal = "MB";
        }
        if (byteVal.equals("GB")) {
            if (size > 1) {
                LOGGER.info("MaxFileSize size is out of range.{}", (Object)" Hence setting the default max file size as 20MB.");
                size = 20;
                byteVal = "MB";
            }
        } else if (!(byteVal.equals("B") || byteVal.equals("KB") || byteVal.equals("MB"))) {
            LOGGER.info("MaxFileSize size is out of range.{}", (Object)" Hence setting the default max file size as 20MB.");
            size = 20;
            byteVal = "MB";
        }
        DWSMain.getMaxFileSizeExceedList(files, size, byteVal, fileMaxSizeExceedList);
        DWSMain.showMaxSizeExceedFiles(size, byteVal, fileMaxSizeExceedList);
    }

    private static void getMaxFileSizeExceedList(Map<String, String> files, int size, String byteVal, List<String> filesList) {
        Long fileSize = null;
        Long byteSize = null;
        Iterator<Map.Entry<String, String>> it = files.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> file = it.next();
            fileSize = FileUtils.sizeOf((File)new File(file.getValue()));
            byteSize = DWSMain.doGetFileSize(fileSize, byteVal);
            if (byteSize <= (long)size) continue;
            filesList.add(file.getValue());
            it.remove();
        }
    }

    private static Long doGetFileSize(Long fileSize, String byteVal) {
        Long byteSize = 0L;
        switch (byteVal) {
            case "KB": {
                byteSize = fileSize / 1024L;
                break;
            }
            case "MB": {
                byteSize = fileSize / 1024L;
                byteSize = byteSize / 1024L;
                break;
            }
            case "GB": {
                byteSize = fileSize / 1024L;
                byteSize = byteSize / 1024L;
                byteSize = byteSize / 1024L;
                break;
            }
            default: {
                byteSize = fileSize;
            }
        }
        return byteSize;
    }

    private static void showMaxSizeExceedFiles(int size, String byteVal, List<String> fileList) {
        if (!fileList.isEmpty()) {
            LOGGER.info("Migration of the following files exceeds the max file size: {} {} , these files will not be migrated", (Object)size, (Object)byteVal);
            DWSMain.printConsoleMessage("**************************************************************************");
            DWSMain.printConsoleMessage("[WARN]: Migration of the following files exceeds the max file size:" + size + byteVal + ", these files will not be migrated.");
            for (String fStr : fileList) {
                DWSMain.printConsoleMessage(fStr);
                LOGGER.info(fStr);
            }
            DWSMain.printConsoleMessage("**************************************************************************");
        }
    }

    private static void doSetRange(String rangeStr) {
        if (rangeStr.matches("\\d+")) {
            range = Integer.parseInt(rangeStr);
            if (range >= 0x3200000 || range <= 1) {
                DWSMain.printConsoleMessage("The query length parameter (MaxSqlLen) value is out of range. Resetting to default value.");
                range = 0x100000;
            }
        } else {
            LOGGER.info("The query length parameter (MaxSqlLen) value is invalid");
        }
    }

    private static String getOutputFile(File inputFile, String outputDirectory, String inputDirectory) {
        Path inputDirPath;
        Path relativePath;
        String sqlName = inputFile.getName();
        String[] fileExtension = FileHandler.getValidFileExtension();
        List<String> fileExtensionList = Arrays.asList(fileExtension);
        if (!fileExtensionList.contains(sqlName.toLowerCase(Locale.US).substring(sqlName.lastIndexOf(".") + 1))) {
            LOGGER.info("Invalid input file format");
        }
        if ((relativePath = (inputDirPath = Paths.get(inputDirectory, new String[0])).relativize(inputFile.toPath())).toString().contains(File.separator)) {
            DWSMain.createRecursiveFolderPermission(relativePath, outputDirectory);
        }
        String outputFile = null;
        try {
            String outputFolder = new File(outputDirectory).getCanonicalPath();
            outputFile = outputFolder.endsWith(File.separator) ? outputFolder + relativePath.toString() : outputFolder + File.separator + relativePath.toString();
        }
        catch (IOException e) {
            LOGGER.error("Failed to create outputFolder.");
        }
        return outputFile;
    }

    private static void createRecursiveFolderPermission(Path relativePath, String outputDirectory) {
        String[] folders;
        String relativePathString = relativePath.toString();
        String osType = System.getProperty("os.name").toLowerCase(Locale.US);
        String splitRegex = Pattern.quote(System.getProperty("file.separator"));
        if (osType.indexOf("windows") >= 0) {
            folders = relativePathString.split(splitRegex);
            DWSMain.doCreateRecursiveFolderPermission(folders, outputDirectory, "Win");
        }
        if (osType.indexOf("linux") >= 0) {
            folders = relativePathString.split(splitRegex);
            DWSMain.doCreateRecursiveFolderPermission(folders, outputDirectory, "Linux");
        }
    }

    private static void doCreateRecursiveFolderPermission(String[] folders, String outputDirectory, String type) {
        SetFilePermission setFilePermission = new SetFilePermission();
        String recentLayerPath = "";
        for (int i = 0; i < folders.length - 1; ++i) {
            recentLayerPath = recentLayerPath + File.separator + folders[i];
            if (type.equals("Win")) {
                setFilePermission.createFolderWithPermissionInWin(outputDirectory + recentLayerPath, false);
                continue;
            }
            setFilePermission.createFolderWithPermissionInLinux(outputDirectory + recentLayerPath, false);
        }
    }

    private static void clearFutureList(ArrayList<Future<?>> futureList) {
        for (Future<?> future : futureList) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
        futureList.clear();
    }

    private static void printStats(int totalValidFileNum, int totalInputFileCount) {
        Date startDate = new Date();
        logPath = Paths.get(System.getProperty("LOGFILE_PATH"), new String[0]).normalize();
        DWSMain.printConsoleMessage("**************************************************************************");
        DWSMain.printConsoleMessage("Total number of files in input folder : " + totalInputFileCount);
        LOGGER.info("Total number of files in input folder : {}", (Object)totalInputFileCount);
        DWSMain.printConsoleMessage("Total number of valid files in input folder : " + totalValidFileNum);
        LOGGER.info("Total number of valid files in input folder : {}", (Object)totalValidFileNum);
        DWSMain.printConsoleMessage("Number of files failed : " + FAILED_FILES.size());
        LOGGER.info("Number of files failed : {}", (Object)FAILED_FILES.size());
        LOGGER.info("Name of files failed : {}", (Object)String.join((CharSequence)", ", FAILED_FILES));
        DWSMain.printConsoleMessage("Number of files migrated successfully : " + (totalValidFileNum - FAILED_FILES.size()));
        int diff = totalValidFileNum - FAILED_FILES.size();
        LOGGER.info("Number of files migrated successfully : {}", (Object)diff);
        DWSMain.printConsoleMessage("**************************************************************************");
        DWSMain.printConsoleMessage("Log file : dsc.log is placed in path : " + logPath);
        LOGGER.info("Log file : dsc.log is placed in path : {}", (Object)logPath);
        DWSMain.printConsoleMessage("Error Log file : dscError.log is placed in path : " + logPath);
        LOGGER.info("Error Log file : dscError.log is placed in path : {}", (Object)logPath);
        Date endDate = new Date();
        DWSMain.printConsoleMessage("DSC process end time : " + endDate);
        LOGGER.info("DSC process end time : {}", (Object)endDate);
        long timeInMS = endDate.getTime() - startDate.getTime();
        DWSMain.printConsoleMessage("Total process time : " + timeInMS + " ms");
        LOGGER.info("Total process time : {} ms", (Object)timeInMS);
    }

    public static void addFailedFile(String fileName) {
        FAILED_FILES.add(fileName);
    }

    static {
        FAILED_FILES = new ArrayList<String>();
        FAILED_SQL = new AtomicInteger(0);
        convertor = null;
        patternCnt = Pattern.compile("^\\d+?$");
        patternSize = Pattern.compile("(\\d+)\\s*(GB|MB|KB|B)");
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("file.encoding")));
        }
        catch (Exception e) {
            LOGGER.error("Error while creating buffer");
        }
    }
}

