/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.hwclouds.migration.common.config.ApplicationPropertyLoader;
import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.entity.PlaceHolderParam;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.common.util.ConvertRuntimeException;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.migration.pg.DWSMain;
import com.huawei.hwclouds.migration.pg.PgConvertor;
import com.huawei.hwclouds.migration.pg.cli.CliOptions;
import com.huawei.hwclouds.migration.pg.config.PgPropertyLoader;
import com.huawei.hwclouds.migration.pg.util.SqlString;
import com.huawei.hwclouds.migration.pg.util.StringBuilderWithCount;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigration
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DWSMigration.class);
    private static int fileNumber = 0;
    private final File inputFile;
    private final String outputFile;
    private PgConvertor convertor;
    private final int range;
    private final int countValidFiles;
    private List<String> successResultList;
    private List<String> failedResultList;
    private CliOptions options;
    private static final Pattern PROC_FINDER = Pattern.compile("(?i)^(CREATE)[\\s+](OR\\s+REPLACE\\s+)?(FUNCTION|LIBRARY|PACKAGE|PROCEDURE)(\\s+)([\\s\\S]*?)");
    private static final Pattern PROC_END = Pattern.compile("(?i)([\\s\\S]*?)\\$\\S*\\$;");
    private static final Pattern BEGIN_FINDER = Pattern.compile("(?i)^(BEGIN)(;?)(\\s+)([\\s\\S]*?)");
    private static final Pattern ALTER_TABLE_CONSTRAINT = Pattern.compile("(?i)^(ALTER)(\\s+)(TABLE)[\\S+\\s+]*(ADD)(\\s+)(Constraint)(\\s+)([\\s\\S]*?)");

    DWSMigration(File inFile, String outFile, int rangNum, int countValidFilesNum, List<String> successResultList, List<String> failedResultList, CliOptions options) {
        this.inputFile = inFile;
        this.outputFile = outFile;
        this.range = rangNum;
        this.countValidFiles = countValidFilesNum;
        this.convertor = new PgConvertor(null);
        this.successResultList = successResultList;
        this.failedResultList = failedResultList;
        this.options = options;
    }

    @Override
    public void run() {
        LOGGER.info("start migrate file : {}", (Object)this.inputFile.getName());
        try {
            String resSql;
            if (this.options.getSourceDialect() != null) {
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("table.origin.database.type", this.options.getSourceDialect().getValue().toLowerCase(Locale.ROOT));
                PgPropertyLoader.loadPropertyMap(propMap);
            }
            if ((resSql = DWSMigration.parseFile(this.inputFile, this.convertor, this.range, this.options.isRetry())) == null) {
                DWSMain.addFailedFile(this.inputFile.getName());
                return;
            }
            boolean fileCreate = CommonUtils.createNewFile(this.outputFile, false);
            if (!fileCreate) {
                LOGGER.error("Error while creating file");
                return;
            }
            String encodingFormat = DWSMigration.getEncodingFormat();
            FileUtils.write((File)new File(this.outputFile), (CharSequence)resSql, (String)encodingFormat);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse " + this.inputFile.getName(), (Throwable)e);
            try {
                FileUtils.copyFile((File)this.inputFile, (File)new File(this.outputFile));
            }
            catch (IOException pe) {
                LOGGER.error("Faild to copy file " + this.inputFile.getName());
            }
            DWSMain.addFailedFile(this.inputFile.getName());
        }
        int percent = 100;
        DWSMigration.incrementFileCounter();
        int status = this.countValidFiles > 0 ? fileNumber * 100 / this.countValidFiles : 0;
        DWSMain.printConsoleMessage(status + "% completed");
        StringBuilder resultBuilder = new StringBuilder();
        if (this.convertor.getFailCount() > 0) {
            resultBuilder.append("some sql failed, fileName:").append(this.inputFile.getName()).append(",total sql count:").append(this.convertor.getCount()).append(",fail sql count:").append(this.convertor.getFailCount()).append(".");
            this.failedResultList.add(resultBuilder.toString());
        } else {
            resultBuilder.append("all success, fileName:").append(this.inputFile.getName()).append(",total sql count:").append(this.convertor.getCount()).append(".");
            this.successResultList.add(resultBuilder.toString());
        }
    }

    private static void incrementFileCounter() {
        ++fileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseFile(File inputFile, PgConvertor convertor, int rangeNum, boolean retry) throws IOException {
        String encodingFormat = DWSMigration.getEncodingFormat();
        LineIterator it = FileUtils.lineIterator((File)inputFile, (String)encodingFormat);
        PlaceHolderParam placeHolderParam = new PlaceHolderParam(DWSMigration.getStringValue(convertor.getConfigs(), "param.config.flag", "table.output.placeholder.format"));
        MigrationContextUtil.setPlaceHolderParam(placeHolderParam);
        try {
            StringBuilder resSql = retry ? DWSMigration.retryConvertFile(inputFile.getName(), convertor, it) : DWSMigration.convertFile(inputFile.getName(), convertor, rangeNum, it);
            String string = resSql.toString();
            return string;
        }
        finally {
            MigrationContextUtil.removeContext();
            LineIterator.closeQuietly((LineIterator)it);
        }
    }

    public static StringBuilder retryConvertFile(String inputFileName, PgConvertor convertor, LineIterator it) {
        StringBuilder resSql = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        boolean inRetrySql = false;
        while (it.hasNext()) {
            String line = it.nextLine();
            if (inRetrySql) {
                if (sb.length() == 0 && line.trim().toUpperCase(Locale.ROOT).startsWith("\\COPY")) {
                    line = line.substring(line.indexOf("\\") + 1);
                    resSql.append("\\");
                }
                if (line.equals("sql end */;")) {
                    DWSMigration.convert(inputFileName, convertor, sb, resSql);
                    resSql.append(System.lineSeparator());
                    sb.delete(0, sb.length());
                    inRetrySql = false;
                    continue;
                }
                if (line.endsWith("*/;")) {
                    sb.append(System.lineSeparator());
                    sb.append(line, 0, line.length() - 3);
                    resSql.append(System.lineSeparator());
                    DWSMigration.convert(inputFileName, convertor, sb, resSql);
                    sb.delete(0, sb.length());
                    inRetrySql = false;
                    continue;
                }
                sb.append(System.lineSeparator());
                sb.append(line);
                continue;
            }
            if (line.startsWith("/* Sql syntax not supported") || line.startsWith("/* Sql parser failed")) {
                inRetrySql = true;
                continue;
            }
            resSql.append(System.lineSeparator());
            resSql.append(line);
        }
        return resSql;
    }

    public static StringBuilder convertFile(String inputFileName, PgConvertor convertor, Integer rangeNum, LineIterator it) {
        StringBuilder resSql = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        StringBuilderWithCount sbWithoutComment = new StringBuilderWithCount();
        StringBuilder storage = new StringBuilder();
        String storageLine = "";
        String firstLine = "";
        String preLine = "";
        while (it.hasNext() || DWSMigration.existStorage(storage, storageLine)) {
            String line;
            if (DWSMigration.existStorage(storage, storageLine)) {
                line = storageLine;
                sb.append((CharSequence)storage);
                storageLine = "";
                storage.delete(0, storage.length());
            } else {
                line = it.nextLine();
                int index = DWSMigration.getCommentIndex(line, sbWithoutComment);
                if (index > 0) {
                    storageLine = line.substring(index);
                    line = line.substring(0, index);
                }
            }
            if (line == null) continue;
            if (firstLine.isEmpty() && DWSMigration.isShell(line)) {
                resSql.append((CharSequence)sb);
                sb.delete(0, sb.length());
                resSql.append(line);
                resSql.append(System.lineSeparator());
                continue;
            }
            if (SqlString.isSqlComment(line, sbWithoutComment)) {
                line = DWSMigration.handleCommentLine(line);
                sb.append(line);
                sb.append(System.lineSeparator());
                DWSMigration.readComment(it, line, sb);
                continue;
            }
            if (firstLine.isEmpty() && line.trim().toUpperCase(Locale.ROOT).startsWith("\\COPY")) {
                line = line.substring(line.indexOf("\\") + 1);
                resSql.append("\\");
            }
            String lineTrim = line.trim();
            if (firstLine.isEmpty()) {
                firstLine = line;
            } else if ((preLine.startsWith("PARTITION ") || preLine.startsWith("SUBPARTITION ")) && lineTrim.startsWith("COLUMN ")) {
                if (!lineTrim.endsWith(",")) continue;
                line = ",";
            }
            preLine = lineTrim;
            line = DWSMigration.handleLine(line, sb);
            line = DWSMigration.readPlSql(sb, sbWithoutComment, it, line);
            if (line != null && (line.trim().endsWith(";") || DWSMigration.plsqlEnd(line, sb))) {
                sb.append(line);
                if (firstLine.trim().toUpperCase().startsWith("CREATE TABLE")) {
                    storageLine = DWSMigration.readAlterTable(sb, sbWithoutComment, storage, it);
                }
                int inputLen = sb.length();
                if (rangeNum != null && inputLen > rangeNum) {
                    LOGGER.error("validLength:{},inputLen;{}.sql:{}", (Object)rangeNum, (Object)inputLen, (Object)sb.toString());
                    LOGGER.error("Migration of the following file exceeds the max Sql Length: {}", (Object)inputFileName);
                    return resSql;
                }
                DWSMigration.convert(inputFileName, convertor, sb, resSql);
                sb.delete(0, sb.length());
                sbWithoutComment.delete(0, sbWithoutComment.length());
                firstLine = "";
                continue;
            }
            sb.append(line);
            sbWithoutComment.append(line);
            if ((line == null || line.isEmpty()) && sb.toString().trim().isEmpty()) {
                resSql.append(System.lineSeparator());
                continue;
            }
            sb.append(System.lineSeparator());
            sbWithoutComment.append(System.lineSeparator());
        }
        DWSMigration.convert(inputFileName, convertor, sb, resSql);
        return resSql;
    }

    private static int getCommentIndex(String line, StringBuilderWithCount sbWithoutComment) {
        int index = -1;
        if (!SqlString.isSqlComment(line, sbWithoutComment) && (line.contains("--") || line.contains("/*"))) {
            index = line.contains("--") && line.contains("/*") ? Math.min(line.indexOf("--"), line.indexOf("/*")) : (line.contains("--") ? line.indexOf("--") : line.indexOf("/*"));
        }
        return index;
    }

    private static String readComment(LineIterator it, String line, StringBuilder sb) {
        if (line.trim().startsWith("/*")) {
            int count = DWSMigration.readComment(line, 0);
            while (count > 0 && it.hasNext()) {
                line = it.nextLine();
                sb.append(line).append('\n');
                count = DWSMigration.readComment(line, count);
            }
        }
        return line;
    }

    private static int readComment(String line, int count) {
        int status = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (count == 0 && c == '-' && i + 1 < line.length() && line.charAt(i + 1) == '-') {
                return count;
            }
            if (status == 0) {
                if (c == '/') {
                    status = 1;
                    continue;
                }
                if (c != '*') continue;
                status = 2;
                continue;
            }
            if (status == 1) {
                if (c == '*') {
                    status = 0;
                    ++count;
                    continue;
                }
                if (c == '/') continue;
                status = 0;
                continue;
            }
            if (c == '/') {
                status = 0;
                --count;
                continue;
            }
            if (c == '*') continue;
            status = 0;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String inputFileName, PgConvertor convertor, StringBuilder sb, StringBuilder resSql) {
        String altString = sb.toString().toUpperCase(Locale.ROOT);
        if (altString.contains("SET @@") || altString.contains("SET @")) {
            StringBuilder sql = new StringBuilder();
            LOGGER.warn("Sql syntax not supported:PLSQL SET @@/@, FileName:" + inputFileName + ", OriSql:" + sb.toString());
            DWSMain.FAILED_SQL.incrementAndGet();
            resSql.append((CharSequence)sql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;"));
            return;
        }
        try {
            convertor.reset();
            convertor.parse(sb.toString());
            String sql = convertor.convert().getSql();
            SqlFormatter.Formatter of = SqlFormatter.of((Dialect)Dialect.PostgreSql).extend(cfg -> cfg.withIndexedPlaceholderTypes(Collections.emptyList()).plusReservedNewlineWords(new String[]{"CREATE", "DROP", "ALTER", "GRANT", "REVOKE", "TRUNCATE"}).plusSpecialWordChars(Arrays.asList("$", "{", "}", "`", "*", "/")));
            String format = SqlString.handleErrorRes(of.format(sql, MigrationContextUtil.getPlaceHolderMap()));
            format = format.replace(" E '", " E'");
            format = format.replace("| |", "||");
            format = format.replace("DWS_DSC_DOUBLE_DOLLAR", "$$");
            String escapeCharacters = DWSMigration.getStringValue(convertor.getConfigs(), "param.config.flag", "table.output.escape.character");
            if (escapeCharacters != null && !escapeCharacters.isEmpty()) {
                for (String escapeCharacter : escapeCharacters.split(" ")) {
                    format = format.replace(escapeCharacter, "\\" + escapeCharacter);
                }
            }
            resSql.append(format);
        }
        catch (Exception e) {
            convertor.setFailCount(convertor.getFailCount() + 1);
            DWSMigration.handleException(e, resSql, inputFileName, sb);
        }
        finally {
            MigrationContextUtil.clearPlaceholderParam();
            Integer count = convertor.getCount() + 1;
            Long time = new Date().getTime();
            Long elapsed = time - convertor.getLastTime();
            String logLine = DWSMigration.getShortLine(sb);
            LOGGER.info("inputFile name :{} , migrated count: {},elapsed this time: {} ms ,first line : {}", (Object)inputFileName, (Object)count, (Object)elapsed, (Object)logLine);
            convertor.setCount(count);
            convertor.setLastTime(time);
        }
        resSql.append(System.lineSeparator());
    }

    private static String getShortLine(StringBuilder sb) {
        String logLine = sb.length() > 50 ? sb.substring(0, 50) : sb.toString();
        int newlineIndex = logLine.indexOf("\r\n");
        if (newlineIndex > -1) {
            logLine = logLine.substring(0, newlineIndex);
        }
        return logLine;
    }

    private static void handleException(Exception e, StringBuilder resSql, String inputFile, StringBuilder sb) {
        DWSMain.FAILED_SQL.incrementAndGet();
        if (e instanceof ParserRuntimeException) {
            ParserRuntimeException exception = (ParserRuntimeException)e;
            LOGGER.error("Sql syntax not supported,exceptionCode:[{}],exceptionMessage:[{}],FileName:{}.", (Object)exception.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql syntax not supported, errorCode: ").append(exception.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("\r\n").append("sql end */;");
        } else if (e instanceof ParserException || e instanceof ConvertRuntimeException) {
            LOGGER.warn("Sql parser failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("\r\n").append("sql end */;");
        } else {
            LOGGER.warn("Sql convert failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionMessage(new Object[0])).append("\r\n").append((CharSequence)sb).append("\r\n").append("sql end */;");
        }
    }

    public static boolean isShell(String line) {
        String lowerCase = line.trim().toLowerCase(Locale.ROOT);
        return lowerCase.startsWith("psql ") || lowerCase.startsWith("hadoop ") || lowerCase.startsWith("\\\\") || lowerCase.startsWith("refresh ") || lowerCase.startsWith("msck repair ") || lowerCase.startsWith("${") || lowerCase.startsWith("\\o") || lowerCase.startsWith("psql -a") || lowerCase.equalsIgnoreCase("!EOF") || lowerCase.equalsIgnoreCase("0");
    }

    public static String handleLine(String line, StringBuilder sb) {
        if (line == null || line.isEmpty()) {
            return line;
        }
        String lastLineTrim = DWSMigration.getLastLine(sb).trim();
        String lineTrim = line.trim();
        if (!lastLineTrim.contains("--") && lastLineTrim.endsWith("'") && lineTrim.startsWith("'")) {
            line = "||" + line;
        }
        if (lineTrim.endsWith(";;")) {
            line = line.replaceAll(";;", ";");
        }
        line = line.replaceAll("\\\\\"", "\"");
        line = line.replaceAll("\u00a0", " ");
        return line;
    }

    public static String getLastLine(StringBuilder sb) {
        if (sb == null || sb.length() == 0) {
            return "";
        }
        String string = sb.toString().trim();
        int lastNewLineIndex = string.lastIndexOf(System.lineSeparator());
        if (lastNewLineIndex == -1) {
            return string;
        }
        return sb.substring(lastNewLineIndex + System.lineSeparator().length());
    }

    public static String handleCommentLine(String line) {
        String lineTrim = line.trim();
        if (lineTrim.startsWith("#")) {
            line = line.replaceFirst("#", "--");
        }
        return line;
    }

    private static String readPlSql(StringBuilder sb, StringBuilderWithCount sbWithoutComment, LineIterator it, String line) {
        Matcher beginMatcher;
        String[] s = sbWithoutComment.toString().split("\r?\n");
        StringBuilder plsql = new StringBuilder();
        for (String value : s) {
            if (SqlString.isSqlComment(value, sbWithoutComment)) continue;
            plsql.append(value.trim());
        }
        plsql.append(line.trim()).append(System.lineSeparator());
        String plsqlStr = plsql.toString().toUpperCase(Locale.ROOT);
        boolean languageC = plsqlStr.contains("LANGUAGE C");
        Matcher plsqlMatcher = PROC_FINDER.matcher(plsql);
        if ((plsqlMatcher.matches() || plsqlStr.startsWith("DO ")) && it.hasNext()) {
            sb.append(line).append('\n');
            line = it.nextLine();
            boolean bl = languageC = languageC || line.toUpperCase(Locale.ROOT).contains("LANGUAGE C");
            while (!DWSMigration.functionEnd(sb, line, languageC) || line.endsWith("*/")) {
                if (line.toUpperCase(Locale.ROOT).contains("FOR") || line.toUpperCase(Locale.ROOT).trim().startsWith("IN")) {
                    line = line.replace("..", " .. ");
                }
                line = DWSMigration.handleCommentLine(line);
                sb.append(line).append('\n');
                if (!it.hasNext()) break;
                line = it.nextLine();
            }
        }
        if ((beginMatcher = BEGIN_FINDER.matcher(plsql)).matches() && !plsql.toString().replace(" ", "").equalsIgnoreCase("begintransaction;")) {
            sb.append(line).append('\n');
            if (it.hasNext()) {
                line = it.nextLine();
                while (!line.trim().equalsIgnoreCase("END;") && !line.trim().equalsIgnoreCase("end transaction;")) {
                    line = DWSMigration.handleCommentLine(line);
                    sb.append(line).append('\n');
                    if (!it.hasNext()) break;
                    line = it.nextLine();
                }
            }
        }
        return line;
    }

    private static String readAlterTable(StringBuilder sb, StringBuilderWithCount sbWithoutComment, StringBuilder storage, LineIterator it) {
        String line = null;
        while (it.hasNext()) {
            line = it.nextLine();
            if (line == null || line.isEmpty()) continue;
            if (SqlString.isSqlComment(line, sbWithoutComment)) {
                line = DWSMigration.handleCommentLine(line);
                storage.append(line);
                storage.append(System.lineSeparator());
                DWSMigration.readComment(it, line, storage);
                line = null;
                continue;
            }
            Matcher plsqlMatcher = ALTER_TABLE_CONSTRAINT.matcher(line);
            if (!plsqlMatcher.matches()) {
                return line;
            }
            if (line.trim().endsWith(";")) {
                sb.append((CharSequence)storage).append(line);
                storage.delete(0, storage.length());
                return "";
            }
            storage.append(line).append(System.lineSeparator());
        }
        return line;
    }

    private static boolean functionEnd(StringBuilder sb, String line, boolean languageC) {
        if (languageC) {
            return line.trim().endsWith(";");
        }
        return DWSMigration.plsqlEnd(line, sb);
    }

    private static boolean plsqlEnd(String line, StringBuilder sb) {
        String lineTrim = line.trim();
        Matcher matcher = PROC_END.matcher(lineTrim);
        return sb.toString().trim().endsWith(";") && lineTrim.endsWith("/") && !lineTrim.endsWith("*/") || lineTrim.endsWith("END_PROC;") || matcher.matches() || (lineTrim.contains("LANGUAGE c") || lineTrim.contains("LANGUAGE sql") || lineTrim.contains("LANGUAGE plpgsql") || lineTrim.contains("LANGUAGE plpythonu")) && lineTrim.endsWith(";");
    }

    private static String getEncodingFormat() {
        String encodingFormat = null;
        encodingFormat = ApplicationPropertyLoader.getStringProperty("encodingFormat");
        if (encodingFormat.equals("")) {
            encodingFormat = "UTF8";
            LOGGER.info("Files encoding is set to default UTF8");
        }
        LOGGER.info("Files encoding is set from configuration in Application properties file : {}", (Object)encodingFormat);
        return encodingFormat;
    }

    private static boolean existStorage(StringBuilder storage, String storageLine) {
        return storage.length() > 0 || storageLine != null && !storageLine.isEmpty();
    }

    public static String getStringValue(Map<String, ConvertConfig> configs, String configKey, String paramKey) {
        ConvertConfig dwsConfig = configs.get(configKey.toUpperCase(Locale.ROOT));
        if (dwsConfig != null) {
            return dwsConfig.getStringValue(paramKey);
        }
        return null;
    }
}

