/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.pg.DWSConfig;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.SqlRoot;
import com.huawei.hwclouds.migration.pg.parser.PgEntranceParser;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.util.SqlString;
import com.huawei.hwclouds.migration.pg.writer.SqlPrettyWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PgConvertor
implements DatabaseConvertor {
    private SqlRoot root = null;
    private SqlDialect dialect = SqlDialect.DWS;
    private DWSConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs;
    private Integer count = 0;
    private Integer failCount = 0;
    private Long lastTime = new Date().getTime();

    public PgConvertor(Map<String, DWSConfig> configs) {
        this(null, configs);
    }

    public PgConvertor(DWSConfig dwsConfig, Map<String, DWSConfig> configs) {
        this.tableConfigs = new HashMap<String, ConvertConfig>();
        this.defaultConfig = dwsConfig == null ? DWSConfig.buildConfig() : dwsConfig;
        Map<String, DWSConfig> tableDefaultConfigs = DWSConfig.loadTableConfigs();
        for (Map.Entry<String, DWSConfig> et : tableDefaultConfigs.entrySet()) {
            this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
        }
        if (configs != null) {
            for (Map.Entry<String, DWSConfig> et : configs.entrySet()) {
                this.tableConfigs.put(et.getKey().toUpperCase(Locale.ROOT), et.getValue().clone().merge(this.defaultConfig));
            }
        } else {
            this.tableConfigs.put("param.config.flag".toUpperCase(Locale.ROOT), this.defaultConfig);
        }
    }

    public void parse(String sql) throws ParserException {
        PgEntranceParser parser = new PgEntranceParser();
        SqlRoot sqlNode = parser.parse(sql);
        if (this.root == null) {
            this.root = sqlNode;
        } else {
            this.root.addNode(sqlNode);
        }
    }

    public SqlString convert() throws ParserException {
        if (this.root == null) {
            throw new ParserException("No parse sql defined.");
        }
        UnParserContext context = new UnParserContext();
        SqlPrettyWriter writer = new SqlPrettyWriter(this.dialect, this.defaultConfig, this.tableConfigs);
        this.root.unParse(writer, context);
        return writer.toSqlString();
    }

    public void reset() {
        this.root = new SqlRoot();
    }

    public Map<String, ConvertConfig> getConfigs() {
        return this.tableConfigs;
    }

    public Long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getFailCount() {
        return this.failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }
}

