/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.pg.PgConvertor;
import com.huawei.hwclouds.migration.pg.config.PgPropertyLoader;
import com.huawei.hwclouds.migration.pg.util.SqlString;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SingleClauseConvert {
    private static final Logger LOGGER = LogManager.getLogger(SingleClauseConvert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(String fromDb, String toDb, String originSql, boolean needOriClause) throws ParserException {
        PgConvertor convertor = new PgConvertor(null);
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("table.origin.database.type", fromDb);
        if (!toDb.equalsIgnoreCase("DWS")) {
            LOGGER.error("The target database \"" + toDb + "\" is not supported for single statement conversion. Only DWS is supported for now.");
            throw new ParserException("The target database \"" + toDb + "\" is not supported for single statement conversion. Only DWS is supported for now.");
        }
        StringBuilder sb = new StringBuilder();
        String line = originSql;
        try {
            PgPropertyLoader.loadPropertyMap(propMap);
            sb.append(line);
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = convertor.convert();
            sb.delete(0, sb.length());
            String beforeFormat = str.toString().replaceAll("\\s+", "");
            String afterFormat = SqlFormatter.format((String)str.toString()).replaceAll("\\s+", "");
            if (beforeFormat.equalsIgnoreCase(afterFormat)) {
                String string = SqlString.handleErrorRes(SqlFormatter.format((String)str.toString()));
                return string;
            }
            String string = str.toString();
            return string;
        }
        catch (Exception e) {
            String string;
            LOGGER.error("Can't Convert The Sql \n" + line);
            if (needOriClause) {
                string = line;
                return string;
            }
            string = "/* sql not support\r\n" + line + "\r*/;";
            return string;
        }
        finally {
            PgPropertyLoader.clearPropMapCxt();
        }
    }
}

