/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.pg.nodes.AlterTablePartitionAction;
import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.PartitionElement;
import com.huawei.hwclouds.migration.pg.nodes.SplitClause;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.PartitionElementVisitor;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class AlterTablePartitionActionVisitor
extends AbstractVisitor<AlterTablePartitionAction> {
    private final AlterTablePartitionAction result = new AlterTablePartitionAction();

    @Override
    protected AlterTablePartitionAction defaultResult() {
        return this.result;
    }

    @Override
    public AlterTablePartitionAction visitAlterTablePartitionAction(PostgreSQLParser.AlterTablePartitionActionContext ctx) {
        if (ctx.ALTER() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "alter partition", "alter");
        }
        if (ctx.TRUNCATE() != null) {
            this.result.setAction(ctx.TRUNCATE().getText());
        } else if (ctx.DROP() != null) {
            this.result.setAction(ctx.DROP().getText());
        } else {
            if (ctx.ADD_P() != null) {
                this.result.setAction(ctx.ADD_P().getText());
                this.result.setPartitionElement((PartitionElement)new PartitionElementVisitor().visit((ParseTree)ctx.partitionElement()));
                return this.defaultResult();
            }
            if (ctx.SPLIT() != null) {
                this.result.setAction(ctx.SPLIT().getText());
                SplitClause splitClause = new SplitClause();
                splitClause.setAtPartition(ctx.at_expression.getText());
                List<PostgreSQLParser.NameValueContext> nameValues = ctx.into_clause().nameValue();
                List<String> partitionFragments = nameValues.stream().map(nameValue -> nameValue.getText()).collect(Collectors.toList());
                splitClause.setIntoPartitions(partitionFragments);
                this.result.setSplitClause(splitClause);
            }
        }
        if (ctx.DEFAULT() != null && ctx.PARTITION() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "default partition", "DEFAULT");
        }
        if (ctx.IF_P() != null && ctx.EXISTS() != null) {
            this.result.setIfExists(true);
        }
        if (ctx.partition_name != null) {
            this.result.setPartitionName(ctx.partition_name.getText());
        } else if (ctx.expression() != null && !ctx.expression().isEmpty()) {
            SqlNodeList<Expression> expressionList = new SqlNodeList<Expression>();
            ctx.expression().forEach(expressionContext -> expressionList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionContext)));
            this.result.setExpressionList(expressionList);
        }
        return this.defaultResult();
    }
}

