/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.pg.nodes.ActionAlterAll;
import com.huawei.hwclouds.migration.pg.nodes.ActionAlterIndex;
import com.huawei.hwclouds.migration.pg.nodes.ActionAlterOtherElement;
import com.huawei.hwclouds.migration.pg.nodes.ActionAlterTable;
import com.huawei.hwclouds.migration.pg.nodes.AlterTableCmd;
import com.huawei.hwclouds.migration.pg.nodes.AlterTableStmt;
import com.huawei.hwclouds.migration.pg.nodes.PartitionBoundSpec;
import com.huawei.hwclouds.migration.pg.nodes.PartitionCmd;
import com.huawei.hwclouds.migration.pg.nodes.RelationExpr;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.AlterTableCmdVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.PartitionBoundSpecVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.QualifiedNameVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.RelationExprVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;

public class AlterTableStmtVisitor
extends AbstractVisitor<AlterTableStmt> {
    private AlterTableStmt alterTableStmt = new AlterTableStmt();

    @Override
    protected AlterTableStmt defaultResult() {
        return this.alterTableStmt;
    }

    @Override
    public AlterTableStmt visitActionAlterTable(PostgreSQLParser.ActionAlterTableContext ctx) {
        ActionAlterTable actionAlterTable = new ActionAlterTable();
        actionAlterTable.setForeignTable(ctx.FOREIGN() != null);
        actionAlterTable.setIfExists(ctx.EXISTS() != null);
        actionAlterTable.setRelationExpr((RelationExpr)new RelationExprVisitor().visit((ParseTree)ctx.relationExpr()));
        if (ctx.alterTableCmds() != null) {
            PostgreSQLParser.AlterTableCmdsContext alterTableCmdsContext = ctx.alterTableCmds();
            SqlNodeList<AlterTableCmd> alterTableCmdSqlNodeList = this.getAlterTableCmdSqlNodeList(alterTableCmdsContext);
            actionAlterTable.setAlterTableCmdSqlNodeList(alterTableCmdSqlNodeList);
        } else {
            PartitionCmd partitionCmd = new PartitionCmd();
            PostgreSQLParser.PartitionCmdContext partitionCmdContext = ctx.partitionCmd();
            partitionCmd.setActionType(partitionCmdContext.ATTACH() != null ? partitionCmdContext.ATTACH().getText() : partitionCmdContext.DETACH().getText());
            partitionCmd.setQualifiedName(QualifiedNameVisitor.visitQualifiedNameText(partitionCmdContext.qualifiedName()));
            if (partitionCmdContext.partitionBoundSpec() != null) {
                partitionCmd.setPartitionBoundSpec((PartitionBoundSpec)new PartitionBoundSpecVisitor().visit((ParseTree)partitionCmdContext.partitionBoundSpec()));
            }
        }
        this.alterTableStmt.setActionAlterTable(actionAlterTable);
        return this.defaultResult();
    }

    @Override
    public AlterTableStmt visitActionAlterIndex(PostgreSQLParser.ActionAlterIndexContext ctx) {
        ActionAlterIndex actionAlterIndex = new ActionAlterIndex();
        actionAlterIndex.setIfExists(ctx.EXISTS() != null);
        actionAlterIndex.setQualifiedName(QualifiedNameVisitor.visitQualifiedNameText(ctx.qualifiedName()));
        if (ctx.alterTableCmds() != null) {
            PostgreSQLParser.AlterTableCmdsContext alterTableCmdsContext = ctx.alterTableCmds();
            SqlNodeList<AlterTableCmd> alterTableCmdSqlNodeList = this.getAlterTableCmdSqlNodeList(alterTableCmdsContext);
            actionAlterIndex.setAlterTableCmdSqlNodeList(alterTableCmdSqlNodeList);
        } else {
            actionAlterIndex.setIndexPartitionCmd("ATTACH PARTITION " + (Object)((Object)ctx.indexPartitionCmd().qualifiedName()));
        }
        this.alterTableStmt.setActionAlterIndex(actionAlterIndex);
        return this.defaultResult();
    }

    @Override
    public AlterTableStmt visitActionAlterAll(PostgreSQLParser.ActionAlterAllContext ctx) {
        ActionAlterAll actionAlterAll = new ActionAlterAll();
        if (ctx.TABLE() != null) {
            actionAlterAll.setAlterElement(ctx.TABLE().getText());
        } else if (ctx.INDEX() != null) {
            actionAlterAll.setAlterElement(ctx.INDEX().getText());
        } else {
            actionAlterAll.setAlterElement(ctx.MATERIALIZED().getText() + " " + ctx.VIEW().getText());
        }
        actionAlterAll.setOldName(ctx.oldName.getText());
        if (ctx.roleList() != null) {
            ArrayList<String> roleList = new ArrayList<String>();
            for (int i = 0; i < ctx.roleList().roleSpec().size(); ++i) {
                roleList.add(ctx.roleList().roleSpec().get(i).getText());
            }
            actionAlterAll.setRoleList(roleList);
        }
        actionAlterAll.setNewName(ctx.newName.getText());
        this.alterTableStmt.setActionAlterAll(actionAlterAll);
        return this.defaultResult();
    }

    @Override
    public AlterTableStmt visitActionAlterOtherElement(PostgreSQLParser.ActionAlterOtherElementContext ctx) {
        ActionAlterOtherElement actionAlterOtherElement = new ActionAlterOtherElement();
        if (ctx.SEQUENCE() != null) {
            actionAlterOtherElement.setAlterElement(ctx.SEQUENCE().getText());
        } else if (ctx.VIEW() != null) {
            actionAlterOtherElement.setAlterElement(ctx.VIEW().getText());
        } else {
            actionAlterOtherElement.setAlterElement(ctx.MATERIALIZED() + " " + ctx.VIEW().getText());
        }
        actionAlterOtherElement.setQualifiedName(QualifiedNameVisitor.visitQualifiedNameText(ctx.qualifiedName()));
        if (ctx.alterTableCmds() != null) {
            PostgreSQLParser.AlterTableCmdsContext alterTableCmdsContext = ctx.alterTableCmds();
            SqlNodeList<AlterTableCmd> alterTableCmdSqlNodeList = this.getAlterTableCmdSqlNodeList(alterTableCmdsContext);
            actionAlterOtherElement.setAlterTableCmdSqlNodeList(alterTableCmdSqlNodeList);
        }
        this.alterTableStmt.setActionAlterOtherElement(actionAlterOtherElement);
        return this.defaultResult();
    }

    private SqlNodeList<AlterTableCmd> getAlterTableCmdSqlNodeList(PostgreSQLParser.AlterTableCmdsContext context) {
        SqlNodeList<AlterTableCmd> alterTableCmdSqlNodeList = new SqlNodeList<AlterTableCmd>();
        for (int i = 0; i < context.alterTableCmd().size(); ++i) {
            alterTableCmdSqlNodeList.addNode((AlterTableCmd)new AlterTableCmdVisitor().visit((ParseTree)context.alterTableCmd().get(i)));
        }
        return alterTableCmdSqlNodeList;
    }
}

