/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.annotation.ParseComment;
import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.migration.pg.nodes.Indirection;
import com.huawei.hwclouds.migration.pg.nodes.QualifiedName;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.IndirectionVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

@ParseComment(value=CommentPosition.INLIST)
public class QualifiedNameVisitor
extends AbstractVisitor<QualifiedName> {
    private final QualifiedName qualifiedName = new QualifiedName();

    @Override
    protected QualifiedName defaultResult() {
        return this.qualifiedName;
    }

    @Override
    public QualifiedName visitQualifiedName(PostgreSQLParser.QualifiedNameContext ctx) {
        this.qualifiedName.setColId(ctx.colId().getText());
        if (ctx.indirection() != null) {
            this.qualifiedName.setIndirection((Indirection)new IndirectionVisitor().visit((ParseTree)ctx.indirection()));
        }
        return this.defaultResult();
    }

    public static String visitQualifiedNameText(PostgreSQLParser.QualifiedNameContext ctx) {
        StringBuilder sb = new StringBuilder();
        String colId = ctx.colId().getText().replace("$$", "DWS_DSC_DOUBLE_DOLLAR");
        sb.append(colId);
        if (ctx.indirection() != null && ctx.indirection().indirectionEl() != null) {
            ctx.indirection().indirectionEl().forEach(indirectionElContext -> {
                if (indirectionElContext.DOT_DOT() != null) {
                    sb.append(".").append(indirectionElContext.attrName() != null ? indirectionElContext.attrName().getText() : indirectionElContext.STAR().getText());
                } else {
                    sb.append(indirectionElContext.getText());
                }
            });
        }
        return sb.toString();
    }
}

