/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.pg.nodes.FunctionWithArgTypes;
import com.huawei.hwclouds.migration.pg.nodes.PrivilegeClause;
import com.huawei.hwclouds.migration.pg.nodes.RevokeStmt;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.FunctionWithArgTypesVisitor;
import java.util.ArrayList;

public class RevokeStmtVisitor
extends AbstractVisitor<RevokeStmt> {
    private final RevokeStmt result = new RevokeStmt();

    @Override
    protected RevokeStmt defaultResult() {
        return this.result;
    }

    @Override
    public RevokeStmt visitRevokestmt(PostgreSQLParser.RevokestmtContext ctx) {
        if (ctx.GRANT() != null) {
            this.result.setGrant(true);
        }
        PostgreSQLParser.PrivilegesContext privilegesContext = ctx.privileges();
        SqlNodeList<PrivilegeClause> privileges = new SqlNodeList<PrivilegeClause>();
        if (privilegesContext.privilegeList() != null) {
            privilegesContext.privilegeList().privilege().forEach(privilegeContext -> privileges.addNode(this.getPrivilege((PostgreSQLParser.PrivilegeContext)((Object)privilegeContext))));
        } else {
            PrivilegeClause revokePrivilege = new PrivilegeClause();
            if (privilegesContext.PRIVILEGES() != null) {
                revokePrivilege.setPrivilege(privilegesContext.ALL().getText() + " " + privilegesContext.PRIVILEGES().getText());
            } else {
                revokePrivilege.setPrivilege(privilegesContext.ALL().getText());
            }
            if (privilegesContext.columnlist() != null) {
                ArrayList<String> columnList = new ArrayList<String>();
                privilegesContext.columnlist().columnElem().forEach(columnElemContext -> columnList.add(columnElemContext.getText()));
                revokePrivilege.setColumnList(columnList);
            }
            privileges.addNode(revokePrivilege);
        }
        this.result.setPrivileges(privileges);
        PostgreSQLParser.PrivilegeTargetContext privilegeTargetContext = ctx.privilegeTarget();
        this.result.setPrivilegeTarget(CommonUtils.getText(privilegeTargetContext.privilegeTargetType()));
        if (privilegeTargetContext.functionWithArgtypesList() != null) {
            SqlNodeList<FunctionWithArgTypes> targetFunctionList = new SqlNodeList<FunctionWithArgTypes>();
            privilegeTargetContext.functionWithArgtypesList().functionWithArgTypes().forEach(functionWithArgTypesContext -> targetFunctionList.addNode(functionWithArgTypesContext.accept(new FunctionWithArgTypesVisitor())));
            this.result.setTargetFunctionList(targetFunctionList);
        } else if (privilegeTargetContext.qualifiedNameList() != null) {
            ArrayList<String> targetColumnList = new ArrayList<String>();
            privilegeTargetContext.qualifiedNameList().qualifiedName().forEach(qualifiedNameContext -> targetColumnList.add(CommonUtils.getText(qualifiedNameContext)));
            this.result.setTargetNameList(targetColumnList);
        }
        ArrayList<String> granteeList = new ArrayList<String>();
        ctx.granteeList().grantee().forEach(granteeContext -> granteeList.add(CommonUtils.getText(granteeContext)));
        this.result.setGranteeList(granteeList);
        if (ctx.optDropBehavior() != null) {
            this.result.setOptDropBehavior(ctx.optDropBehavior().getText());
        }
        return this.defaultResult();
    }

    private PrivilegeClause getPrivilege(PostgreSQLParser.PrivilegeContext privilegeContext) {
        PrivilegeClause revokePrivilege = new PrivilegeClause();
        revokePrivilege.setPrivilege(privilegeContext.privilegeType().getText());
        if (privilegeContext.optColumnList() != null) {
            ArrayList<String> columnList = new ArrayList<String>();
            privilegeContext.optColumnList().columnlist().columnElem().forEach(columnElemContext -> columnList.add(columnElemContext.getText()));
            revokePrivilege.setColumnList(columnList);
        }
        return revokePrivilege;
    }
}

