/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.pg.nodes.BitType;
import com.huawei.hwclouds.migration.pg.nodes.CharacterType;
import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.GenericType;
import com.huawei.hwclouds.migration.pg.nodes.IntervalType;
import com.huawei.hwclouds.migration.pg.nodes.NumericType;
import com.huawei.hwclouds.migration.pg.nodes.OtherType;
import com.huawei.hwclouds.migration.pg.nodes.SimpleTypeName;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.nodes.SqlTypeName;
import com.huawei.hwclouds.migration.pg.nodes.TimeType;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ExpressionVisitor;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;

public class SimpleTypeNameVisitor
extends AbstractVisitor<SimpleTypeName> {
    private SimpleTypeName simpleTypeName = new SimpleTypeName();

    @Override
    protected SimpleTypeName defaultResult() {
        return this.simpleTypeName;
    }

    @Override
    public SimpleTypeName visitTypeGeneric(PostgreSQLParser.TypeGenericContext ctx) {
        GenericType genericType = new GenericType();
        String name = "";
        if (ctx.genericType().builtinFunctionName() != null) {
            name = ctx.genericType().builtinFunctionName().getText();
        } else if (ctx.genericType().typeFunctionName() != null) {
            name = ctx.genericType().typeFunctionName().getText();
        } else {
            String string = name = ctx.genericType().LEFT() != null ? "LEFT" : "RIGHT";
        }
        if (ctx.genericType().attrs() != null) {
            name = name + ctx.genericType().attrs().getText();
        }
        genericType.setName(name);
        SqlNodeList<Expression> expressionSqlNodeList = new SqlNodeList<Expression>();
        for (int i = 0; i < ctx.genericType().optTypeModifiers().exprList().expression().size(); ++i) {
            Expression expression = (Expression)new ExpressionVisitor().visit((ParseTree)ctx.genericType().optTypeModifiers().exprList().expression().get(i));
            expressionSqlNodeList.addNode(expression);
        }
        genericType.setOptTypeModifiers(expressionSqlNodeList);
        this.simpleTypeName.setGenerictype(genericType);
        return this.defaultResult();
    }

    @Override
    public SimpleTypeName visitTypeNumeric(PostgreSQLParser.TypeNumericContext ctx) {
        NumericType numericType = new NumericType();
        if (ctx.numericType().numeric().DOUBLE_P() != null) {
            numericType.setNumeric(SqlTypeName.DOUBLE_PRECISION);
        } else {
            numericType.setNumeric(SqlTypeName.valueOf(ctx.numericType().numeric().getText().trim().toUpperCase(Locale.ROOT)));
        }
        if (ctx.numericType().numericPar != null) {
            SqlNodeList<Expression> expressionSqlNodeList = new SqlNodeList<Expression>();
            for (int i = 0; i < ctx.numericType().optTypeModifiers().exprList().expression().size(); ++i) {
                Expression expression = (Expression)new ExpressionVisitor().visit((ParseTree)ctx.numericType().optTypeModifiers().exprList().expression().get(i));
                expressionSqlNodeList.addNode(expression);
            }
            numericType.setOptTypeModifiers(expressionSqlNodeList);
        }
        this.simpleTypeName.setNumericType(numericType);
        return this.defaultResult();
    }

    @Override
    public SimpleTypeName visitTypeBit(PostgreSQLParser.TypeBitContext ctx) {
        BitType bitType = new BitType();
        PostgreSQLParser.BitTypeContext bitTypeContext = ctx.bitType();
        if (bitTypeContext.BIT() != null) {
            bitType.setTypeName("BIT");
            bitType.setExistVarying(ctx.bitType().VARYING() != null);
        } else if (bitTypeContext.BYTEINT() != null) {
            bitType.setTypeName("BYTEINT");
        } else if (bitTypeContext.VARBINARY() != null) {
            bitType.setTypeName("VARBINARY");
        } else if (bitTypeContext.BYTEA() != null) {
            bitType.setTypeName("BYTEA");
        }
        if (bitTypeContext.iConst() != null) {
            bitType.setIConst(bitTypeContext.iConst().getText());
        }
        this.simpleTypeName.setBitType(bitType);
        return this.defaultResult();
    }

    @Override
    public SimpleTypeName visitTypeCharacter(PostgreSQLParser.TypeCharacterContext ctx) {
        CharacterType characterType = new CharacterType();
        String characterName = "";
        for (int i = 0; i < ctx.characterType().character().getChildCount(); ++i) {
            characterName = characterName + ctx.characterType().character().getChild(i).getText() + " ";
        }
        characterType.setCharacterName(SqlTypeName.valueOf(characterName.trim().replaceAll("\\s", "").toUpperCase(Locale.ROOT)));
        if (ctx.characterType().characterPar != null) {
            characterType.setIConst(ctx.characterType().iConst().getText());
        }
        this.simpleTypeName.setCharacterType(characterType);
        return this.defaultResult();
    }

    @Override
    public SimpleTypeName visitTypeInterval(PostgreSQLParser.TypeIntervalContext ctx) {
        IntervalType intervalType = new IntervalType();
        if (ctx.intervalType().optInterval() != null) {
            String value = "";
            for (int i = 0; i < ctx.intervalType().optInterval().getChildCount(); ++i) {
                value = value + ctx.intervalType().optInterval().getChild(i).getText() + " ";
            }
            intervalType.setOptInterval(value);
        } else if (ctx.intervalType().iConst() != null) {
            intervalType.setIConst(ctx.intervalType().iConst().getText());
        }
        this.simpleTypeName.setIntervalType(intervalType);
        return this.defaultResult();
    }

    @Override
    public SimpleTypeName visitTypeTime(PostgreSQLParser.TypeTimeContext ctx) {
        TimeType timeType = new TimeType();
        timeType.setTypeName(SqlTypeName.valueOf(ctx.timeType().timeTypeName().getText().trim().toUpperCase(Locale.ROOT)));
        if (ctx.timeType().timePar != null) {
            timeType.setIConst(ctx.timeType().iConst().getText());
        }
        if (ctx.timeType().optTimezone() != null) {
            if (ctx.timeType().optTimezone().WITH() != null) {
                timeType.setTimeZone("WITH TIME ZONE");
            } else {
                timeType.setTimeZone("WITHOUT TIME ZONE");
            }
        }
        this.simpleTypeName.setTimeType(timeType);
        return this.defaultResult();
    }

    @Override
    public SimpleTypeName visitTypeOther(PostgreSQLParser.TypeOtherContext ctx) {
        OtherType otherType = new OtherType();
        otherType.setTypeName(ctx.getText());
        this.simpleTypeName.setOtherType(otherType);
        return this.defaultResult();
    }
}

