/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.AlterOptRoleElem;
import com.huawei.hwclouds.migration.pg.nodes.AlterRoleStmt;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.ArrayList;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=AlterRoleStmt.class)
public class AlterRoleStmtUnParser
implements UnParser<AlterRoleStmt> {
    private static final String CREATE_EXT_TABLE = "CREATEEXTTABLE";
    private static final String NO_CREATE_EXT_TABLE = "NOCREATEEXTTABLE";

    @Override
    public void unParse(AlterRoleStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("ALTER ");
        writer.append(sqlNode.getRole()).writeSpace();
        sqlNode.getRoleSpec().unParse(writer, context);
        if (sqlNode.isWith()) {
            writer.append(" WITH");
        }
        ArrayList<AlterOptRoleElem> alterOptRoleList = new ArrayList<AlterOptRoleElem>();
        boolean existsCreateExtTable = sqlNode.getAlterOptRoleList().getNodes().stream().anyMatch(node -> CREATE_EXT_TABLE.equalsIgnoreCase(node.getKeyWord()));
        boolean handleFlag = false;
        for (AlterOptRoleElem node2 : sqlNode.getAlterOptRoleList().getNodes()) {
            if (CREATE_EXT_TABLE.equalsIgnoreCase(node2.getKeyWord()) || NO_CREATE_EXT_TABLE.equalsIgnoreCase(node2.getKeyWord())) {
                if (handleFlag) continue;
                node2.setKeyWord(existsCreateExtTable ? CREATE_EXT_TABLE : NO_CREATE_EXT_TABLE);
                handleFlag = true;
            }
            alterOptRoleList.add(node2);
        }
        alterOptRoleList.forEach(alterOptRoleElem -> {
            writer.writeSpace();
            alterOptRoleElem.unParse(writer, context);
        });
    }
}

