/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.AlterTablePartitionAction;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=AlterTablePartitionAction.class)
public class AlterTablePartitionActionUnParser
implements UnParser<AlterTablePartitionAction> {
    @Override
    public void unParse(AlterTablePartitionAction sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(sqlNode.getAction());
        if (sqlNode.getPartitionElement() != null) {
            writer.writeSpace();
            sqlNode.getPartitionElement().unParse(writer, context);
            return;
        }
        if (sqlNode.isDefaultPartition()) {
            writer.writeSpace().append("DEFAULT PARTITION");
        } else {
            writer.writeSpace().append(" PARTITION");
            if (sqlNode.isIfExists() && (sqlNode.getAction().equalsIgnoreCase("TRUNCATE") || sqlNode.getAction().equalsIgnoreCase("DROP"))) {
                writer.writeSpace().append(" IF EXISTS");
            }
        }
        if (sqlNode.getPartitionName() != null) {
            writer.writeSpace().append(sqlNode.getPartitionName());
        } else if (sqlNode.getExpressionList() != null) {
            writer.writeSpace().append("FOR (");
            sqlNode.getExpressionList().unParse(writer, context);
            writer.append(")");
        }
        if (sqlNode.getSplitClause() != null) {
            sqlNode.getSplitClause().unParse(writer, context);
        }
    }
}

