/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.ActionAlterTable;
import com.huawei.hwclouds.migration.pg.nodes.AlterTableCmd;
import com.huawei.hwclouds.migration.pg.nodes.AlterTableStmt;
import com.huawei.hwclouds.migration.pg.nodes.SplitClause;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=AlterTableStmt.class)
public class AlterTableStmtUnParser
implements UnParser<AlterTableStmt> {
    @Override
    public void unParse(AlterTableStmt sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getActionAlterTable() != null) {
            ActionAlterTable actionAlterTable = sqlNode.getActionAlterTable();
            if (actionAlterTable.isForeignTable()) {
                throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "Alter foreign table", "FOREIGN");
            }
            writer.append("ALTER TABLE ");
            if (actionAlterTable.isIfExists()) {
                writer.append("IF EXISTS ");
            }
            actionAlterTable.getRelationExpr().unParse(writer, context);
            String partitionName = null;
            if (actionAlterTable.getAlterTableCmdSqlNodeList() != null) {
                for (int i = 0; i < actionAlterTable.getAlterTableCmdSqlNodeList().getNodes().size(); ++i) {
                    AlterTableCmd alterTableCmd = actionAlterTable.getAlterTableCmdSqlNodeList().getNodes().get(i);
                    if (alterTableCmd.getAlterTablePartitionAction() != null && alterTableCmd.getAlterTablePartitionAction().getPartitionName() != null) {
                        String splitPartitionName = alterTableCmd.getAlterTablePartitionAction().getPartitionName().replaceAll("^'|'$", "");
                        if (alterTableCmd.getAlterTablePartitionAction().getSplitClause() != null) {
                            SplitClause splitClause = alterTableCmd.getAlterTablePartitionAction().getSplitClause();
                            for (int j = 0; j < splitClause.getIntoPartitions().size(); ++j) {
                                String intoPartitionName = splitClause.getIntoPartitions().get(j).replaceAll("^'|'$", "");
                                if (splitPartitionName.equalsIgnoreCase(intoPartitionName)) {
                                    splitClause.getIntoPartitions().set(j, splitPartitionName + "_split");
                                    partitionName = splitPartitionName;
                                    continue;
                                }
                                splitClause.getIntoPartitions().set(j, intoPartitionName);
                            }
                        }
                    }
                    alterTableCmd.unParse(writer, context);
                    if (i == actionAlterTable.getAlterTableCmdSqlNodeList().getNodes().size() - 1) continue;
                    writer.append(", ");
                }
            } else {
                throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "Alter table partition", "PARTITION");
            }
            if (partitionName != null) {
                writer.sqlEnd();
                writer.append("ALTER TABLE ");
                actionAlterTable.getRelationExpr().unParse(writer, context);
                writer.append(" RENAME PARTITION ");
                writer.append(partitionName).append("_split").writeSpace();
                writer.append("TO ");
                writer.append(partitionName);
            }
        }
    }
}

