/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.ColumnDef;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ColumnDef.class)
public class ColumnDefUnParser
implements UnParser<ColumnDef> {
    @Override
    public void unParse(ColumnDef sqlNode, SqlWriter writer, UnParserContext context) {
        this.keyWordProcess(sqlNode, writer);
        sqlNode.getTypeName().unParse(writer, context);
        if (sqlNode.getColConstraintSqlNodeList() != null) {
            for (int i = 0; i < sqlNode.getColConstraintSqlNodeList().getNodes().size(); ++i) {
                sqlNode.getColConstraintSqlNodeList().getNodes().get(i).unParse(writer, context);
            }
        }
    }

    private void keyWordProcess(ColumnDef columnDef, SqlWriter writer) {
        String configValue = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.output.column.keyword", "");
        List<String> keyWordList = Arrays.asList(configValue.split(","));
        if (keyWordList.contains(columnDef.getColId().toLowerCase(Locale.ROOT))) {
            writer.append("`").append(columnDef.getColId().toLowerCase(Locale.ROOT)).append("`").writeSpace();
        } else {
            writer.append(columnDef.getColId()).writeSpace();
        }
    }
}

