/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.CheckTableConstraint;
import com.huawei.hwclouds.migration.pg.nodes.ConstraintElem;
import com.huawei.hwclouds.migration.pg.nodes.UkOrPkTableConstraint;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ConstraintElem.class)
public class ConstraintElemUnParser
implements UnParser<ConstraintElem> {
    @Override
    public void unParse(ConstraintElem sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getCheckTableConstraint() != null) {
            CheckTableConstraint checkTableConstraint = sqlNode.getCheckTableConstraint();
            writer.append("CHECK( ");
            checkTableConstraint.getExpression().unParse(writer, context);
            writer.append(") ");
            for (int i = 0; i < checkTableConstraint.getConstraintAttributeSpec().size(); ++i) {
                writer.append(checkTableConstraint.getConstraintAttributeSpec().get(i));
            }
        } else if (sqlNode.getUkOrPkTableConstraint() != null) {
            int i;
            UkOrPkTableConstraint ukOrPkTableConstraint = sqlNode.getUkOrPkTableConstraint();
            writer.append(ukOrPkTableConstraint.getKeyType()).append("( ");
            for (i = 0; i < ukOrPkTableConstraint.getColumnList().size(); ++i) {
                writer.append(ukOrPkTableConstraint.getColumnList().get(i));
                if (i == ukOrPkTableConstraint.getColumnList().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
            if (ukOrPkTableConstraint.getOptCInclude() != null) {
                writer.append("INCLUDE( ");
                for (i = 0; i < ukOrPkTableConstraint.getOptCInclude().size(); ++i) {
                    writer.append(ukOrPkTableConstraint.getOptCInclude().get(i));
                    if (i == ukOrPkTableConstraint.getOptCInclude().size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(") ");
            }
            if (ukOrPkTableConstraint.getOptDefinition() != null) {
                ukOrPkTableConstraint.getOptDefinition().unParse(writer, context);
            }
            if (ukOrPkTableConstraint.getOptConsTablespace() != null) {
                writer.append(ukOrPkTableConstraint.getOptConsTablespace()).writeSpace();
            }
            if (ukOrPkTableConstraint.getExistingIndex() != null) {
                writer.append(ukOrPkTableConstraint.getExistingIndex()).writeSpace();
            }
            if (ukOrPkTableConstraint.getConstraintAttributeSpec() != null) {
                for (i = 0; i < ukOrPkTableConstraint.getConstraintAttributeSpec().size(); ++i) {
                    writer.append(ukOrPkTableConstraint.getConstraintAttributeSpec().get(i)).writeSpace();
                }
            }
        } else {
            if (sqlNode.getExcludeConstraint() != null) {
                throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "excludeConstraint", "EXCLUDE");
            }
            if (sqlNode.getForeignKeyConstraint() != null) {
                throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "foreignKeyConstraint", "FOREIGN KEY");
            }
        }
    }
}

