/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.CopyOptionItem;
import com.huawei.hwclouds.migration.pg.nodes.CopyStmt;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CopyStmt.class)
public class CopyStmtUnParser
implements UnParser<CopyStmt> {
    @Override
    public void unParse(CopyStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("COPY ");
        if (sqlNode.getQualifiedName() != null) {
            writer.append(sqlNode.getQualifiedName());
        }
        if (sqlNode.getOptColumnList() != null) {
            writer.append("(");
            writer.append(String.join((CharSequence)",", sqlNode.getOptColumnList()));
            writer.append(")").writeSpace();
        }
        if (sqlNode.getExpression() != null) {
            sqlNode.getExpression().unParse(writer, context);
        }
        if (sqlNode.getCopyFrom() != null) {
            writer.append(sqlNode.getCopyFrom()).writeSpace();
        }
        if (sqlNode.getCopyFileName() != null) {
            writer.append(sqlNode.getCopyFileName()).writeSpace();
        }
        if (sqlNode.getCopyOptions() != null) {
            boolean isAddCSV;
            boolean hasHeader = false;
            boolean hasCSV = false;
            boolean isLogErrors = false;
            boolean ifHasWhen = false;
            block0: for (CopyOptionItem item : sqlNode.getCopyOptions()) {
                String[] options;
                String copyOptionKey = item.getCopyOptionKey();
                if ("HEADER".equalsIgnoreCase(copyOptionKey)) {
                    hasHeader = true;
                } else if ("CSV".equalsIgnoreCase(copyOptionKey)) {
                    hasCSV = true;
                }
                if (item.getIsLogErrors() != null && item.getIsLogErrors().booleanValue()) {
                    isLogErrors = true;
                }
                for (String option : options = new String[]{"OIDS", "HEADER", "DELIMITER", "NULL", "CSV", "FILL MISSING FIELDS", "BINARY", "ESCAPE"}) {
                    if (!option.equalsIgnoreCase(copyOptionKey)) continue;
                    if ("ESCAPE".equalsIgnoreCase(copyOptionKey)) {
                        if ("'OFF'".equalsIgnoreCase(item.getCopyOptionValue())) continue block0;
                        ifHasWhen = true;
                        continue block0;
                    }
                    ifHasWhen = true;
                    continue block0;
                }
            }
            if (isLogErrors) {
                writer.append("LOG_ERRORS ").writeSpace();
            }
            if (ifHasWhen) {
                writer.append("WITH ");
            } else {
                writer.append("/*");
                writer.append("WITH ");
                writer.append("*/");
            }
            boolean bl = isAddCSV = hasHeader && !hasCSV;
            if (isAddCSV) {
                writer.append("CSV ");
            }
            for (CopyOptionItem copyOption : sqlNode.getCopyOptions()) {
                copyOption.unParse(writer, context);
            }
        }
    }
}

