/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.CreateExternalTableFormatOption;
import com.huawei.hwclouds.migration.pg.nodes.CreateExternalTableStmt;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateExternalTableStmt.class)
public class CreateExternalTableStmtUnParser
implements UnParser<CreateExternalTableStmt> {
    @Override
    public void unParse(CreateExternalTableStmt sqlNode, SqlWriter writer, UnParserContext context) {
        String server;
        writer.append("CREATE FOREIGN TABLE").writeSpace();
        if (sqlNode.isIfNotExists()) {
            writer.append("IF NOT EXISTS").writeSpace();
        }
        writer.append(sqlNode.getTableName()).append("(");
        if (sqlNode.getTableElementList() != null) {
            sqlNode.getTableElementList().unParse(writer, context);
        }
        writer.append(")").newLine();
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (sqlNode.getExternalFormatType().equalsIgnoreCase("'parquet'") || sqlNode.getExternalFormatType().equalsIgnoreCase("'custom'")) {
            server = ConfigUtil.getConfigValue(config, "table.output.foreign.obs.server", "obs_server");
            sqlNode.setExternalFormatType("'parquet'");
        } else {
            server = ConfigUtil.getConfigValue(config, "table.output.foreign.server", "gsmpp_server");
        }
        writer.append("SERVER").writeSpace().append(server).newLine();
        writer.append("OPTIONS").writeSpace().append("(");
        if (sqlNode.getLocationUrls() != null && !sqlNode.getLocationUrls().isEmpty()) {
            writer.append("location").writeSpace().append("'");
            for (int i = 0; i < sqlNode.getLocationUrls().size(); ++i) {
                String url = sqlNode.getLocationUrls().get(i);
                if (url == null || url.length() < 2 || !url.startsWith("'") || !url.endsWith("'")) {
                    throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "The format of the location URL is incorrect.");
                }
                url = url.substring(1, url.length() - 1);
                url = url.replace("gphdfs", "gsfs");
                url = url.replace("gpfdist", "gsfs");
                writer.append(url);
                if (i == sqlNode.getLocationUrls().size() - 1) continue;
                writer.append("|");
            }
            writer.append("'").append(",").newLine();
        }
        writer.append("format").writeSpace().append(sqlNode.getExternalFormatType());
        if (sqlNode.getFormatOptions() != null && !sqlNode.getFormatOptions().isEmpty()) {
            sqlNode.getFormatOptions().forEach(option -> this.unParseFormatOptions((CreateExternalTableFormatOption)option, writer, context, sqlNode.getExternalFormatType()));
        }
        if (sqlNode.getExternalEncodingType() != null) {
            writer.append(",").newLine();
            writer.append("ENCODING").writeSpace().append(sqlNode.getExternalEncodingType());
        }
        writer.append(")");
        if (sqlNode.isReadable()) {
            writer.newLine().append("READ ONLY");
        } else if (sqlNode.isWritable()) {
            writer.newLine().append("WRITE ONLY");
        }
        if (sqlNode.isLogErrors()) {
            writer.newLine().append("LOG INTO").writeSpace().append(sqlNode.getTableName() + "_error");
        }
        if (sqlNode.getRejectLimit() != null) {
            writer.newLine().append("PER NODE REJECT LIMIT").writeSpace();
            int rejectLimit = "PERCENT".equalsIgnoreCase(sqlNode.getRejectLimitType()) ? sqlNode.getRejectLimit() * 10 : sqlNode.getRejectLimit();
            writer.append("'").append(Integer.toString(rejectLimit)).append("'");
        }
    }

    public void unParseFormatOptions(CreateExternalTableFormatOption sqlNode, SqlWriter writer, UnParserContext context, String format) {
        switch (sqlNode.getOption().toLowerCase(Locale.ROOT)) {
            case "header": {
                writer.append(",").newLine().append("header").writeSpace().append("true");
                break;
            }
            case "delimiter": {
                if (sqlNode.getArg().equalsIgnoreCase("'null'")) break;
                writer.append(",").newLine().append("delimiter").writeSpace().append(sqlNode.getArg());
                break;
            }
            case "null": {
                writer.append(",").newLine().append("null").writeSpace().append(sqlNode.getArg());
                break;
            }
            case "escape": {
                writer.append(",").newLine();
                if (!format.equalsIgnoreCase("'CSV'")) {
                    writer.append("-- ");
                }
                writer.append("escape").writeSpace().append(sqlNode.getArg());
                break;
            }
            case "fill missing fields": {
                writer.append(",").newLine().append("fill_missing_fields").writeSpace().append("true");
                break;
            }
            case "quote": {
                writer.append(",").newLine().append("quote").writeSpace().append(sqlNode.getArg());
                break;
            }
        }
    }
}

