/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.CreateFunctionStmt;
import com.huawei.hwclouds.migration.pg.nodes.FuncOptItem;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateFunctionStmt.class)
public class CreateFunctionStmtUnParser
implements UnParser<CreateFunctionStmt> {
    @Override
    public void unParse(CreateFunctionStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE ");
        if (sqlNode.isReplace()) {
            writer.append("OR REPLACE ");
        }
        if (sqlNode.isFunction()) {
            writer.append("FUNCTION ");
        } else {
            writer.append("PROCEDURE ");
        }
        writer.append(sqlNode.getFunctionName()).append("(");
        if (sqlNode.getFuncArgList() != null) {
            sqlNode.getFuncArgList().unParse(writer, context);
        }
        writer.append(")").newLine();
        if (sqlNode.getFuncReturn() != null) {
            writer.append("RETURNS ");
            sqlNode.getFuncReturn().unParse(writer, context);
            writer.newLine();
        } else if (sqlNode.getTableFuncColumnList() != null) {
            writer.append("RETURNS TABLE (");
            sqlNode.getTableFuncColumnList().unParse(writer, context);
            writer.append(")").newLine();
        } else if (sqlNode.getReturnVoid() != null) {
            writer.append("RETURNS VOID").writeSpace();
        }
        this.handleLanguage(sqlNode);
        if (sqlNode.getOptItemList() != null) {
            List<FuncOptItem> optItemListLeft = sqlNode.getOptItemList();
            for (FuncOptItem funcOptItem : optItemListLeft) {
                funcOptItem.unParse(writer, context);
            }
        }
    }

    private void handleLanguage(CreateFunctionStmt sqlNode) {
        if (sqlNode.getOptItemList() == null) {
            return;
        }
        FuncOptItem languageOptItem = null;
        boolean existUtilityStatements = false;
        for (FuncOptItem funcOptItem : sqlNode.getOptItemList()) {
            if (funcOptItem.getLanguage() != null) {
                languageOptItem = funcOptItem;
            }
            if (funcOptItem.getFunctionSqlBody() == null || !funcOptItem.getFunctionSqlBody().isExistUtilityStatements()) continue;
            existUtilityStatements = true;
        }
        if (existUtilityStatements) {
            if (languageOptItem != null) {
                languageOptItem.setLanguage("plpgsql");
            } else {
                languageOptItem = new FuncOptItem();
                languageOptItem.setLanguage("plpgsql");
                sqlNode.getOptItemList().add(languageOptItem);
            }
        }
    }
}

