/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.CreateOptRoleElem;
import com.huawei.hwclouds.migration.pg.nodes.CreateUser;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateUser.class)
public class CreateUserUnParser
implements UnParser<CreateUser> {
    @Override
    public void unParse(CreateUser sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE");
        writer.writeSpace().append(sqlNode.getRoleOrUser()).writeSpace();
        sqlNode.getRoleSpec().unParse(writer, context);
        if (sqlNode.isWith()) {
            writer.writeSpace().append("WITH");
        }
        List<CreateOptRoleElem> nodes = sqlNode.getCreateOptRoleElemSqlNodeList().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            writer.writeSpace();
            this.unParseCreateOptRoleElem(nodes.get(i), writer, context);
        }
    }

    private void unParseCreateOptRoleElem(CreateOptRoleElem createOptRoleElem, SqlWriter writer, UnParserContext context) {
        if (createOptRoleElem.getKeyWord() != null) {
            if (createOptRoleElem.getKeyWord().toLowerCase(Locale.ROOT).contains("resourcegroup")) {
                writer.append("RESOURCE POOL ");
            } else {
                writer.append(createOptRoleElem.getKeyWord()).writeSpace();
            }
            List<String> roleList = createOptRoleElem.getRoleList();
            for (int i = 0; i < roleList.size(); ++i) {
                writer.append(roleList.get(i));
                if (i == roleList.size() - 1) continue;
                writer.append(", ");
            }
        } else {
            createOptRoleElem.getAlterOptRoleElem().unParse(writer, context);
        }
    }
}

