/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.DropStmt;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=DropStmt.class)
public class DropStmtUnParser
implements UnParser<DropStmt> {
    private static final String PRT_1 = "_1_prt_";
    private static final String PRT_2 = "_2_prt_";
    private static final String PRT = "_prt_";

    @Override
    public void unParse(DropStmt sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getAnyNameList() != null && !sqlNode.getAnyNameList().isEmpty() && DropStmtUnParser.handlePartitionTableName(sqlNode.getAnyNameList().get(0), sqlNode.isIfExists(), writer)) {
            return;
        }
        writer.append("DROP ").append(sqlNode.getObjectTypeAnyName()).writeSpace();
        if (sqlNode.isIfExists()) {
            writer.append("IF EXISTS ");
        }
        if (sqlNode.getName() != null) {
            writer.append(sqlNode.getName()).writeSpace();
        }
        if (sqlNode.isExistsOn()) {
            writer.append("ON ");
        }
        if (sqlNode.getAnyNameList() != null) {
            for (int i = 0; i < sqlNode.getAnyNameList().size(); ++i) {
                writer.append(sqlNode.getAnyNameList().get(i)).writeSpace();
                if (i == sqlNode.getAnyNameList().size() - 1) continue;
                writer.append(", ");
            }
        } else {
            for (int i = 0; i < sqlNode.getTypeNameList().getNodes().size(); ++i) {
                sqlNode.getTypeNameList().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getTypeNameList().getNodes().size() - 1) continue;
                writer.append(", ");
            }
        }
        if (sqlNode.getOptDropBehavior() != null) {
            writer.append(sqlNode.getOptDropBehavior()).writeSpace();
        }
    }

    public static boolean handlePartitionTableName(String sourceTableName, boolean ifExists, SqlWriter writer) {
        String lowerCase = sourceTableName.toLowerCase(Locale.ROOT);
        String tableName = null;
        String partitionName = null;
        if (lowerCase.contains(PRT_1) && lowerCase.contains(PRT_2) && lowerCase.lastIndexOf(PRT_2) > lowerCase.lastIndexOf(PRT_1)) {
            tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT_1));
            partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT_1) + PRT_1.length(), lowerCase.lastIndexOf(PRT_2)) + "_" + sourceTableName.substring(lowerCase.lastIndexOf(PRT_2) + PRT_2.length());
        } else if (lowerCase.contains(PRT_1)) {
            tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT_1));
            partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT_1) + PRT_1.length());
        } else if (lowerCase.contains(PRT)) {
            tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT));
            partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT) + PRT.length());
        }
        if (tableName != null) {
            writer.append("ALTER TABLE ").append(tableName).writeSpace().append("DROP PARTITION ");
            if (ifExists) {
                writer.append("IF EXISTS ");
            }
            writer.append(partitionName);
            return true;
        }
        return false;
    }
}

