/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.ExprRow;
import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.RowExpr;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ExprRow.class)
public class ExprRowUnParser
implements UnParser<ExprRow> {
    @Override
    public void unParse(ExprRow sqlNode, SqlWriter writer, UnParserContext context) {
        this.rowExprUnParse(sqlNode.getFRowExpr(), writer, context);
        if (sqlNode.getSRowExpr() != null) {
            writer.append("OVERLAPS ");
            this.rowExprUnParse(sqlNode.getSRowExpr(), writer, context);
        }
    }

    private void rowExprUnParse(RowExpr rowExpr, SqlWriter writer, UnParserContext context) {
        SqlNodeList<Expression> exprList = rowExpr.getExprList();
        if (rowExpr.getKeyWord() != null) {
            writer.append(rowExpr.getKeyWord()).writeSpace();
        }
        writer.append("(");
        if (exprList != null) {
            for (int i = 0; i < exprList.getNodes().size(); ++i) {
                exprList.getNodes().get(i).unParse(writer, context);
                if (i == exprList.getNodes().size() - 1) continue;
                writer.append(", ");
            }
        }
        writer.append(") ");
    }
}

