/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.google.common.collect.Lists;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.FuncOptItem;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FuncOptItem.class)
public class FuncOptItemUnParser
implements UnParser<FuncOptItem> {
    private static final List<String> ignoreOptList = Lists.newArrayList((Object[])new String[]{"EXECUTE AS CALLER", "NO SQL", "CONTAINS SQL", "EXECUTE ON ANY", "EXECUTE ON MASTER", "EXECUTE ON ALL SEGMENTS"});

    @Override
    public void unParse(FuncOptItem sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getLanguage() != null) {
            writer.append("LANGUAGE ");
            if (sqlNode.getLanguage().equalsIgnoreCase("NZPLSQL")) {
                writer.append("plpgsql");
            } else {
                writer.append(sqlNode.getLanguage());
            }
            writer.newLine();
        } else if (sqlNode.getSimpleOpt() != null) {
            String trim = sqlNode.getSimpleOpt().trim().toUpperCase(Locale.ROOT);
            if (ignoreOptList.contains(trim)) {
                return;
            }
            writer.append(sqlNode.getSimpleOpt()).newLine();
        } else if (sqlNode.getPlsqlBody() != null) {
            sqlNode.getPlsqlBody().unParse(writer, context);
            writer.newLine();
        } else if (sqlNode.getDef() != null) {
            writer.append("AS").writeSpace().append(sqlNode.getDef()).newLine();
        } else if (sqlNode.getObjFile() != null) {
            writer.append("AS").writeSpace();
            writer.append(sqlNode.getObjFile()).append(",").append(sqlNode.getLinKSymbol()).newLine();
        } else if (sqlNode.getFunctionSqlBody() != null) {
            sqlNode.getFunctionSqlBody().unParse(writer, context);
        }
    }
}

