/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.GrantStmt;
import com.huawei.hwclouds.migration.pg.unparser.RoleSpecUnParser;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=GrantStmt.class)
public class GrantStmtUnParser
implements UnParser<GrantStmt> {
    @Override
    public void unParse(GrantStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("GRANT").writeSpace();
        sqlNode.getPrivileges().unParse(writer, context);
        writer.writeSpace();
        if (sqlNode.getPrivilegeTarget() != null || sqlNode.getTargetNameList() != null) {
            writer.append("ON").writeSpace();
        }
        if (sqlNode.getPrivilegeTarget() != null) {
            writer.append(sqlNode.getPrivilegeTarget()).writeSpace();
        }
        if (sqlNode.getTargetNameList() != null && !sqlNode.getTargetNameList().isEmpty()) {
            writer.append(String.join((CharSequence)",", sqlNode.getTargetNameList())).writeSpace();
        } else if (sqlNode.getTargetFunctionList() != null && !sqlNode.getTargetFunctionList().isEmpty()) {
            sqlNode.getTargetFunctionList().unParse(writer, context);
        }
        writer.append("TO").writeSpace();
        for (int i = 0; i < sqlNode.getGranteeList().size(); ++i) {
            writer.append(RoleSpecUnParser.convertRoleName(sqlNode.getGranteeList().get(i), writer));
            if (i == sqlNode.getGranteeList().size() - 1) continue;
            writer.append(",");
        }
        if (sqlNode.isWithGrantOption()) {
            writer.writeSpace().append("WITH GRANT OPTION");
        }
    }
}

