/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.PartitionElement;
import com.huawei.hwclouds.migration.pg.nodes.SqlNode;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=PartitionElement.class)
public class PartitionElementUnParser
implements UnParser<PartitionElement> {
    private static final Logger LOGGER = LogManager.getLogger(PartitionElementUnParser.class);
    private static final String PARTITION_VALUES = "VALUES";
    private static final String PARTITION_VALUES_LESS_THAN = "VALUES LESS THAN";

    @Override
    public void unParse(PartitionElement sqlNode, SqlWriter writer, UnParserContext context) {
        boolean valuesLessThan;
        if (sqlNode.getPartitionName() == null) {
            throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "not partition name", "partition name");
        }
        if (sqlNode.getSubPartitionElementList() != null && !sqlNode.getSubPartitionElementList().isEmpty()) {
            this.unParseSubPartitionElement(sqlNode, writer, context);
            return;
        }
        if (sqlNode.isDefaultPartition()) {
            writer.append("DEFAULT").writeSpace();
        }
        writer.append("PARTITION").writeSpace();
        Map<String, String> placeHolderMap = MigrationContextUtil.getPlaceHolderMap();
        if (sqlNode.getPartitionName().contains("$")) {
            int index = placeHolderMap.size();
            writer.append(":" + index);
            placeHolderMap.put(String.valueOf(index), sqlNode.getPartitionName());
        } else {
            writer.append(sqlNode.getPartitionName());
        }
        if (sqlNode.getValuesExprList() != null && !sqlNode.getValuesExprList().isEmpty()) {
            writer.writeSpace();
            writer.append(PARTITION_VALUES).writeSpace().append("(");
            sqlNode.getValuesExprList().unParse(writer, context);
            writer.append(")");
        }
        boolean bl = valuesLessThan = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.output.partition.valueslessthan", "").equalsIgnoreCase("Y") && ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.origin.database.type", "").equalsIgnoreCase("greenplum") && !sqlNode.isHaveEveryValue();
        if (!valuesLessThan && sqlNode.getPartitionStartExpr() != null) {
            writer.writeSpace();
            writer.append("START").writeSpace().append("(");
            sqlNode.getPartitionStartExpr().unParse(writer, context);
            writer.append(")");
        }
        if (sqlNode.getPartitionEndExpr() != null) {
            writer.writeSpace();
            if (valuesLessThan) {
                writer.append(PARTITION_VALUES_LESS_THAN);
            } else {
                int index = placeHolderMap.size();
                writer.append(":" + index);
                placeHolderMap.put(String.valueOf(index), "END");
            }
            writer.writeSpace().append("(");
            if ("INCLUSIVE".equalsIgnoreCase(sqlNode.getEndRangeParam())) {
                SqlWriter endValueWriter = writer.cloneEmpty();
                sqlNode.getPartitionEndExpr().unParse(endValueWriter, context);
                String endValue = endValueWriter.toSqlString().getSql();
                CharSequence[] split = endValue.split("::");
                try {
                    String value = split[0].trim();
                    if (value.startsWith("'") && value.endsWith("'")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        Date endDate = sdf.parse(value.substring(1, value.length() - 1));
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(endDate);
                        calendar.add(5, 1);
                        split[0] = "'" + sdf.format(calendar.getTime()) + "'";
                    } else {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            Date endDate = sdf.parse(value);
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(endDate);
                            calendar.add(5, 1);
                            split[0] = sdf.format(calendar.getTime());
                        }
                        catch (Exception e) {
                            split[0] = String.valueOf(Long.parseLong(value) + 1L);
                        }
                    }
                    writer.append(String.join((CharSequence)"::", split));
                }
                catch (Exception e) {
                    LOGGER.error("handle partition end param INCLUSIVE error,ignore INCLUSIVE", (Throwable)e);
                    sqlNode.getPartitionEndExpr().unParse(writer, context);
                }
            } else {
                sqlNode.getPartitionEndExpr().unParse(writer, context);
            }
            writer.append(")");
        }
        if (sqlNode.getPartitionEveryExpr() != null) {
            writer.writeSpace();
            writer.append("EVERY").writeSpace().append("(");
            sqlNode.getPartitionEveryExpr().unParse(writer, context);
            writer.append(")");
        }
    }

    private void unParseSubPartitionElement(PartitionElement sqlNode, SqlWriter writer, UnParserContext context) {
        for (int i = 0; i < sqlNode.getSubPartitionElementList().getNodes().size(); ++i) {
            PartitionElement subpartitionElement = sqlNode.getSubPartitionElementList().getNodes().get(i);
            writer.append("PARTITION").writeSpace();
            String partitionName = sqlNode.getPartitionName() + "_" + subpartitionElement.getPartitionName();
            Map<String, String> placeHolderMap = MigrationContextUtil.getPlaceHolderMap();
            if (partitionName.contains("$")) {
                int index = placeHolderMap.size();
                writer.append(":" + index);
                placeHolderMap.put(String.valueOf(index), partitionName);
            } else {
                writer.append(partitionName);
            }
            writer.writeSpace();
            String partitionType = null;
            SqlNode partitionArg = null;
            SqlNode subPartitionArg = null;
            if (sqlNode.getValuesExprList() != null && !sqlNode.getValuesExprList().isEmpty()) {
                partitionArg = sqlNode.getValuesExprList();
                partitionType = subpartitionElement.getValuesExprList() != null && !subpartitionElement.getValuesExprList().isEmpty() ? PARTITION_VALUES : PARTITION_VALUES_LESS_THAN;
            } else if (sqlNode.getPartitionEndExpr() != null) {
                partitionArg = sqlNode.getPartitionEndExpr();
                partitionType = PARTITION_VALUES_LESS_THAN;
            } else if (sqlNode.getLessThanExprList() != null && !sqlNode.getLessThanExprList().isEmpty()) {
                partitionArg = sqlNode.getLessThanExprList();
                partitionType = PARTITION_VALUES_LESS_THAN;
            }
            if (subpartitionElement.getValuesExprList() != null && !subpartitionElement.getValuesExprList().isEmpty()) {
                subPartitionArg = subpartitionElement.getValuesExprList();
            } else if (subpartitionElement.getPartitionEndExpr() != null) {
                subPartitionArg = subpartitionElement.getPartitionEndExpr();
            } else if (subpartitionElement.getLessThanExprList() != null && !subpartitionElement.getLessThanExprList().isEmpty()) {
                subPartitionArg = subpartitionElement.getLessThanExprList();
            }
            this.unParsePartitionArg(partitionType, partitionArg, subPartitionArg, writer, context);
            if (i == sqlNode.getSubPartitionElementList().getNodes().size() - 1) continue;
            writer.append(",");
        }
    }

    private void unParsePartitionArg(String partitionType, SqlNode partitionArg, SqlNode subPartitionArg, SqlWriter writer, UnParserContext context) {
        if (partitionType == null || partitionArg == null || subPartitionArg == null) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Partition && Subpartition Combination");
        }
        writer.append(partitionType).writeSpace().append("(");
        partitionArg.unParse(writer, context);
        writer.append(",");
        subPartitionArg.unParse(writer, context);
        writer.append(")");
    }
}

