/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.WriterUtil;
import com.huawei.hwclouds.migration.pg.nodes.RelOptionElem;
import com.huawei.hwclouds.migration.pg.nodes.RelOptions;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=RelOptions.class)
public class RelOptionsUnParser
implements UnParser<RelOptions> {
    @Override
    public void unParse(RelOptions sqlNode, SqlWriter writer, UnParserContext context) {
        this.removeTableOption(sqlNode, writer, context);
        writer.append("( ");
        this.dealWithTableOptions(sqlNode, writer);
        List<RelOptionElem> nodes = sqlNode.getRelOptionElemSqlNodeList().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            nodes.get(i).unParse(writer, context);
            if (i == nodes.size() - 1) continue;
            writer.append(", ");
        }
        writer.append(") ");
    }

    private void removeTableOption(RelOptions sqlNode, SqlWriter writer, UnParserContext context) {
        List<RelOptionElem> nodes = sqlNode.getRelOptionElemSqlNodeList().getNodes();
        ConvertConfig config = writer.getConfig("param.config.flag");
        for (int i = 0; i < nodes.size(); ++i) {
            RelOptionElem relOptionElem = nodes.get(i);
            String fColLabel = relOptionElem.getFColLabel();
            switch (fColLabel.toLowerCase(Locale.ROOT)) {
                case "appendonly": 
                case "compresslevel": 
                case "compresstype": 
                case "checksum": 
                case "storage_format": 
                case "bitmap_columns": 
                case "dictionary_encoding_columns": 
                case "table_group": 
                case "table_storage_mode": 
                case "time_to_live_in_seconds": 
                case "binlog_level": 
                case "binlog_ttl": 
                case "partition_require_filter": 
                case "segment_key": 
                case "partition_generate_binlog_window": {
                    nodes.remove(i);
                    --i;
                    break;
                }
                case "distribution_key": {
                    context.setDisKeyCol(nodes.get(i).getDefArg());
                    nodes.remove(i);
                    --i;
                    break;
                }
                case "partition_expiration_time": {
                    relOptionElem.setFColLabel("TTL");
                    break;
                }
                case "partition_keep_hot_window": {
                    int day;
                    relOptionElem.setFColLabel("STORAGE_POLICY");
                    String upperCase = relOptionElem.getDefArg().toUpperCase();
                    String prefix = "HPN:";
                    if (upperCase.endsWith("HOUR")) {
                        day = Integer.parseInt(upperCase.split(" ")[0]) / 24;
                        relOptionElem.setDefArg(prefix + day);
                        break;
                    }
                    if (upperCase.endsWith("DAY")) {
                        day = Integer.parseInt(upperCase.split(" ")[0]);
                        relOptionElem.setDefArg(prefix + day);
                        break;
                    }
                    if (upperCase.endsWith("MONTH")) {
                        day = Integer.parseInt(upperCase.split(" ")[0]) * 30;
                        relOptionElem.setDefArg(prefix + day);
                        break;
                    }
                    if (upperCase.endsWith("YEAR")) {
                        day = Integer.parseInt(upperCase.split(" ")[0]) * 365;
                        relOptionElem.setDefArg(prefix + day);
                        break;
                    }
                    nodes.remove(i);
                    --i;
                    break;
                }
            }
            if (!ConfigUtil.getConfigValue(config, "table.orientation", null).equalsIgnoreCase("row") || !fColLabel.equalsIgnoreCase("enable_delta") && !fColLabel.equalsIgnoreCase("clustering_key")) continue;
            nodes.remove(i);
            --i;
        }
    }

    private void dealWithTableOptions(RelOptions sqlNode, SqlWriter writer) {
        String compressLevel;
        ConvertConfig config = writer.getConfig("param.config.flag");
        boolean existOrientation = false;
        boolean existCompression = false;
        boolean existColVersion = false;
        boolean existDelta = false;
        List<RelOptionElem> nodes = sqlNode.getRelOptionElemSqlNodeList().getNodes();
        int count = nodes.size();
        int cnt = nodes.size();
        String configValueForOrientation = ConfigUtil.getConfigValue(config, "table.orientation", null);
        for (RelOptionElem node : nodes) {
            if (node.getFColLabel().equalsIgnoreCase("orientation")) {
                if (QuoteUtils.removeAllQuote(node.getDefArg()).equalsIgnoreCase("row")) {
                    configValueForOrientation = "row";
                } else if (QuoteUtils.removeAllQuote(node.getDefArg()).equalsIgnoreCase("column")) {
                    configValueForOrientation = "column";
                }
                existOrientation = true;
                --cnt;
                continue;
            }
            if (node.getFColLabel().equalsIgnoreCase("compression")) {
                existCompression = true;
                --cnt;
                continue;
            }
            if (node.getFColLabel().equalsIgnoreCase("colversion")) {
                existColVersion = true;
                --cnt;
                continue;
            }
            if (!node.getFColLabel().equalsIgnoreCase("enable_delta")) continue;
            existDelta = true;
            --cnt;
        }
        cnt = WriterUtil.getConfigCnt(config, count, configValueForOrientation);
        int appendCount = cnt - count;
        if (!existOrientation) {
            if (configValueForOrientation.isEmpty()) {
                configValueForOrientation = "COLUMN";
            }
            writer.append("orientation = ").append(configValueForOrientation);
            WriterUtil.writerComma(appendCount, writer, count);
            --appendCount;
        }
        if (configValueForOrientation.equalsIgnoreCase("column")) {
            if (!existCompression && !ConfigUtil.getConfigValue(config, "table.compress.level", null).isEmpty()) {
                String configValue = ConfigUtil.getConfigValue(config, "table.compress.level", null);
                writer.append("compression = ").append(configValue);
                WriterUtil.writerComma(appendCount, writer, count);
                --appendCount;
            }
            if (!existColVersion && !ConfigUtil.getConfigValue(config, "table.colversion.version", null).equals("")) {
                writer.append("colversion = ").append(ConfigUtil.getConfigValue(config, "table.colversion.version", null));
                WriterUtil.writerComma(appendCount, writer, count);
                --appendCount;
            }
            if (!existDelta && !ConfigUtil.getConfigValue(config, "table.enable.delta", null).equals("")) {
                writer.append("enable_delta = ").append(ConfigUtil.getConfigValue(config, "table.enable.delta", null));
                WriterUtil.writerComma(appendCount, writer, count);
            }
        } else if (!existCompression && (compressLevel = ConfigUtil.getConfigValue(config, "table.compress.level", null)) != null && (compressLevel.equalsIgnoreCase("YES") || compressLevel.equalsIgnoreCase("NO"))) {
            writer.append("compression = ").append(compressLevel);
            WriterUtil.writerComma(appendCount, writer, count);
        }
    }
}

