/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.RelationExpr;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=RelationExpr.class)
public class RelationExprUnParser
implements UnParser<RelationExpr> {
    private static final String PRT_1 = "_1_prt_";
    private static final String PRT_2 = "_2_prt_";
    private static final String PRT = "_prt_";

    @Override
    public void unParse(RelationExpr sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isExistOnly()) {
            writer.append("ONLY ");
        }
        sqlNode.setQualifiedName(RelationExprUnParser.convertPartitionTableName(sqlNode.getQualifiedName()));
        if (sqlNode.isExistBrackets()) {
            writer.append("( ");
            writer.append(sqlNode.getQualifiedName()).writeSpace();
            if (sqlNode.isExistStar()) {
                writer.append("* ");
            }
            writer.append(") ");
        } else {
            writer.append(sqlNode.getQualifiedName()).writeSpace();
            if (sqlNode.isExistStar()) {
                writer.append("* ");
            }
        }
    }

    public static String convertPartitionTableName(String sourceTableName) {
        String lowerCase = sourceTableName.toLowerCase(Locale.ROOT);
        if (lowerCase.contains(PRT_1) && lowerCase.contains(PRT_2) && lowerCase.lastIndexOf(PRT_2) > lowerCase.lastIndexOf(PRT_1)) {
            String tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT_1));
            String partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT_1) + PRT_1.length(), lowerCase.lastIndexOf(PRT_2)) + "_" + sourceTableName.substring(lowerCase.lastIndexOf(PRT_2) + PRT_2.length());
            return tableName + " partition(" + partitionName + ")";
        }
        if (lowerCase.contains(PRT_1)) {
            String tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT_1));
            String partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT_1) + PRT_1.length());
            return tableName + " partition(" + partitionName + ")";
        }
        if (lowerCase.contains(PRT)) {
            String tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT));
            String partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT) + PRT.length());
            return tableName + " partition(" + partitionName + ")";
        }
        return sourceTableName;
    }
}

