/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.RoleSpec;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=RoleSpec.class)
public class RoleSpecUnParser
implements UnParser<RoleSpec> {
    private static volatile Map<String, String> roleMap = null;

    @Override
    public void unParse(RoleSpec sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(RoleSpecUnParser.convertRoleName(sqlNode.getRole(), writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initRoleMap(SqlWriter writer) {
        if (roleMap != null) return;
        Class<RoleSpecUnParser> clazz = RoleSpecUnParser.class;
        synchronized (RoleSpecUnParser.class) {
            if (roleMap != null) return;
            roleMap = new HashMap<String, String>();
            String roleConvertStr = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.output.role.name.convert", "");
            if (roleConvertStr == null || roleConvertStr.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (String single : roleConvertStr.split(",")) {
                if (!single.contains("|")) continue;
                String[] split = single.split("\\|");
                roleMap.put(split[0].toUpperCase(Locale.ROOT).trim(), split[1]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String convertRoleName(String roleName, SqlWriter writer) {
        RoleSpecUnParser.initRoleMap(writer);
        if (roleMap == null || roleMap.isEmpty() || !roleMap.containsKey(roleName.trim().toUpperCase(Locale.ROOT))) {
            return roleName;
        }
        return roleMap.get(roleName.trim().toUpperCase(Locale.ROOT));
    }
}

