/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.SelectNoParens;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SelectNoParens.class)
public class SelectNoParensUnParser
implements UnParser<SelectNoParens> {
    @Override
    public void unParse(SelectNoParens sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getWithClause() != null) {
            sqlNode.getWithClause().unParse(writer, context);
            writer.newLine();
        }
        if (sqlNode.getSelectClause() != null) {
            sqlNode.getSelectClause().unParse(writer, context);
        }
        if (sqlNode.getSortClause() != null) {
            writer.writeSpace();
            sqlNode.getSortClause().unParse(writer, context);
        }
        if (sqlNode.getLimitAndLockClause() != null) {
            writer.writeSpace();
            sqlNode.getLimitAndLockClause().getSelectLimit().unParse(writer, context);
        }
        if (sqlNode.getSelectStmtWithContactList() != null && !sqlNode.getSelectStmtWithContactList().isEmpty()) {
            writer.newLine();
            sqlNode.getSelectStmtWithContactList().forEach(selectStmtWithContact -> {
                selectStmtWithContact.unParse(writer, context);
                writer.newLine();
            });
        }
    }
}

