/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.BitType;
import com.huawei.hwclouds.migration.pg.nodes.CharacterType;
import com.huawei.hwclouds.migration.pg.nodes.GenericType;
import com.huawei.hwclouds.migration.pg.nodes.IntervalType;
import com.huawei.hwclouds.migration.pg.nodes.NumericType;
import com.huawei.hwclouds.migration.pg.nodes.OtherType;
import com.huawei.hwclouds.migration.pg.nodes.SimpleTypeName;
import com.huawei.hwclouds.migration.pg.nodes.SqlTypeName;
import com.huawei.hwclouds.migration.pg.nodes.TimeType;
import com.huawei.hwclouds.migration.pg.unparser.TypeNameUnParser;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Locale;
import java.util.Map;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SimpleTypeName.class)
public class SimpleTypeNameUnParser
implements UnParser<SimpleTypeName> {
    @Override
    public void unParse(SimpleTypeName sqlNode, SqlWriter writer, UnParserContext context) {
        try {
            this.convertTypeName(sqlNode, writer);
        }
        catch (Exception e) {
            throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "convert type error, pleas check parameter:table.output.column.type.convert");
        }
        if (sqlNode.getGenerictype() != null) {
            this.dealWithGenericType(sqlNode.getGenerictype(), writer, context);
        } else if (sqlNode.getNumericType() != null) {
            this.dealWithNumericType(sqlNode.getNumericType(), writer, context);
        } else if (sqlNode.getBitType() != null) {
            this.dealWithBitType(sqlNode.getBitType(), writer, context);
        } else if (sqlNode.getCharacterType() != null) {
            this.dealWithCharacterType(sqlNode.getCharacterType(), writer);
        } else if (sqlNode.getIntervalType() != null) {
            this.dealWithIntervalType(sqlNode.getIntervalType(), writer);
        } else if (sqlNode.getTimeType() != null) {
            this.dealWithTimeType(sqlNode.getTimeType(), writer);
        } else if (sqlNode.getOtherType() != null) {
            this.dealWithOtherType(sqlNode.getOtherType(), writer);
        }
    }

    private void dealWithOtherType(OtherType otherType, SqlWriter writer) {
        switch (otherType.getTypeName().toLowerCase(Locale.ROOT)) {
            case "rowid": {
                writer.append("TID ");
                break;
            }
            case "transaction id": {
                writer.append("XID ");
                break;
            }
            case "record": {
                writer.append("RECORD ");
                break;
            }
            case "money": {
                writer.append("MONEY ");
                break;
            }
            case "inet": {
                writer.append("INET ");
                break;
            }
            case "oid": {
                writer.append("OID ");
                break;
            }
            case "json": {
                writer.append("JSON ");
                break;
            }
            case "jsonb": {
                writer.append("JSONB ");
                break;
            }
            case "unknown": {
                writer.append("TEXT ");
                break;
            }
            default: {
                writer.append(otherType.getTypeName()).writeSpace();
            }
        }
    }

    private void dealWithGenericType(GenericType generictype, SqlWriter writer, UnParserContext context) {
        writer.append(generictype.getName()).writeSpace();
        writer.append("( ");
        for (int i = 0; i < generictype.getOptTypeModifiers().getNodes().size(); ++i) {
            generictype.getOptTypeModifiers().getNodes().get(i).unParse(writer, context);
            if (i == generictype.getOptTypeModifiers().getNodes().size() - 1) continue;
            writer.append(", ");
        }
        writer.append(") ");
    }

    private void dealWithNumericType(NumericType numericType, SqlWriter writer, UnParserContext context) {
        if (numericType.getNumeric().getName().equalsIgnoreCase("BIGINT IDENTITY")) {
            writer.append("BIGSERIAL").writeSpace();
        } else if (numericType.getNumeric().getName().equalsIgnoreCase("INT IDENTITY")) {
            writer.append("SERIAL").writeSpace();
        } else {
            writer.append(numericType.getNumeric().getName()).writeSpace();
        }
        if (numericType.getOptTypeModifiers() != null) {
            writer.append("( ");
            for (int i = 0; i < numericType.getOptTypeModifiers().getNodes().size(); ++i) {
                numericType.getOptTypeModifiers().getNodes().get(i).unParse(writer, context);
                if (i == numericType.getOptTypeModifiers().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
    }

    private void dealWithBitType(BitType bitType, SqlWriter writer, UnParserContext context) {
        switch (bitType.getTypeName().toLowerCase(Locale.ROOT)) {
            case "bit": {
                writer.append("BIT");
                if (bitType.isExistVarying()) {
                    writer.writeSpace().append("VARYING ");
                }
                if (bitType.getIConst() == null) break;
                writer.append("( ");
                writer.append(bitType.getIConst()).append(") ");
                break;
            }
            case "byteint": {
                writer.append("INT ");
                break;
            }
            case "varbinary": 
            case "bytea": {
                writer.append("BYTEA ");
                break;
            }
        }
    }

    private void dealWithCharacterType(CharacterType characterType, SqlWriter writer) {
        writer.append(characterType.getCharacterName().getName()).writeSpace();
        if (characterType.getIConst() != null) {
            if (characterType.getCharacterName() == SqlTypeName.CHAR || characterType.getCharacterName() == SqlTypeName.CHARACTER) {
                SimpleTypeNameUnParser.unparseCharLength(characterType, "table.output.char.coefficient", writer);
            } else if (characterType.getCharacterName() == SqlTypeName.VARCHAR || characterType.getCharacterName() == SqlTypeName.CHARACTERVARYING) {
                SimpleTypeNameUnParser.unparseCharLength(characterType, "table.output.varchar.coefficient", writer);
            } else if (characterType.getCharacterName() == SqlTypeName.BPCHAR) {
                SimpleTypeNameUnParser.unparseCharLength(characterType, "table.output.bpchar.coefficient", writer);
            } else {
                writer.append("( ").append(characterType.getIConst()).writeSpace().append(") ");
            }
        }
    }

    private static void unparseCharLength(CharacterType characterType, String configKey, SqlWriter writer) {
        String coefficientStr = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), configKey, "1");
        int coefficient = coefficientStr == null ? 1 : Integer.parseInt(coefficientStr);
        int iConst = Integer.parseInt(characterType.getIConst());
        writer.append("(").append(String.valueOf(coefficient * iConst)).append(") ");
    }

    private void dealWithIntervalType(IntervalType intervalType, SqlWriter writer) {
        writer.append("INTERVAL ");
        if (intervalType.getOptInterval() != null) {
            writer.append(intervalType.getOptInterval()).writeSpace();
        } else if (intervalType.getIConst() != null) {
            writer.append("( ").append(intervalType.getIConst()).writeSpace().append(") ");
        }
    }

    private void dealWithTimeType(TimeType timeType, SqlWriter writer) {
        if (timeType.getTypeName().getName().equalsIgnoreCase("datetime")) {
            timeType.setTypeName(SqlTypeName.TIMESTAMPWITHOUTTIMEZONE);
        }
        writer.append(timeType.getTypeName().getName()).writeSpace();
        if (timeType.getIConst() != null) {
            writer.append("( ").append(timeType.getIConst()).writeSpace().append(") ");
        }
        if (timeType.getTimeZone() != null) {
            writer.append(timeType.getTimeZone()).writeSpace();
        }
    }

    private void convertTypeName(SimpleTypeName sqlNode, SqlWriter writer) {
        String upperCase;
        Map<String, String> typeMap = TypeNameUnParser.initTypeMap(writer);
        if (typeMap.isEmpty()) {
            return;
        }
        if (sqlNode.getGenerictype() != null) {
            String upperCase2 = sqlNode.getGenerictype().getName().toUpperCase(Locale.ROOT);
            if (typeMap.containsKey(upperCase2)) {
                sqlNode.getGenerictype().setName(typeMap.get(upperCase2));
            }
        } else if (sqlNode.getNumericType() != null) {
            String name = sqlNode.getNumericType().getNumeric().getName();
            if (typeMap.containsKey(name)) {
                sqlNode.getNumericType().setNumeric(SqlTypeName.valueOf(typeMap.get(name).toUpperCase(Locale.ROOT)));
            }
        } else if (sqlNode.getBitType() != null) {
            String upperCase3 = sqlNode.getBitType().getTypeName().toUpperCase(Locale.ROOT);
            if (typeMap.containsKey(upperCase3)) {
                sqlNode.getBitType().setTypeName(typeMap.get(upperCase3));
            }
        } else if (sqlNode.getCharacterType() != null) {
            String name = sqlNode.getCharacterType().getCharacterName().getName();
            if (typeMap.containsKey(name)) {
                sqlNode.getCharacterType().setCharacterName(SqlTypeName.valueOf(typeMap.get(name).toUpperCase(Locale.ROOT)));
            }
        } else if (sqlNode.getOtherType() != null && typeMap.containsKey(upperCase = sqlNode.getOtherType().getTypeName().toUpperCase(Locale.ROOT))) {
            sqlNode.getOtherType().setTypeName(typeMap.get(upperCase));
        }
    }
}

