/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.SortBy;
import com.huawei.hwclouds.migration.pg.nodes.SortClause;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SortClause.class)
public class SortClauseUnParser
implements UnParser<SortClause> {
    @Override
    public void unParse(SortClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("ORDER BY ");
        List<SortBy> nodes = sqlNode.getSortBySqlNodeList().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            SortBy sortBy = nodes.get(i);
            sortBy.getExpression().unParse(writer, context);
            if (sortBy.getQualAllOp() != null) {
                writer.writeSpace().append("USING ").append(sortBy.getQualAllOp()).writeSpace();
            } else if (sortBy.getOptAscDesc() != null) {
                writer.writeSpace().append(sortBy.getOptAscDesc()).writeSpace();
            }
            if (sortBy.getOptNullsOrder() != null) {
                writer.writeSpace().append(sortBy.getOptNullsOrder()).writeSpace();
            }
            if (i != nodes.size() - 1) {
                writer.append(", ");
            }
            if (sortBy.getComments() == null || sortBy.getComments().isEmpty()) continue;
            this.unParseComment(sortBy, writer);
        }
    }
}

