/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.TruncateStmt;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TruncateStmt.class)
public class TruncateStmtUnParser
implements UnParser<TruncateStmt> {
    private static final String PRT_1 = "_1_prt_";
    private static final String PRT_2 = "_2_prt_";
    private static final String PRT = "_prt_";

    @Override
    public void unParse(TruncateStmt sqlNode, SqlWriter writer, UnParserContext context) {
        if (TruncateStmtUnParser.handlePartitionTableName(sqlNode.getRelationExprList().getNodes().get(0).getQualifiedName(), writer)) {
            return;
        }
        writer.append("TRUNCATE TABLE ");
        sqlNode.getRelationExprList().unParse(writer, context);
    }

    public static boolean handlePartitionTableName(String sourceTableName, SqlWriter writer) {
        String lowerCase = sourceTableName.toLowerCase(Locale.ROOT);
        String tableName = null;
        String partitionName = null;
        if (lowerCase.contains(PRT_1) && lowerCase.contains(PRT_2) && lowerCase.lastIndexOf(PRT_2) > lowerCase.lastIndexOf(PRT_1)) {
            tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT_1));
            partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT_1) + PRT_1.length(), lowerCase.lastIndexOf(PRT_2)) + "_" + sourceTableName.substring(lowerCase.lastIndexOf(PRT_2) + PRT_2.length());
        } else if (lowerCase.contains(PRT_1)) {
            tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT_1));
            partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT_1) + PRT_1.length());
        } else if (lowerCase.contains(PRT)) {
            tableName = sourceTableName.substring(0, lowerCase.lastIndexOf(PRT));
            partitionName = sourceTableName.substring(lowerCase.lastIndexOf(PRT) + PRT.length());
        }
        if (tableName != null) {
            writer.append("ALTER TABLE ").append(tableName).writeSpace().append("TRUNCATE PARTITION ").append(partitionName);
            return true;
        }
        return false;
    }
}

