/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.TypeName;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TypeName.class)
public class TypeNameUnParser
implements UnParser<TypeName> {
    private static volatile Map<String, String> typeMap = null;

    @Override
    public void unParse(TypeName sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isExistSetOf()) {
            writer.append("SETOF").writeSpace();
        }
        if (sqlNode.getQualifiedName() != null) {
            String typeName = sqlNode.getQualifiedName();
            if (sqlNode.getType() != null) {
                typeName = typeName + "%" + sqlNode.getType();
            }
            writer.append(this.convertTypeName(typeName, writer));
        } else if (sqlNode.getInformationSchemaType() != null) {
            String typeName = "information_schema." + sqlNode.getInformationSchemaType();
            writer.append(this.convertTypeName(typeName, writer)).writeSpace();
        } else {
            sqlNode.getSimpleTypeName().unParse(writer, context);
            if (sqlNode.getOptArrayBounds() != null) {
                for (int i = 0; i < sqlNode.getOptArrayBounds().size(); ++i) {
                    writer.append(sqlNode.getOptArrayBounds().get(i));
                }
            } else {
                writer.writeSpace();
                writer.append(sqlNode.getArray());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> initTypeMap(SqlWriter writer) {
        if (typeMap != null) return typeMap;
        Class<TypeNameUnParser> clazz = TypeNameUnParser.class;
        synchronized (TypeNameUnParser.class) {
            if (typeMap != null) return typeMap;
            typeMap = new HashMap<String, String>();
            String typeConvertStr = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.output.column.type.convert", "");
            if (typeConvertStr == null || typeConvertStr.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return typeMap;
            }
            for (String single : typeConvertStr.split(",")) {
                if (!single.contains("|")) continue;
                String[] split = single.split("\\|");
                typeMap.put(split[0].toUpperCase(Locale.ROOT).trim(), split[1]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return typeMap;
        }
    }

    private String convertTypeName(String typeName, SqlWriter writer) {
        TypeNameUnParser.initTypeMap(writer);
        if (typeMap.isEmpty()) {
            return typeName;
        }
        String upperCase = typeName.toUpperCase(Locale.ROOT);
        if (typeMap.containsKey(upperCase)) {
            return typeMap.get(upperCase);
        }
        return typeName;
    }
}

