/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.VacuumStmt;
import com.huawei.hwclouds.migration.pg.unparser.RelationExprUnParser;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=VacuumStmt.class)
public class VacuumStmtUnParser
implements UnParser<VacuumStmt> {
    @Override
    public void unParse(VacuumStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("VACUUM");
        if (sqlNode.getVacuumKeyWordList() != null) {
            sqlNode.getVacuumKeyWordList().forEach(keyword -> writer.writeSpace().append((String)keyword));
        }
        if (sqlNode.getVacuumRelationList() != null) {
            sqlNode.getVacuumRelationList().forEach(relation -> {
                writer.writeSpace().append(RelationExprUnParser.convertPartitionTableName(relation.getTableName()));
                if (relation.getColumnList() != null) {
                    writer.append("(").append(String.join((CharSequence)",", relation.getColumnList())).append(")");
                }
            });
        }
    }
}

