/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.util;

import com.huawei.hwclouds.migration.pg.nodes.ColConstraint;
import com.huawei.hwclouds.migration.pg.nodes.ColInfo;
import com.huawei.hwclouds.migration.pg.nodes.CreateStmt;
import com.huawei.hwclouds.migration.pg.nodes.DistributeCol;
import com.huawei.hwclouds.migration.pg.nodes.DistributeColList;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.nodes.TableCons;
import com.huawei.hwclouds.migration.pg.nodes.TableElement;
import com.huawei.hwclouds.migration.pg.nodes.TypeName;
import com.huawei.hwclouds.migration.pg.nodes.UkOrPkTableConstraint;
import java.util.ArrayList;
import java.util.List;

public class DistributeListUtil {
    public static CreateStmt getDistributeColList(CreateStmt createStmt) {
        DistributeColList distributeColList = new DistributeColList();
        SqlNodeList<DistributeCol> distributeColSqlNodeList = new SqlNodeList<DistributeCol>();
        List<TableElement> nodes = createStmt.getTableElementList().getNodes();
        int uniqueCntForCol = 0;
        int uniqueCntForTable = 0;
        int uniqueCol = 0;
        boolean existPrimaryKey = false;
        for (TableElement node : nodes) {
            if (node.getColumnDef() != null && node.getColumnDef().getColConstraintSqlNodeList() != null) {
                DistributeCol distributeCol = new DistributeCol();
                distributeCol.setColName(node.getColumnDef().getColId());
                distributeCol.setColType(node.getColumnDef().getTypeName());
                List<ColConstraint> nodesForCon = node.getColumnDef().getColConstraintSqlNodeList().getNodes();
                for (ColConstraint colConstraint : nodesForCon) {
                    if (colConstraint.getColConstraintElem() == null) continue;
                    distributeCol.setKeyword(colConstraint.getColConstraintElem().getKeyWord());
                    if (colConstraint.getColConstraintElem().getKeyWord().equalsIgnoreCase("unique")) {
                        ++uniqueCntForCol;
                        break;
                    }
                    if (!colConstraint.getColConstraintElem().getKeyWord().equalsIgnoreCase("primary key")) continue;
                    existPrimaryKey = true;
                    break;
                }
                distributeColSqlNodeList.addNode(distributeCol);
            }
            if (node.getTableconstraint() == null) continue;
            TableCons tableCons = new TableCons();
            ArrayList<ColInfo> colList = new ArrayList<ColInfo>();
            if (node.getTableconstraint().getConstraintElem().getUkOrPkTableConstraint() == null) continue;
            UkOrPkTableConstraint keyConstraint = node.getTableconstraint().getConstraintElem().getUkOrPkTableConstraint();
            tableCons.setUniqueOrPrimary(keyConstraint.getKeyType());
            if (keyConstraint.getKeyType().equalsIgnoreCase("primary key")) {
                existPrimaryKey = true;
            }
            tableCons.setCompositeKey(keyConstraint.getColumnList().size() > 1);
            if (keyConstraint.getKeyType().equalsIgnoreCase("unique")) {
                ++uniqueCntForTable;
                uniqueCol = keyConstraint.getColumnList().size();
            }
            for (int i = 0; i < keyConstraint.getColumnList().size(); ++i) {
                ColInfo colInfo = new ColInfo();
                String col = keyConstraint.getColumnList().get(i);
                TypeName typeName = DistributeListUtil.getTypeName(col, createStmt);
                colInfo.setColName(col);
                colInfo.setTypeName(typeName);
                colList.add(colInfo);
            }
            tableCons.setColList(colList);
            distributeColList.setTableCons(tableCons);
        }
        distributeColList.setDistributeColSqlNodeList(distributeColSqlNodeList);
        distributeColList.setUniqueCntForCol(uniqueCntForCol);
        distributeColList.setUniqueCntForTable(uniqueCntForTable);
        distributeColList.setExistPrimaryKey(existPrimaryKey);
        distributeColList.setUniqueCol(uniqueCol + uniqueCntForCol);
        createStmt.setDistributeColList(distributeColList);
        return createStmt;
    }

    private static TypeName getTypeName(String col, CreateStmt createStmt) {
        List<TableElement> nodes = createStmt.getTableElementList().getNodes();
        for (TableElement node : nodes) {
            if (node.getColumnDef() == null || !node.getColumnDef().getColId().equalsIgnoreCase(col)) continue;
            return node.getColumnDef().getTypeName();
        }
        return null;
    }
}

