/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.util;

import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum SqlDialect {
    DWS("DWS"),
    POSTGRES("POSTGRES"),
    GREENPLUM("GREENPLUM"),
    HOLOGRES("HOLOGRES"),
    REDSHIFT("REDSHIFT"),
    NETEZZA("NETEZZA");

    private static final Logger LOGGER;
    private String value;

    private SqlDialect(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static SqlDialect getDialect(String value) {
        if (value == null || value.isEmpty()) {
            LOGGER.error("Failed to parse dialect when input is null.");
            return null;
        }
        String formattedValue = value.trim().toUpperCase(Locale.US);
        for (SqlDialect dialect : SqlDialect.values()) {
            if (!dialect.getValue().equalsIgnoreCase(formattedValue)) continue;
            return dialect;
        }
        LOGGER.error("Can not matched sql dialect.");
        return null;
    }

    static {
        LOGGER = LogManager.getLogger(SqlDialect.class);
    }
}

