/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migrationwrapper;

import com.huawei.db.migration.util.CommandInjectionChecker;
import com.huawei.migrationwrapper.Help;
import com.huawei.migrationwrapper.MigrationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CommandExecutor {
    public static final int PROC_WAIT_FOR_TIME = 4;

    protected static String executeCmd(List<String> command, boolean bRedirectStdout) throws MigrationException {
        return CommandExecutor.executeCmd(command, bRedirectStdout, false, 4L);
    }

    protected static String executeCmd(List<String> command, boolean bRedirectStdout, boolean isInheritIO, long timeout) throws MigrationException {
        String result;
        block5: {
            result = null;
            StringBuffer stdOutBuffer = new StringBuffer();
            String commandStr = String.join((CharSequence)" ", command);
            try {
                if (!CommandInjectionChecker.isExistsCommandInjection((String)command.toString())) {
                    Process proc = CommandExecutor.getProcessBuilder(command, bRedirectStdout, isInheritIO);
                    CommandExecutor.getOutBuff(bRedirectStdout, stdOutBuffer, commandStr, proc, timeout);
                    if (!bRedirectStdout) {
                        result = stdOutBuffer.toString();
                    }
                    break block5;
                }
                Help.printErrorMessage("[DSC_ERR_005_002] Command " + commandStr + " specified is not as per standard format(command injection is possible)");
                throw new MigrationException("[DSC_ERR_005_002] Command " + commandStr + " specified is not as per standard format(command injection is possible)");
            }
            catch (InterruptedException e) {
                Help.printErrorMessage("Execution of command:" + System.lineSeparator() + commandStr + System.lineSeparator() + "Failed with error: " + System.lineSeparator() + e.getMessage());
                throw new MigrationException("Error occured while executing command :" + commandStr);
            }
            catch (IOException e) {
                Help.printErrorMessage("Execution of command:" + System.lineSeparator() + commandStr + System.lineSeparator() + "Failed with IO error" + System.lineSeparator());
                throw new MigrationException("Error occured while executing command :" + commandStr);
            }
        }
        return result;
    }

    private static void getOutBuff(boolean bRedirectStdout, StringBuffer inpBuff, String commandStr, Process proc, long timeout) throws IOException, InterruptedException, MigrationException {
        if (!bRedirectStdout) {
            try (InputStream is = proc.getInputStream();){
                int ulChar;
                int ulCharMax = 65535;
                while ((ulChar = is.read()) != -1) {
                    if (ulChar == 10 || ulChar == 13 || ulChar > ulCharMax) continue;
                    inpBuff.append((char)ulChar);
                }
            }
        }
        proc.waitFor(timeout, TimeUnit.HOURS);
    }

    private static Process getProcessBuilder(List<String> command, boolean bRedirectStdout, boolean isInheritIO) throws IOException, MigrationException {
        ProcessBuilder pb = null;
        if (CommandInjectionChecker.isExistsCommandInjection((String)command.toString())) {
            throw new MigrationException("[DSC_ERR_005_002] Command specified is not as per standard format (command injection is possible).");
        }
        pb = bRedirectStdout ? new ProcessBuilder("Command_execution").redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).command(command) : new ProcessBuilder("Command_execution").redirectErrorStream(true).command(command);
        Process proc = null;
        proc = isInheritIO ? pb.inheritIO().start() : pb.start();
        return proc;
    }
}

