/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.common.features;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupingFeature {
    private static final Logger logger = LogManager.getLogger(GroupingFeature.class);
    private static final Pattern AS_PATTERN = Pattern.compile("(?i)(.*?)\\s+as(?!\\w)");
    private int aliasCount = 1;
    private Pattern ratioToReportPattern;
    private List<String> colNamesAddedTemp;
    private String orderByStr;
    private String topValue = "";
    private List<String> colAliasNew;
    private StringBuffer valueStr;
    private String havingString;
    private String cmntAtStart;
    private String cmntAtEnd;
    private String inputCol;

    public boolean doGrpingFn(Map<String, String> parserMap, Map<String, String> replaceValMap, Map<String, String> aliasColumnMap) {
        logger.debug("Grouping Function enabled");
        String columns = parserMap.get("aliascolumnname");
        String query = parserMap.get("sqlquery");
        String havingStr = parserMap.get("havingClause");
        String qualifyStr = null;
        qualifyStr = this.getQualifyStr(parserMap, query, qualifyStr);
        String havingGrp = null;
        if (QueryConversionUtility.containsCheck(havingStr, "grouping")) {
            havingGrp = this.setHavingGrpValue(havingStr);
            havingStr = "";
        }
        columns = this.dpPutColAliasForCols(aliasColumnMap, columns);
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> colNames = splitter.doGetAllColumns(columns);
        List<String> rankRowList = this.getRankList(replaceValMap, query);
        ArrayList<String> colNamesTemp = new ArrayList<String>(colNames);
        Boolean isColAdded = this.doAddAggColsInColsLst(replaceValMap, colNames);
        this.colNamesAddedTemp = new ArrayList<String>(colNames);
        this.doRmvRnkColFrmColumns(rankRowList, colNames);
        List<String> colAliasNames = this.getColAliasNames(colNames, colNamesTemp, isColAdded, this.colNamesAddedTemp);
        colNames = this.getColLstByRmvGrpCols(replaceValMap, colNames, colAliasNames);
        havingGrp = this.doUpdHavingClauseInMap(parserMap, havingGrp, colNames);
        this.orderByStr = parserMap.get("orderby");
        this.orderByStr = this.setOrderByStrValue(this.orderByStr, colNames);
        String grpElmnts = parserMap.get("grpelement");
        grpElmnts = this.setGrpElements(grpElmnts);
        List<String> grpList = splitter.doGetAllColumns(grpElmnts);
        colNames = this.setColNames(colNames, grpList);
        boolean isSuccess = true;
        String fromStr = parserMap.get("from");
        isSuccess = this.handleGroupingFn(parserMap, replaceValMap, isSuccess, fromStr, havingStr, colNames, rankRowList, colAliasNames, grpList);
        this.orderByStr = this.setOrderByValueToParseMap(parserMap, aliasColumnMap, this.orderByStr);
        havingGrp = this.doGetHavGrpFrmQualify(parserMap, aliasColumnMap, qualifyStr, havingGrp, colAliasNames);
        this.topValue = parserMap.get("TopValue");
        String topFn = parserMap.get("TopFunction");
        if (this.topValue != null) {
            this.updateMapForTopFn(parserMap, replaceValMap, topFn, havingGrp, colAliasNames);
        }
        return isSuccess;
    }

    private String getQualifyStr(Map<String, String> parserMap, String query, String input) {
        String qualifyStr = input;
        if (QueryConversionUtility.containsCheck(query, "qualify")) {
            qualifyStr = this.doRplQualify("from", parserMap);
            if (qualifyStr == null) {
                qualifyStr = this.doRplQualify("orderby", parserMap);
            }
            if (qualifyStr == null) {
                qualifyStr = this.doRplQualify("grpelement", parserMap);
            }
            if (qualifyStr == null) {
                qualifyStr = this.doRplQualify("havingClause", parserMap);
            }
        }
        return qualifyStr;
    }

    private boolean handleGroupingFn(Map<String, String> parserMap, Map<String, String> replaceValMap, boolean isSucc, String fromStr, String havingStr, List<String> colNames, List<String> rankRowList, List<String> colAliasNames, List<String> grpList) {
        boolean isSuccess = isSucc;
        this.havingString = havingStr;
        String grpingFn = parserMap.get("groupingfn");
        String output = this.decideGrpingFn(colNames, grpList, fromStr, grpingFn = QueryConversionUtility.toUpper(grpingFn), replaceValMap);
        if (output != null) {
            isSuccess = true;
            this.setGroupFnOutValMap(parserMap, replaceValMap, output);
            this.updateMapWithGrpQryCols(parserMap, replaceValMap, colNames, rankRowList, colAliasNames);
        }
        return isSuccess;
    }

    private void setGroupFnOutValMap(Map<String, String> parserMap, Map<String, String> replaceValMap, String output) {
        String outputQry = QueryConversionUtility.doReplaceFunctionVariables(output, replaceValMap, "COLUMN__");
        parserMap.put("groupFn", outputQry);
    }

    private List<String> getColAliasNames(List<String> colNames, List<String> colNamesTemp, Boolean isColAdded, List<String> colNamesAddedTemp) {
        List<String> colAliasNames = null;
        colNamesAddedTemp.removeAll(colNamesTemp);
        colAliasNames = colNamesAddedTemp.size() != 0 && isColAdded != false ? QueryConversionUtility.doGetAliasList(colNames, colNamesAddedTemp) : QueryConversionUtility.doGetAliasList(colNames);
        colAliasNames = this.doRmvDotFrmAliasLst(colAliasNames);
        return colAliasNames;
    }

    private String setOrderByValueToParseMap(Map<String, String> parserMap, Map<String, String> aliasColumnMap, String orderByStr) {
        String orderByString = orderByStr;
        if (!orderByString.isEmpty()) {
            orderByString = this.doChangeAliasInOrderBy(aliasColumnMap, orderByString);
            parserMap.put("orderby", orderByString);
        }
        return orderByString;
    }

    private List<String> setColNames(List<String> colNames, List<String> grpList) {
        List<String> columnNames = colNames;
        TreeSet<String> uniqueCols = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        uniqueCols.addAll(grpList);
        columnNames = this.doAddGroupByColumns(columnNames, uniqueCols);
        return columnNames;
    }

    private String setGrpElements(String grpElmnts) {
        String groupElements = grpElmnts.trim();
        if (groupElements.startsWith("(")) {
            groupElements = QueryConversionUtility.removeParenthesis(groupElements);
        }
        return groupElements;
    }

    private String setOrderByStrValue(String orderByStr, List<String> colNames) {
        String orderByString = orderByStr;
        if (!orderByString.isEmpty()) {
            orderByString = this.extractColsAndRplWithAlias(orderByString, colNames);
            orderByString = this.doRplGrping(orderByString, colNames);
        }
        return orderByString;
    }

    private String setHavingGrpValue(String havingStr) {
        String havingGrp = havingStr;
        havingGrp = havingGrp.replaceAll("\\s*\\(\\s*", "(");
        havingGrp = havingGrp.replaceAll("\\s*\\)\\s*", ")");
        havingGrp = havingGrp.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
        return havingGrp;
    }

    private boolean doAddAggColsInColsLst(Map<String, String> replaceValMap, List<String> colNames) {
        boolean isColAdded = false;
        for (Map.Entry<String, String> mapCol : replaceValMap.entrySet()) {
            Matcher match;
            String colVal = mapCol.getValue();
            if (!QueryConversionUtility.isExactMatch(colVal, "RATIO_TO_REPORT")) continue;
            if (this.ratioToReportPattern == null) {
                this.ratioToReportPattern = Pattern.compile("(?i)(?<!\\w)(RATIO_TO_REPORT\\s*\\(.*)");
            }
            if (!(match = this.ratioToReportPattern.matcher(colVal)).find()) continue;
            String ratioToReport = match.group(1);
            String ratioCol = QueryConversionUtility.doGetReplaceString(ratioToReport);
            String ratioColumn = ratioCol = QueryConversionUtility.removeParenthesis(ratioCol);
            boolean isColPresent = false;
            for (String col : colNames) {
                String column;
                if (col.trim().startsWith("_COLUMN__")) {
                    col = col.contains(" ") ? col.substring(0, col.indexOf(32)) : col;
                    col = replaceValMap.get(col);
                }
                if (!(column = col.replaceAll("\\s+", "")).equalsIgnoreCase(ratioCol = ratioCol.replaceAll("\\s+", ""))) continue;
                isColPresent = true;
                break;
            }
            if (isColPresent) continue;
            colNames.add(ratioColumn);
            isColAdded = true;
        }
        return isColAdded;
    }

    private void updateMapWithGrpQryCols(Map<String, String> parserMap, Map<String, String> replaceValMap, List<String> colNames, List<String> rankRowList, List<String> colAliasNames) {
        if (!rankRowList.isEmpty()) {
            String colStr = this.doGetRankOuterQry(rankRowList, colNames, colAliasNames, replaceValMap, this.colNamesAddedTemp);
            parserMap.put("columnList", colStr);
        } else {
            this.doRmvRatioColFromColsLst(colAliasNames, this.colNamesAddedTemp);
            String colSt = QueryConversionUtility.doGetStrFrmListWithComma(colAliasNames);
            colSt = QueryConversionUtility.doReplaceFunctionVariables(colSt, replaceValMap, "COLUMN__");
            parserMap.put("columnList", colSt);
        }
    }

    private void updateMapForTopFn(Map<String, String> parserMap, Map<String, String> replaceValMap, String topFn, String havingGrp, List<String> colAliasNames) {
        this.valueStr = new StringBuffer();
        if (topFn == null) {
            this.valueStr.append(" ").append("limit").append(" ").append(this.topValue);
            parserMap.put("orderby", parserMap.get("orderby") + this.valueStr.toString());
        } else {
            String topFnLwr = QueryConversionUtility.toLower(topFn);
            parserMap.put("selectcomment", parserMap.get("selectcomment") + " with top_function as (");
            this.colAliasNew = new ArrayList<String>(colAliasNames);
            this.topFnImpl(parserMap, replaceValMap, topFnLwr, havingGrp, colAliasNames);
        }
    }

    private void topFnImpl(Map<String, String> parserMap, Map<String, String> replaceValMap, String topFn, String havingGrp, List<String> colAliasNames) {
        String havingGroup = havingGrp;
        String colSt = null;
        if (topFn.startsWith("percent") && topFn.contains("with")) {
            this.colAliasNew.add("rank() over (" + parserMap.get("orderby") + ")" + " as " + "TOP_RNK");
            colSt = QueryConversionUtility.doGetStrFrmListWithComma(this.colAliasNew);
            colSt = QueryConversionUtility.doReplaceFunctionVariables(colSt, replaceValMap, "COLUMN__");
            parserMap.put("columnList", colSt);
            this.valueStr.append("(").append("SELECT CEIL(COUNT(*)*").append(this.topValue).append("/100) FROM top_function)");
            String valueString = this.valueStr.toString();
            havingGroup = this.doGetHavingGrp(havingGroup, colAliasNames, valueString);
            parserMap.put("orderby", "order by TOP_RNK");
            parserMap.put("havingClause", havingGroup);
        } else if (topFn.startsWith("percent")) {
            this.valueStr.append(this.orderByStr).append(")").append(" select * from ").append("top_function").append(" ").append("limit").append("(").append("SELECT CEIL(COUNT(*)*").append(this.topValue).append("/100) FROM top_function)");
            parserMap.put("orderby", this.valueStr.toString());
        } else {
            this.colAliasNew.add("rank() over (" + parserMap.get("orderby") + ")" + " as " + "TOP_RNK");
            colSt = QueryConversionUtility.doGetStrFrmListWithComma(this.colAliasNew);
            colSt = QueryConversionUtility.doReplaceFunctionVariables(colSt, replaceValMap, "COLUMN__");
            parserMap.put("columnList", colSt);
            havingGroup = this.doGetHavingGrp(havingGroup, colAliasNames, this.topValue);
            parserMap.put("orderby", "order by TOP_RNK");
            parserMap.put("havingClause", havingGroup);
        }
    }

    private String doGetHavGrpFrmQualify(Map<String, String> parserMap, Map<String, String> aliasColumnMap, String qualifyStr, String havingGrp, List<String> colAliasNames) {
        String havingGroup = havingGrp;
        String qualifyString = qualifyStr;
        if (qualifyString != null && qualifyString.length() > 7) {
            qualifyString = qualifyString.substring(7);
            if (!aliasColumnMap.isEmpty()) {
                qualifyString = this.doChangeAliasInQualify(aliasColumnMap, qualifyString);
            }
            if (!QueryConversionUtility.containsCheck(qualifyString, "over")) {
                qualifyString = qualifyString.replaceFirst("\\(", "() OVER(ORDER BY ");
            }
            havingGroup = this.getQualifyOutQry(parserMap, qualifyString, havingGroup, colAliasNames);
        }
        return havingGroup;
    }

    private String doUpdHavingClauseInMap(Map<String, String> parserMap, String havingGrp, List<String> colNames) {
        String havingGroup = havingGrp;
        if (havingGroup != null) {
            havingGroup = this.extractColsAndRplWithAlias(havingGroup, colNames);
            if ((havingGroup = this.doRplGrping(havingGroup, colNames)).trim().length() > 6) {
                havingGroup = " where " + havingGroup.trim().substring(6);
            }
            parserMap.put("havingClause", havingGroup);
        } else {
            parserMap.put("havingClause", "");
        }
        return havingGroup;
    }

    private List<String> getColLstByRmvGrpCols(Map<String, String> replaceValMap, List<String> columnNames, List<String> colAliasNames) {
        ArrayList<String> colNames = new ArrayList<String>(columnNames);
        if (QueryConversionUtility.containsCheck(replaceValMap.toString(), "grouping")) {
            List<String> remList = this.doModifyGroupingCol(replaceValMap, colNames);
            List<String> modifyGrpinColsLst = this.doRmvGrpinCols(colNames, colAliasNames, remList);
            colNames.removeAll(modifyGrpinColsLst);
        }
        return colNames;
    }

    private String dpPutColAliasForCols(Map<String, String> aliasColumnMap, String columns) {
        String columnName = columns.replaceAll("\\s*\\(\\s*", "(");
        columnName = columnName.replaceAll("\\s*\\)", ")");
        if (QueryConversionUtility.containsCheck(columnName = this.doPutColumnAlias(columnName, aliasColumnMap), "grouping")) {
            columnName = this.doPutAliasIfNotGiven(columnName);
        }
        return columnName;
    }

    private String doRplQualify(String mapStr, Map<String, String> parserMap) {
        String qualifyStr = null;
        String checkerStr = parserMap.get(mapStr);
        if (QueryConversionUtility.containsCheck(checkerStr, "qualify")) {
            checkerStr = checkerStr.replaceAll("(?i)(?<!\\w)not\\s*=|\\^\\s*=", "<>");
            checkerStr = QueryConversionUtility.doReplaceOperators(checkerStr, "(\\s(?:eq|gt|lt|le|ge|ne)(\\s|#|\\())");
            Pattern pattern = Pattern.compile("(?i)(qualify\\s.*?\\s*\\)\\s*(>|<|=|<=|>=|<>)\\s*\\w+)");
            Matcher matcher = pattern.matcher(checkerStr);
            if (matcher.find()) {
                qualifyStr = matcher.group(1);
                checkerStr = checkerStr.replace(qualifyStr, "");
                parserMap.put(mapStr, checkerStr);
            }
        }
        return qualifyStr;
    }

    private String doRplGrping(String grpingStr, List<String> colNames) {
        String grpingString = grpingStr;
        int index = 0;
        String column = null;
        while (QueryConversionUtility.containsCheck(grpingString, "grouping")) {
            index = QueryConversionUtility.getIndex(grpingString, "grouping", 0);
            if (grpingString.length() <= index) continue;
            column = QueryConversionUtility.doGetReplaceString(grpingString.substring(index));
            grpingString = grpingString.replace(column, "func_alias" + this.aliasCount);
            column = column + " " + "AS" + " " + "func_alias" + this.aliasCount++;
            colNames.add(column);
        }
        return grpingString;
    }

    private String extractColsAndRplWithAlias(String havingGrp, List<String> colNames) {
        String havingGroup = havingGrp;
        LinkedHashMap<String, String> grpIdMap = new LinkedHashMap<String, String>(10);
        for (String string : colNames) {
            String column = "";
            String subLwr = QueryConversionUtility.toLower(string);
            if (!subLwr.startsWith("grouping") && !subLwr.startsWith("grouping_id")) continue;
            if (subLwr.contains("as")) {
                int index = subLwr.indexOf("as");
                if (string.length() > index) {
                    column = string.substring(0, index);
                }
            } else if (string.contains(" ")) {
                column = string.substring(0, string.lastIndexOf(32));
            }
            column = column.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
            column = column.replaceAll("\\s*\\(\\s*", "(");
            column = column.replaceAll("\\s*\\)\\s*", ")");
            column = QueryConversionUtility.toUpper(column);
            if (!string.contains(" ")) continue;
            String alias = string.substring(string.lastIndexOf(32));
            grpIdMap.put(column, alias);
        }
        for (Map.Entry entry : grpIdMap.entrySet()) {
            if (!QueryConversionUtility.containsCheck(havingGroup, (String)entry.getKey())) continue;
            havingGroup = this.replaceExactPattern((String)entry.getKey(), havingGroup, (String)entry.getValue());
        }
        return havingGroup;
    }

    private String doGetRankOuterQry(List<String> rankRowList, List<String> colNames, List<String> colAlias, Map<String, String> replaceValMap, List<String> addedCols) {
        List<String> colAliasNames = colAlias;
        int listSize = rankRowList.size();
        for (int iIndex = 0; iIndex < listSize; ++iIndex) {
            String rankStr = rankRowList.get(iIndex);
            int index = 0;
            index = this.tryCatchBlock(rankStr, index);
            rankStr = this.getRankStr(replaceValMap, rankStr);
            for (String tempCol : colNames) {
                String cols = tempCol;
                if (!cols.contains(" ")) continue;
                cols = cols.trim();
                int idx = cols.lastIndexOf(32);
                String aliasStr = cols.substring(idx + 1);
                String colString = cols.substring(0, idx).trim();
                if ((colString = this.getColString(colString)).contains("COLUMN__")) {
                    colString = this.doChangesInColumn(replaceValMap, colString);
                    rankStr = rankStr.replaceAll("(?i)" + colString, aliasStr + " ");
                }
                if (!QueryConversionUtility.containsCheck(rankStr, colString = this.removeSpaceInColumn(colString))) continue;
                rankStr = this.replaceExactPattern(colString, rankStr, aliasStr);
            }
            this.addItemToList(colAliasNames, rankStr, index);
        }
        this.doRmvRatioColFromColsLst(colAliasNames, addedCols);
        String colStr = QueryConversionUtility.doGetStrFrmListWithComma(colAliasNames);
        colStr = QueryConversionUtility.doReplaceFunctionVariables(colStr, replaceValMap, "COLUMN__");
        return colStr;
    }

    private String removeSpaceInColumn(String input) {
        String colString = input;
        if (colString.contains("(") && colString.contains(")")) {
            colString = colString.replaceAll("\\s*\\(\\s*", "(");
            colString = colString.replaceAll("\\s*\\)\\s*", ")");
        }
        return colString;
    }

    private String doChangesInColumn(Map<String, String> replaceValMap, String input) {
        String colString = input;
        colString = QueryConversionUtility.doReplaceFunctionVariables(colString, replaceValMap, "COLUMN__");
        colString = colString.replaceAll("\\s*\\(\\s*", "\\\\(");
        if ((colString = colString.replaceAll("\\s*\\)\\s*", "\\\\)")).contains("*")) {
            colString = colString.replace("*", "\\*");
        }
        return colString;
    }

    private String getColString(String input) {
        Matcher match;
        String colString = input;
        if (colString.matches("(?i).*?\\s+as(?!\\w)") && (match = AS_PATTERN.matcher(colString)).find()) {
            colString = match.group(1);
        }
        return colString;
    }

    private String getRankStr(Map<String, String> replaceValMap, String input) {
        String rankStr = input;
        rankStr = rankStr.substring(0, rankStr.length() - 1);
        rankStr = QueryConversionUtility.doReplaceFunctionVariables(rankStr, replaceValMap, "COLUMN__");
        rankStr = rankStr.replaceAll("\\s*\\(\\s*", "(");
        rankStr = rankStr.replaceAll("\\s*\\)\\s*", ")");
        return rankStr;
    }

    private int tryCatchBlock(String rankStr, int idx) {
        int index = idx;
        try {
            index = Integer.parseInt(rankStr.substring(rankStr.length() - 1));
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException: " + ErrorLoggerUtility.getExceptionDetails(e) + ". while converting from string to int for the value= " + rankStr);
            throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
        }
        return index;
    }

    private void addItemToList(List<String> collection, String item, int index) {
        if (index >= 0 && index <= collection.size()) {
            collection.add(index, item);
        }
    }

    private void doRmvRatioColFromColsLst(List<String> colAliasNames, List<String> addedCols) {
        String column = null;
        for (int iIndex = 0; iIndex < colAliasNames.size(); ++iIndex) {
            column = colAliasNames.get(iIndex);
            if (column.trim().startsWith("aggColumnalias")) {
                this.removeItemFromList(colAliasNames, iIndex);
                continue;
            }
            if (!addedCols.contains(column)) continue;
            this.removeItemFromList(colAliasNames, iIndex);
        }
    }

    private String doPutAliasIfNotGiven(String columns) {
        String columnName = columns;
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> colNames = splitter.doGetAllColumns(columnName);
        ArrayList<String> colNames1 = new ArrayList<String>(colNames);
        int index = 0;
        int cnt = 1;
        String subStringLwr = null;
        for (String subString : colNames1) {
            ++index;
            subStringLwr = QueryConversionUtility.toLower(subString);
            if (!subStringLwr.startsWith("grouping") || !subString.endsWith(")")) continue;
            colNames.set(index - 1, subString + " " + "AS" + " " + "grping_Alias" + cnt++);
        }
        columnName = QueryConversionUtility.doGetStrFrmListWithComma(colNames);
        return columnName;
    }

    private String decideGrpingFn(List<String> columns, List<String> grpElements, String fromStr, String function, Map<String, String> replaceValMap) {
        StringBuffer result = null;
        String output = null;
        switch (function) {
            case "ROLLUP": {
                result = this.handleRollupCase(columns, grpElements, fromStr, this.havingString, replaceValMap);
                output = result.toString();
                output = output.replaceAll("(?i)\\w+\\.null", "null");
                break;
            }
            case "GROUPING SETS": {
                result = this.handleGroupingSetsCase(columns, grpElements, fromStr, this.havingString, replaceValMap);
                output = result.toString();
                output = output.replaceAll("(?i)\\w+\\.null", "null");
                break;
            }
            case "CUBE": {
                result = this.handleCubeCase(columns, grpElements, fromStr, this.havingString, replaceValMap);
                output = result.toString();
                output = output.replaceAll("(?i)\\w+\\.null", "null");
                break;
            }
        }
        return output;
    }

    private StringBuffer handleCubeCase(List<String> columns, List<String> grpElements, String fromStr, String havingStr, Map<String, String> replaceValMap) {
        StringBuffer result = new StringBuffer();
        ArrayList<String> columnList = new ArrayList<String>(columns);
        ArrayList<String> grpByList = new ArrayList<String>(grpElements);
        int grpSize = grpByList.size();
        int maxValue = Integer.MAX_VALUE;
        int minValue = Integer.MIN_VALUE;
        int len = 0;
        if (Math.pow(2.0, grpSize) >= (double)minValue && Math.pow(2.0, grpSize) <= (double)maxValue) {
            len = (int)Math.pow(2.0, grpSize);
        }
        for (int iIndex = 0; iIndex < len; ++iIndex) {
            char[] colEnable = Integer.toBinaryString(iIndex).toCharArray();
            ArrayList<String> tempGrpByList = new ArrayList<String>(10);
            int jIndex = colEnable.length - 1;
            for (int kIndex = grpSize - 1; kIndex > grpSize - colEnable.length - 1; --kIndex) {
                if (colEnable[jIndex--] != '1') continue;
                tempGrpByList.add((String)grpByList.get(kIndex));
            }
            String query = this.doFrameGrpingQry(columnList, grpByList, tempGrpByList, fromStr, havingStr, replaceValMap);
            result.append(query).append(" ").append("union all").append(" ");
        }
        result.delete(result.lastIndexOf("union all") - 1, result.lastIndexOf("union all") + 9);
        return result;
    }

    private StringBuffer handleGroupingSetsCase(List<String> columns, List<String> grpElements, String fromStr, String havingStr, Map<String, String> replaceValMap) {
        StringBuffer result = new StringBuffer();
        ArrayList<String> columnList = new ArrayList<String>(columns);
        ArrayList<String> grpByList = new ArrayList<String>(grpElements);
        int grpSize = grpByList.size();
        for (int iIndex = 0; iIndex < grpSize; ++iIndex) {
            String grpBy = (String)grpByList.get(iIndex);
            ArrayList<String> tempGrpByList = new ArrayList<String>(grpByList);
            tempGrpByList.remove(grpBy);
            String query = this.doFrameGrpingQry(columnList, grpByList, tempGrpByList, fromStr, havingStr, replaceValMap);
            result.append(query);
            result.append(" ").append("union all").append(" ");
        }
        result.delete(result.lastIndexOf("union all") - 1, result.lastIndexOf("union all") + 9);
        return result;
    }

    private StringBuffer handleRollupCase(List<String> columns, List<String> grpElements, String fromStr, String havingStr, Map<String, String> replaceValMap) {
        StringBuffer result = new StringBuffer("SELECT ");
        ArrayList<String> columnList = new ArrayList<String>(columns);
        ArrayList<String> columnListDup = new ArrayList<String>(columns);
        if (QueryConversionUtility.containsCheck(columns.toString(), "grouping")) {
            this.putZeroForGrpingCol(columnList, columnListDup);
        }
        ArrayList<String> grpByList = new ArrayList<String>(grpElements);
        result.append(QueryConversionUtility.doGetStrFrmListWithComma(columnListDup)).append(" ").append(fromStr);
        result.append(" ").append("group by");
        result.append(" ").append(QueryConversionUtility.doGetStrFrmListWithComma(grpByList)).append(" ").append(havingStr);
        result.append(" ").append("union all").append(" ");
        int grpSize = grpByList.size();
        for (int iIndex = grpByList.size() - 1; iIndex >= 0; --iIndex) {
            List<String> tempGrpByList = grpByList.subList(iIndex, grpSize);
            String query = this.doFrameGrpingQry(columnList, grpByList, tempGrpByList, fromStr, havingStr, replaceValMap);
            result.append(query).append(" ");
            result.append("union all").append(" ");
        }
        result.delete(result.lastIndexOf("union all") - 1, result.lastIndexOf("union all") + 9);
        return result;
    }

    private void putZeroForGrpingCol(List<String> columnList, List<String> columnListDup) {
        int mIndex = 0;
        for (String subStr : columnList) {
            ++mIndex;
            String subStrLwr = QueryConversionUtility.toLower(subStr);
            if (!subStrLwr.startsWith("grouping")) continue;
            String setCol = subStr.substring(subStr.lastIndexOf(41) + 1);
            columnListDup.remove(subStr);
            this.addItemToList(columnListDup, '0' + setCol, mIndex - 1);
        }
    }

    private String doFrameGrpingQry(List<String> columns, List<String> grpElements, List<String> remCols, String fromStr, String havingStr, Map<String, String> replaceValMap) {
        ArrayList<String> columnList = new ArrayList<String>(columns);
        logger.debug("Framing the grouping function");
        ArrayList<String> grpByList = new ArrayList<String>(grpElements);
        for (String string : remCols) {
            int colListSize = columnList.size();
            for (int iIndex = 0; iIndex < colListSize; ++iIndex) {
                this.updColLstWithNullColVal(replaceValMap, columnList, string, iIndex);
            }
        }
        int mIndex = 0;
        if (QueryConversionUtility.containsCheck(((Object)columnList).toString(), "grouping")) {
            for (String subStr : columnList) {
                ++mIndex;
                String subStrLwr = QueryConversionUtility.toLower(subStr);
                if (!subStrLwr.startsWith("grouping") || QueryConversionUtility.containsCheck(subStr, "grouping_id")) continue;
                String subss = subStr.substring(subStr.lastIndexOf(41) + 1);
                columnList.set(mIndex - 1, "0 " + subss);
            }
        }
        if (QueryConversionUtility.containsCheck(((Object)columnList).toString(), "grouping_id")) {
            this.doModifyGrpgIdCol(columnList);
        }
        grpByList.removeAll(remCols);
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        if (grpByList.isEmpty()) {
            stringBuffer.append(QueryConversionUtility.doGetStrFrmListWithComma(columnList)).append(" ").append(fromStr).append(" ").append(havingStr);
        } else {
            stringBuffer.append(QueryConversionUtility.doGetStrFrmListWithComma(columnList)).append(" ").append(fromStr).append(" ").append("group by").append(" ").append(QueryConversionUtility.doGetStrFrmListWithComma(grpByList)).append(" ").append(havingStr);
        }
        return stringBuffer.toString();
    }

    private void updColLstWithNullColVal(Map<String, String> replaceValMap, List<String> columnList, String grpCol, int iIndex) {
        String column = " " + columnList.get(iIndex) + " ";
        if (column.contains("COLUMN__")) {
            if ((column = column.substring(1, column.length() - 1)).length() > 3) {
                String tempColumn = column.substring(0, column.indexOf(95, column.lastIndexOf("__") + 3) + 1);
                String columnValue = QueryConversionUtility.doReplaceFunctionVariables(tempColumn, replaceValMap, "COLUMN__");
                columnList.remove(column);
                String columnRpl = this.doRplAsNull(grpCol, columnValue);
                column = column.replace(tempColumn, columnRpl);
                this.addItemToList(columnList, column, iIndex);
            }
        } else if (QueryConversionUtility.containsCheck(column, grpCol)) {
            column = column.substring(1, column.length() - 1);
            columnList.remove(column);
            column = this.doRplAsNull(grpCol, column);
            this.addItemToList(columnList, column, iIndex);
        }
    }

    private void doModifyGrpgIdCol(List<String> columnList) {
        int kIndex = 0;
        for (String column : columnList) {
            ++kIndex;
            String columnLwr = QueryConversionUtility.toLower(column);
            if (!columnLwr.startsWith("grouping_id")) continue;
            int openIndex = column.indexOf(40);
            int closeIndex = column.lastIndexOf(41);
            if (openIndex == -1 || closeIndex == -1 || openIndex > closeIndex) {
                return;
            }
            String groupIdStr = column.substring(openIndex + 1, closeIndex);
            StringBuffer sb = new StringBuffer();
            if (groupIdStr.contains("null")) {
                groupIdStr = groupIdStr.replace("null", "1");
            }
            for (String grpingCol : groupIdStr.split(",")) {
                if (grpingCol.trim().charAt(0) != '1') {
                    sb.append(0);
                    continue;
                }
                sb.append(1);
            }
            int decimalNumber = 0;
            try {
                decimalNumber = Integer.parseInt(sb.toString(), 2);
            }
            catch (NumberFormatException e) {
                logger.error("NumberFormatException: " + ErrorLoggerUtility.getExceptionDetails(e) + ". while converting from string to int for the value= " + decimalNumber);
                throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
            }
            if (column.length() <= 1) continue;
            String finalCol = column.substring(column.lastIndexOf(41) + 1);
            columnList.set(kIndex - 1, decimalNumber + " " + finalCol);
        }
    }

    private String doRplAsNull(String grpCol, String column) {
        String result = column;
        if (result.replaceAll("(?i)#S#\\d+#E#", "").trim().equalsIgnoreCase(grpCol)) {
            if (result.contains(".") && result.length() > 1) {
                result = result.substring(result.lastIndexOf(46) + 1);
            }
            result = "null as " + result;
        } else {
            result = this.replaceExactPattern(grpCol, result, "null");
        }
        return result;
    }

    private String doPutColumnAlias(String columnNames, Map<String, String> aliasColumnMap) {
        String inputCols = columnNames;
        String inputQry = columnNames;
        inputCols = this.doRemDotOrAppendAlias(inputCols, true);
        String colNames = columnNames;
        String patternInputToMatch = inputCols.replaceAll("(?i)#S#\\d+#E#", "");
        String word = null;
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> list = splitter.doGetAllColumns(patternInputToMatch);
        TreeSet<String> uniqueWords = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        uniqueWords.addAll(list);
        for (String wordCount : uniqueWords) {
            if (QueryConversionUtility.strFreqInList(list, wordCount) <= 1) continue;
            String neededStr = "." + wordCount.trim() + " ";
            inputQry = inputQry.replaceAll("(?i)#S#\\d+#E#", "");
            List<String> splittedString = splitter.doGetAllColumns(inputQry);
            for (int iIndex = 0; iIndex < splittedString.size(); ++iIndex) {
                splittedString.set(iIndex, splittedString.get(iIndex).trim());
            }
            ArrayList<String> uniqueCols = new ArrayList<String>(splittedString);
            HashSet<String> uniqueSet = new HashSet<String>(uniqueCols);
            for (String uniqueCol : uniqueSet) {
                String rqdString;
                word = uniqueCol + " ";
                if (!QueryConversionUtility.containsCheck(word, neededStr) || !(rqdString = word.trim()).contains(".")) continue;
                String changedStr = rqdString.replace(".", "_").trim();
                if (!colNames.contains(rqdString)) continue;
                colNames = colNames.replace(rqdString, rqdString + " " + "AS" + " " + changedStr);
                aliasColumnMap.put(changedStr, rqdString);
            }
        }
        String output = this.doRemDotOrAppendAlias(colNames, false);
        return output;
    }

    private String doRemDotOrAppendAlias(String columnNames, boolean dotRemoval) {
        int aliasCnt = 1;
        String[] commaArray = null;
        String output = "";
        int count = 1;
        this.cmntAtStart = null;
        this.cmntAtEnd = null;
        this.inputCol = null;
        if (columnNames != null) {
            commaArray = this.doGetQryColsArr(columnNames);
            StringBuffer formCols = new StringBuffer();
            for (int iIndex = 0; iIndex < commaArray.length; ++iIndex) {
                this.cmntAtStart = null;
                this.cmntAtEnd = null;
                this.inputCol = null;
                this.inputCol = commaArray[iIndex].trim();
                if (this.inputCol.contains("#S#")) {
                    if (this.inputCol.startsWith("#S#")) {
                        this.cmntAtStart = QueryConversionUtility.doGetStartCmnts(this.inputCol);
                    }
                    if (this.inputCol.endsWith("#E#")) {
                        this.cmntAtEnd = QueryConversionUtility.doGetEndCmnts(this.inputCol);
                    }
                    this.inputCol = this.inputCol.replaceAll("(?i)#S#\\d+#E#", "");
                }
                String aliasNameTemp = "ColumnAlias";
                aliasCnt = this.formColumnWithGrping(dotRemoval, aliasNameTemp, aliasCnt, formCols);
                if (count == commaArray.length) continue;
                ++count;
                formCols.append(",");
            }
            output = formCols.toString();
        }
        return output;
    }

    private int formColumnWithGrping(boolean dotRemoval, String aliasNameTemp, int aliasCntInp, StringBuffer formCols) {
        int aliasCnt = aliasCntInp;
        if (this.cmntAtStart != null) {
            formCols.append(this.cmntAtStart).append(" ");
        }
        if (this.inputCol.trim().contains(" ") && !dotRemoval) {
            formCols.append(this.inputCol);
        } else if (this.inputCol.trim().startsWith("_COLUMN__") && !dotRemoval) {
            formCols.append(this.inputCol).append(" ").append("AS").append(" ").append(aliasNameTemp).append(aliasCnt);
            ++aliasCnt;
        } else if (dotRemoval && !QueryConversionUtility.containsCheck(this.inputCol, "grouping")) {
            int dotIndex = this.inputCol.indexOf(46) + 1;
            if (dotIndex < this.inputCol.length()) {
                formCols.append(this.inputCol.substring(dotIndex, this.inputCol.length()));
            }
        } else {
            formCols.append(this.inputCol);
        }
        if (this.cmntAtEnd != null) {
            formCols.append(" ").append(this.cmntAtEnd);
        }
        return aliasCnt;
    }

    private String[] doGetQryColsArr(String columnNames) {
        String[] commaArray = null;
        if (QueryConversionUtility.containsCheck(columnNames, "grouping_id")) {
            List<String> colList = null;
            ColumnSplitter splitter = new ColumnSplitter();
            colList = splitter.doGetAllColumns(columnNames);
            commaArray = new String[colList.size()];
            commaArray = colList.toArray(commaArray);
        } else {
            commaArray = QueryConversionUtility.doGetArrSplit(columnNames, ",");
        }
        return commaArray;
    }

    private String replaceExactPattern(String finderStr, String inputStr, String replacement) {
        String finderString = finderStr;
        String output = inputStr;
        String outputLwr = QueryConversionUtility.toLower(output);
        finderString = QueryConversionUtility.preChkForRegex(finderString);
        if (outputLwr.startsWith("grouping") && QueryConversionUtility.containsCheck(output.replace(".", "\\."), finderString) && !outputLwr.contains("grouping_id")) {
            String subStr = output.substring(0, output.lastIndexOf(41) + 1);
            output = output.replace(subStr, "1");
        } else {
            output = QueryConversionUtility.doReplaceExactStr(finderString, replacement, output);
        }
        return output;
    }

    private List<String> getRankList(Map<String, String> replaceValMap, String query) {
        ArrayList<String> rankRowList = new ArrayList<String>(10);
        if (QueryConversionUtility.containsCheck(query, "rank") || QueryConversionUtility.containsCheck(query, "ROW_NUMBER") || QueryConversionUtility.isExactMatch(query, "RATIO_TO_REPORT")) {
            String col = null;
            for (Map.Entry<String, String> cols : replaceValMap.entrySet()) {
                col = QueryConversionUtility.toUpper(cols.getValue());
                if (!col.startsWith("RANK") && !col.startsWith("ROW_NUMBER") && !col.matches("(?i).*?RATIO_TO_REPORT\\s*\\(.*")) continue;
                rankRowList.add(cols.getKey());
            }
        }
        return rankRowList;
    }

    private void doRmvRnkColFrmColumns(List<String> rankRowList, List<String> colNames) {
        String fn = null;
        ArrayList<String> colNamesRmvLst = new ArrayList<String>(10);
        block2: for (int iIndex = 0; iIndex < rankRowList.size(); ++iIndex) {
            fn = rankRowList.get(iIndex);
            for (int jIndex = 0; jIndex < colNames.size(); ++jIndex) {
                if (!colNames.get(jIndex).contains(fn)) continue;
                this.removeItemFromList(rankRowList, iIndex);
                this.addItemToList(rankRowList, colNames.get(jIndex) + jIndex, iIndex);
                colNamesRmvLst.add(jIndex + "");
                continue block2;
            }
        }
        for (int kIndex = colNamesRmvLst.size() - 1; kIndex >= 0; --kIndex) {
            int index = 0;
            try {
                index = Integer.parseInt((String)colNamesRmvLst.get(kIndex));
            }
            catch (NumberFormatException e) {
                logger.error("NumberFormatException: " + ErrorLoggerUtility.getExceptionDetails(e) + ". while converting from string to int for the value= " + (String)colNamesRmvLst.get(kIndex));
                throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
            }
            this.removeItemFromList(colNames, index);
        }
    }

    private void removeItemFromList(List<String> collection, int index) {
        if (index >= 0 && index < collection.size()) {
            collection.remove(index);
        }
    }

    private List<String> doRmvDotFrmAliasLst(List<String> aliasColsLst) {
        List<String> colsLst = aliasColsLst;
        String column = null;
        if (aliasColsLst.toString().contains(".")) {
            for (int iIndex = 0; iIndex < aliasColsLst.size(); ++iIndex) {
                int dotIndex;
                column = aliasColsLst.get(iIndex);
                LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
                if (!(column = QueryConversionUtility.getSingleQuoteMap(column, quoteMap)).contains(".") || (dotIndex = column.lastIndexOf(46) + 1) >= column.length()) continue;
                String colToAdd = column.substring(dotIndex);
                colToAdd = QueryConversionUtility.getRplFromMap(colToAdd, quoteMap, "(##QUOTE##\\d+#)");
                colsLst.set(iIndex, colToAdd);
            }
        }
        return colsLst;
    }

    private List<String> doModifyGroupingCol(Map<String, String> replaceValMap, List<String> colNames) {
        int position = 0;
        ArrayList<String> fnValueList = new ArrayList<String>(replaceValMap.values());
        ArrayList<String> fnList = new ArrayList<String>(replaceValMap.keySet());
        ArrayList<String> remList = new ArrayList<String>(10);
        String groupingPattern = "(?i).*?((?<!\\w)GROUPING\\s*\\(|(?<!\\w)GROUPING_ID\\s*\\().*";
        for (String subCol : fnValueList) {
            ++position;
            boolean flag = false;
            while (subCol.matches(groupingPattern)) {
                int index = QueryConversionUtility.getStartIndex(subCol, groupingPattern, 1);
                if (index != -1) {
                    String col = QueryConversionUtility.doGetReplaceString(subCol.substring(index));
                    subCol = subCol.replace(col, "func_alias" + this.aliasCount);
                    col = col + " " + "AS" + " " + "func_alias" + this.aliasCount++;
                    colNames.add(col);
                }
                flag = true;
            }
            if (!flag) continue;
            remList.add((String)fnList.get(position - 1));
            replaceValMap.put((String)fnList.get(position - 1), subCol);
        }
        return remList;
    }

    private List<String> doAddGroupByColumns(List<String> columnNames, Set<String> uniqueCols) {
        List<String> colNames = new ArrayList<String>(columnNames);
        if (((Object)colNames).toString().contains("#S#")) {
            String commentsCols = ((Object)colNames).toString().replaceAll("(?i)#S#\\d+#E#", "");
            if (commentsCols.length() > 1) {
                commentsCols = commentsCols.substring(1, commentsCols.length() - 1);
            }
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> cmntRmvdCols = splitter.doGetAllColumns(commentsCols);
            cmntRmvdCols.removeAll(uniqueCols);
            cmntRmvdCols.addAll(uniqueCols);
            colNames = this.doCompareCols(colNames, cmntRmvdCols);
        } else {
            colNames.removeAll(uniqueCols);
            colNames.addAll(uniqueCols);
        }
        return colNames;
    }

    private List<String> doCompareCols(List<String> columnNames, List<String> cmntRemovalCols) {
        String col = null;
        String commentRmvdCol = null;
        boolean flag = false;
        ArrayList<String> colNames = new ArrayList<String>(columnNames);
        for (int iIndex = 0; iIndex < cmntRemovalCols.size(); ++iIndex) {
            commentRmvdCol = cmntRemovalCols.get(iIndex);
            flag = false;
            for (int jIndex = 0; jIndex < colNames.size(); ++jIndex) {
                col = ((String)colNames.get(jIndex)).replaceAll("(?i)#S#\\d+#E#", "").trim();
                if (!col.equalsIgnoreCase(commentRmvdCol)) continue;
                flag = true;
            }
            if (flag) continue;
            colNames.add(commentRmvdCol);
        }
        return colNames;
    }

    private List<String> doRmvGrpinCols(List<String> colNames, List<String> colAliasNames, List<String> remList) {
        ArrayList<String> rmvGrpingCols = new ArrayList<String>(10);
        String column = null;
        int listSize = 0;
        for (String remCol : remList) {
            listSize = colNames.size();
            for (int kIndex = 0; kIndex < listSize; ++kIndex) {
                column = colNames.get(kIndex);
                if (!column.contains(remCol)) continue;
                rmvGrpingCols.add(column);
                if (kIndex >= colAliasNames.size()) continue;
                colAliasNames.set(kIndex, column);
            }
        }
        return rmvGrpingCols;
    }

    private String doChangeAliasInOrderBy(Map<String, String> aliasColumnMap, String orderByStr) {
        String orderByInput = orderByStr;
        for (Map.Entry<String, String> entry : aliasColumnMap.entrySet()) {
            if (!QueryConversionUtility.containsCheck(orderByInput, entry.getValue())) continue;
            orderByInput = this.replaceExactPattern(entry.getValue(), orderByInput, entry.getKey());
        }
        if (orderByInput.contains(".")) {
            orderByInput = orderByInput.replaceAll("\\w+\\.", "");
        }
        return orderByInput;
    }

    private String doChangeAliasInQualify(Map<String, String> aliasColumnMap, String qualifyStr) {
        String qualifyString = qualifyStr;
        String colDef = "";
        String patternString = "";
        for (Map.Entry<String, String> mapEntry : aliasColumnMap.entrySet()) {
            colDef = mapEntry.getValue();
            if (!QueryConversionUtility.containsCheck(qualifyString, colDef)) continue;
            patternString = QueryConversionUtility.doGetAliasPattern(colDef);
            qualifyString = QueryConversionUtility.doReplaceSpecificGrp(qualifyString, patternString, "", mapEntry.getKey(), 1, false);
        }
        return qualifyString;
    }

    private String doGetHavingGrp(String havingGrp, List<String> colAliasNames, String valueString) {
        StringBuffer having = new StringBuffer();
        having.append(")").append("select").append(" ").append(QueryConversionUtility.doGetStrFrmListWithComma(colAliasNames)).append(" ").append("from").append(" ").append("top_function");
        if (havingGrp == null) {
            having.append(" where ");
        } else {
            having.append(havingGrp).append(" and ");
        }
        having.append("TOP_RNK").append("<=").append(valueString);
        return having.toString();
    }

    private String getQualifyOutQry(Map<String, String> parserMap, String qualifyStr, String havingGrp, List<String> colAliasNames) {
        String havingGroup = havingGrp;
        String qualifyString = qualifyStr;
        String colSt = null;
        String operator = null;
        Pattern pattern = Pattern.compile("(?i)(.*?)(=|<=|>=|<\\s*>|>|<|\\seq\\s|\\sgt\\s|\\slt\\s|\\sle\\s|\\sge\\s|\\snot\\s*=|\\sne\\s)(.*)");
        Matcher matcher = pattern.matcher(qualifyString);
        if (matcher.find()) {
            this.colAliasNew = QueryConversionUtility.doGetAliasList(colAliasNames);
            colSt = QueryConversionUtility.doGetStrFrmListWithComma(this.colAliasNew);
            parserMap.put("columnList", colSt);
            operator = matcher.group(2);
            qualifyString = matcher.group(1);
            String cond = matcher.group(3);
            colAliasNames.add(qualifyString + " as " + "RNK");
            String output = "select " + QueryConversionUtility.doGetStrFrmListWithComma(colAliasNames) + " " + "from" + " " + "(" + parserMap.get("groupFn") + ")";
            parserMap.put("groupFn", output);
            havingGroup = havingGroup == null ? " where RNK" + operator + cond : " and RNK" + operator + cond;
            parserMap.put("havingClause", havingGroup);
        }
        return havingGroup;
    }
}

