/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.common.features;

import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MergeFeature {
    public boolean mergeFn(Map<String, String> parserMap) {
        String insertCols;
        String table1 = parserMap.get("query1").replaceAll("commentPattern", "").trim();
        String alias1 = this.doGetTableAlias(table1);
        table1 = this.doGetTableName(table1);
        String onCondtn = parserMap.get("oncondition");
        onCondtn = QueryConversionUtility.removeParenthesis(onCondtn);
        parserMap.put("oncondition", onCondtn);
        if (!QueryConversionUtility.containsCheck(table1, "##SUBQUERY##")) {
            table1 = "( select * from " + table1 + ")";
        }
        table1 = this.removeAsInAlias(table1);
        String table2 = parserMap.get("table2").replaceAll("commentPattern", "").trim();
        String alias2 = this.doGetTableAlias(table2);
        String table2Name = this.doGetTableName(table2);
        table2Name = this.removeAsInAlias(table2Name);
        parserMap.put("whrcondition", "");
        if (parserMap.containsKey("valuecols")) {
            this.doPutNewWhereInMap(parserMap, onCondtn, alias2);
        }
        if ((insertCols = parserMap.get("insertcols")) != null && insertCols.contains(".")) {
            String[] columnNamesArr = QueryConversionUtility.doGetColArr(insertCols);
            insertCols = QueryConversionUtility.remTabAliasInCol(insertCols, columnNamesArr);
            parserMap.put("insertcols", insertCols);
        }
        this.doUpdateSetWhereInMap(parserMap);
        parserMap.put("table1alias", alias1);
        parserMap.put("query1", table1);
        parserMap.put("table2alias", alias2);
        parserMap.put("table2name", table2Name);
        return true;
    }

    private void doPutNewWhereInMap(Map<String, String> parserMap, String onCondtn, String alias2) {
        String valuecolms;
        String valueColumns = valuecolms = parserMap.get("valuecols");
        String whrCondition = "";
        StringBuffer newWhrCondDiffImpl = new StringBuffer(" where ");
        if (QueryConversionUtility.containsCheck(valuecolms, " where")) {
            String valuecolmsLwr = QueryConversionUtility.toLower(valuecolms);
            valueColumns = valuecolms.substring(0, valuecolmsLwr.indexOf("where"));
            whrCondition = valuecolms.substring(valuecolmsLwr.indexOf("where") + 5);
            whrCondition = QueryConversionUtility.removeParenthesis(whrCondition);
            parserMap.put("whrcondition", "and " + whrCondition);
        }
        valueColumns = QueryConversionUtility.removeParenthesis(valueColumns);
        parserMap.put("valuecols", valueColumns);
        Pattern pattern = Pattern.compile("(?i)" + alias2 + "\\.\\w+");
        Matcher matcher = pattern.matcher(onCondtn);
        while (matcher.find()) {
            newWhrCondDiffImpl.append(matcher.group()).append(" IS NULL").append(" and ");
        }
        if (!whrCondition.isEmpty()) {
            newWhrCondDiffImpl.append(whrCondition);
        } else {
            newWhrCondDiffImpl.delete(newWhrCondDiffImpl.length() - 4, newWhrCondDiffImpl.length());
        }
        parserMap.put("newWhereCondn", newWhrCondDiffImpl.toString());
    }

    private void doUpdateSetWhereInMap(Map<String, String> parserMap) {
        String updWhere = parserMap.get("query2");
        if (QueryConversionUtility.containsCheck(updWhere, " where")) {
            int whereIndex = QueryConversionUtility.toLower(updWhere).indexOf("where");
            String setCond = updWhere.substring(0, whereIndex);
            parserMap.put("setFn", setCond);
            String whrCondition = updWhere.substring(whereIndex);
            if (whrCondition.trim().isEmpty()) {
                parserMap.put("updwhere", "where ");
            } else {
                parserMap.put("updwhere", whrCondition + " " + "and");
            }
        } else {
            parserMap.put("setFn", updWhere);
            parserMap.put("updwhere", "where ");
        }
    }

    private String removeAsInAlias(String table) {
        String tableName = table;
        if (QueryConversionUtility.containsCheck(table, "AS")) {
            tableName = tableName.replaceAll("(?i)\\sas(?!\\w)", "");
        }
        return tableName;
    }

    private String doGetTableAlias(String tableName) {
        String tblName = tableName.replaceAll("(?i)#S#\\d+#E#", "").trim();
        String alias = tableName;
        if (tblName.contains(" ")) {
            int braceIndex;
            int aliasIndex;
            int spaceIndex = tblName.lastIndexOf(32);
            int n = aliasIndex = spaceIndex > (braceIndex = tblName.lastIndexOf(41)) ? spaceIndex : braceIndex;
            if (aliasIndex + 1 < tblName.length()) {
                alias = tblName.substring(aliasIndex + 1);
            }
        }
        return alias;
    }

    private String doGetTableName(String tableName) {
        String table = tableName;
        if (tableName.contains(" ")) {
            int braceIndex;
            int aliasIndex;
            int spaceIndex = tableName.lastIndexOf(32);
            int n = aliasIndex = spaceIndex > (braceIndex = tableName.lastIndexOf(41)) ? spaceIndex : braceIndex;
            if (aliasIndex + 1 < tableName.length()) {
                table = tableName.substring(0, aliasIndex + 1);
            }
        }
        return table;
    }
}

