/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.common.handlers;

import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentsHandler {
    private static final String SPLIT_PATTERN = "(\\/\\*)((?:(?!" + System.lineSeparator() + ")\\s*)--)";
    private Map<Integer, List<String>> commentMap = null;
    private Map<String, String> promptMap = null;
    private int commentCount;
    private Pattern splitPattern = Pattern.compile(SPLIT_PATTERN);
    private Pattern commentPattern = Pattern.compile("(?:(.*?)?((?:--.*|\\/\\*.*?\\*\\/))(.*))");
    private String leftoverSqlStmt = null;
    private String sqlStmtRead = "";
    private boolean singleQuoteFlag = false;
    private int queryCountRead = 1;
    private String queryCommentRead = "";
    private String restQryRead = "";
    private String modifiedSqlStmtSeparator;
    private String commentStmtForSeparator;
    private String extraWithQuoteSeparator;
    private String extraForSeparator;
    private String sqlStmtForSeparator;
    private List<String> queryListComment;
    private StringBuffer innerSQLComment;
    private boolean commentFlagWithComm;

    public Map<String, String> getPromptMap() {
        return this.promptMap;
    }

    public void setPromptMap(Map<String, String> promptMap) {
        this.promptMap = promptMap;
    }

    private String commentSeparator(String sql, List<String> commentList, List<String> queryList) {
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        LinkedHashMap<String, String> multiCommentMap = new LinkedHashMap<String, String>(10);
        this.initializeSeparator(sql, quoteMap, multiCommentMap);
        String modifiedSqlTrim = this.modifiedSqlStmtSeparator.trim();
        boolean matchFound = false;
        if (this.isCommentStatement(modifiedSqlTrim)) {
            this.extractCommentStatement(quoteMap, modifiedSqlTrim);
            matchFound = true;
        } else {
            Matcher matcher = this.commentPattern.matcher(this.modifiedSqlStmtSeparator);
            if (matcher.find()) {
                String groupTwo = matcher.group(2);
                String groupThree = matcher.group(3);
                List<String> list = this.getModifiedString(groupTwo, groupThree);
                groupTwo = list.get(0);
                groupThree = list.get(1);
                list.clear();
                this.sqlStmtForSeparator = this.modifiedSqlStmtSeparator = QueryConversionUtility.getRplFromMap(matcher.group(1).trim(), quoteMap, "(##QUOTE##\\d+#)");
                this.commentStmtForSeparator = QueryConversionUtility.getRplFromMap(groupTwo, quoteMap, "(##QUOTE##\\d+#)");
                this.extraWithQuoteSeparator = groupThree;
                this.extraForSeparator = QueryConversionUtility.getRplFromMap(this.extraWithQuoteSeparator, quoteMap, "(##QUOTE##\\d+#)");
                matchFound = true;
            }
        }
        if (matchFound) {
            if (!this.commentStmtForSeparator.isEmpty() && this.updatedSql(commentList, queryList, quoteMap, this.commentStmtForSeparator, this.sqlStmtForSeparator)) {
                queryList.add(sql);
                return sql;
            }
            this.modifiedSqlStmtSeparator = this.doHandleMultipleCmntOnLine(commentList, queryList, this.modifiedSqlStmtSeparator, this.extraForSeparator, this.extraWithQuoteSeparator);
        } else {
            queryList.add(sql);
        }
        quoteMap.clear();
        multiCommentMap.clear();
        return this.modifiedSqlStmtSeparator;
    }

    private void extractCommentStatement(Map<String, String> quoteMap, String modifiedSqlTrim) {
        this.commentStmtForSeparator = QueryConversionUtility.getRplFromMap(modifiedSqlTrim, quoteMap, "(##QUOTE##\\d+#)");
        if (!modifiedSqlTrim.startsWith("--")) {
            int firstCmtIndex = this.commentStmtForSeparator.substring(2, this.commentStmtForSeparator.length()).indexOf("*/") + 2;
            int length = this.commentStmtForSeparator.length();
            if (firstCmtIndex > 1 && firstCmtIndex < length) {
                this.extraWithQuoteSeparator = this.commentStmtForSeparator.substring(firstCmtIndex);
                this.commentStmtForSeparator = this.commentStmtForSeparator.substring(0, firstCmtIndex);
                this.extraForSeparator = QueryConversionUtility.getRplFromMap(this.extraWithQuoteSeparator, quoteMap, "(##QUOTE##\\d+#)");
            }
        }
        this.modifiedSqlStmtSeparator = "";
    }

    private void initializeSeparator(String sql, Map<String, String> quoteMap, Map<String, String> multiCommentMap) {
        this.modifiedSqlStmtSeparator = this.getQuotedComment(sql, quoteMap, multiCommentMap);
        this.commentStmtForSeparator = "";
        this.extraWithQuoteSeparator = "";
        this.extraForSeparator = "";
        this.sqlStmtForSeparator = "";
    }

    private boolean updatedSql(List<String> commentList, List<String> queryList, Map<String, String> quoteMap, String commentStmtQuery, String sqlStmtQuery) {
        String commentStmt = commentStmtQuery;
        String sqlStmt = sqlStmtQuery;
        if (!sqlStmt.contains("/*")) {
            commentStmt = this.doRplSingleToMultiLnCmnt(commentStmt);
        } else if (commentStmt.startsWith("--")) {
            return true;
        }
        if (!sqlStmt.isEmpty()) {
            commentStmt = "\t\t" + commentStmt;
        }
        sqlStmt = this.appendCmntInSqlStmt(sqlStmt, quoteMap);
        commentList.add("#S#" + this.commentCount + "#E#" + "#~#" + commentStmt);
        queryList.add(sqlStmt);
        ++this.commentCount;
        return false;
    }

    private List<String> getModifiedString(String groupTwoStr, String groupThreeStr) {
        char currch;
        char prevch;
        int cur;
        String groupTwo = groupTwoStr;
        String groupThree = groupThreeStr;
        int len = groupTwo.length();
        int prev = 0;
        int commentcount = 0;
        for (cur = 1; cur < len; ++cur) {
            prevch = groupTwo.charAt(prev);
            currch = groupTwo.charAt(cur);
            if (prevch == '/' && currch == '*') {
                ++commentcount;
            } else if (prevch == '*' && currch == '/') {
                --commentcount;
            }
            ++prev;
        }
        if (commentcount != 0 && groupThree != null && !groupThree.isEmpty()) {
            prev = 0;
            len = groupThree.length();
            for (cur = 1; cur < len; ++cur) {
                prevch = groupThree.charAt(prev);
                currch = groupThree.charAt(cur);
                if (prevch == '/' && currch == '*') {
                    ++commentcount;
                } else if (prevch == '*' && currch == '/') {
                    --commentcount;
                }
                if (commentcount == 0) {
                    ++cur;
                    break;
                }
                ++prev;
            }
            groupTwo = groupTwo + groupThree.substring(0, cur);
            groupThree = groupThree.substring(cur);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(0, groupTwo);
        list.add(1, groupThree);
        return list;
    }

    private boolean isCommentStatement(String modifiedSqlTrim) {
        return modifiedSqlTrim.startsWith("--") || modifiedSqlTrim.startsWith("/*") && modifiedSqlTrim.substring(2, modifiedSqlTrim.length()).endsWith("*/");
    }

    private String getQuotedComment(String sql, Map<String, String> quoteMap, Map<String, String> multiCommentMap) {
        String outputSql;
        String modifiedSqlStmt = outputSql = QueryConversionUtility.replacementQuoteComment(sql, quoteMap, multiCommentMap);
        modifiedSqlStmt = QueryConversionUtility.getRplFromMap(modifiedSqlStmt, multiCommentMap, "(##COMMENT##\\d+#)");
        modifiedSqlStmt = QueryConversionUtility.canonicalizeString(modifiedSqlStmt);
        return modifiedSqlStmt;
    }

    private String doHandleMultipleCmntOnLine(List<String> commentList, List<String> queryList, String modifiedSqlStmt, String extra, String extraWithQuote) {
        String extraQry = extra;
        String modifiedSqlStatement = modifiedSqlStmt;
        if (extraQry != null && !extraQry.trim().isEmpty()) {
            Matcher matcher = this.commentPattern.matcher(extraQry = QueryConversionUtility.canonicalizeString(extraQry));
            if (matcher.find()) {
                modifiedSqlStatement = this.commentSeparator(extraQry, commentList, queryList);
            } else {
                modifiedSqlStatement = extraWithQuote;
                queryList.add(extraQry);
            }
        }
        return modifiedSqlStatement;
    }

    private String appendCmntInSqlStmt(String sqlLine, Map<String, String> quoteMap) {
        String sqlStmt = sqlLine;
        sqlStmt = (sqlStmt = QueryConversionUtility.canonicalizeString(sqlStmt)).endsWith(",") && !sqlStmt.contains("--") ? (!sqlStmt.equals(",") ? sqlStmt.substring(0, sqlStmt.lastIndexOf(44)) + " " + "#S#" + this.commentCount + "#E#" + " " + "," : sqlStmt + " " + "#S#" + this.commentCount + "#E#") : sqlStmt + " " + "#S#" + this.commentCount + "#E#" + " ";
        return sqlStmt;
    }

    private String doRplSingleToMultiLnCmnt(String commentLine) {
        String commentStmt = commentLine;
        if (commentStmt.startsWith("--")) {
            commentStmt = commentStmt.replaceFirst("--+", "");
            commentStmt = commentStmt.replaceAll("\\/\\*|\\*\\/", "");
            commentStmt = "/* " + commentStmt + " " + "*/";
        } else {
            HashMap<String, String> map = new HashMap<String, String>(10);
            commentStmt = QueryConversionUtility.getSingleQuoteMap(commentStmt, map);
            commentStmt = commentStmt.replaceAll("\\/\\*|\\*\\/", "");
            commentStmt = "/*" + commentStmt + "*/";
            commentStmt = QueryConversionUtility.getRplFromMap(commentStmt, map, "(##QUOTE##\\d+#)");
            map.clear();
        }
        return commentStmt;
    }

    public Map<Integer, List<String>> getCommentMap() {
        return this.commentMap;
    }

    public void setCommentMap(Map<Integer, List<String>> map) {
        this.commentMap = map;
    }

    public static String commentAdder(List<String> commentList, String outputArray) {
        String output = outputArray;
        String[] commentString = null;
        int replaceCharPosition = 0;
        Collections.reverse(commentList);
        for (String commentPlace : commentList) {
            commentString = commentPlace.split("#~#");
            if (commentString.length > 1) {
                replaceCharPosition = output.indexOf(commentString[0]);
                replaceCharPosition += commentString[1].length();
                output = output.replace(commentString[0], commentString[1]);
            }
            if (output.length() < replaceCharPosition + 1 || output.charAt(replaceCharPosition) != ' ' || output.charAt(replaceCharPosition - 1) != '\n') continue;
            output = output.substring(0, replaceCharPosition) + "" + output.substring(replaceCharPosition + 1);
        }
        return output;
    }

    private String removeCommentFromQuery(List<String> queryList) {
        String returnStr = null;
        int listSize = queryList.size();
        if (listSize >= 1) {
            returnStr = queryList.remove(listSize - 1);
        }
        return returnStr;
    }

    private String endHandleMultiLineComment(int queryCount, String sqlStmt, StringBuffer innerSQL, List<String> commentList, List<String> queryList) {
        boolean commentCntFlag = false;
        String stmt = sqlStmt;
        innerSQL.append(IGaussDBConstants.NEW_LINE);
        if (QueryConversionUtility.containsCheck(stmt, "*/")) {
            int diffComment;
            commentCntFlag = true;
            String comment = stmt.substring(0, stmt.indexOf("*/") + 2);
            innerSQL.append(comment);
            String innerSQLStr = innerSQL.toString();
            int commentStartCount = QueryConversionUtility.countOccurrencesOfSubstring(innerSQLStr, "/*");
            int commentEndCount = QueryConversionUtility.countOccurrencesOfSubstring(innerSQLStr, "*/");
            if (diffComment == 0) {
                queryList.add("#S#" + this.commentCount + "#E#");
            } else {
                if (!QueryConversionUtility.isGaus100()) {
                    for (diffComment = commentStartCount - commentEndCount; diffComment != 0; --diffComment) {
                        innerSQL.append("*/");
                    }
                }
                queryList.add("#S#" + this.commentCount + "#E#");
            }
        }
        String queryComment = null;
        if (commentCntFlag) {
            String commentStmt = null;
            String innerSQLStr = innerSQL.toString();
            commentStmt = innerSQLStr.startsWith("/**") ? IGaussDBConstants.NEW_LINE + innerSQLStr + IGaussDBConstants.NEW_LINE : innerSQLStr + IGaussDBConstants.NEW_LINE;
            commentList.add("#S#" + this.commentCount + "#E#" + "#~#" + commentStmt);
            this.commentMap.put(queryCount, commentList);
            int commentIndex = stmt.indexOf("*/") + 2;
            queryComment = stmt.substring(commentIndex);
        }
        return queryComment;
    }

    private void startHandleMultiLineComment(String sqlStmt, StringBuffer innerSQL, boolean removeComment, List<String> queryList) {
        String sqlStatement = null;
        String queryInComment = "";
        if (removeComment) {
            sqlStatement = this.removeCommentFromQuery(queryList);
        }
        if (sqlStatement == null) {
            sqlStatement = sqlStmt;
        }
        if (sqlStatement.startsWith("/*")) {
            innerSQL.append(sqlStatement);
            sqlStatement = "";
        } else {
            int startIndex = sqlStatement.indexOf("/*");
            innerSQL.append("/*");
            innerSQL.append(QueryConversionUtility.replace(sqlStatement.substring(startIndex), "\\/\\*|\\*\\/", "", true));
            if (startIndex <= sqlStatement.length()) {
                queryInComment = sqlStatement.substring(0, startIndex);
            }
        }
        if (!queryInComment.trim().isEmpty()) {
            queryList.add(queryInComment);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<String> readWithComments(List<String> inputSqlList, String lastComment, String migrateTask) {
        ArrayList<String> commentList = new ArrayList<String>(10);
        ArrayList<String> sqlList = new ArrayList<String>(10);
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        this.initializeReadWithComments();
        Iterator<String> iterator = inputSqlList.iterator();
        block0: while (true) {
            if (!iterator.hasNext()) {
                this.updateCommentMap(lastComment, this.queryListComment, commentList, this.queryCountRead, sqlList);
                this.innerSQLComment.setLength(0);
                return sqlList;
            }
            String sqlQry = iterator.next();
            String[] splitQry = this.getSplitQuery(sqlQry);
            int iIndex = 0;
            while (true) {
                block6: {
                    String queryLine;
                    block5: {
                        block3: {
                            block7: {
                                int singleQtCnt;
                                block4: {
                                    if (iIndex >= splitQry.length) continue block0;
                                    queryLine = splitQry[iIndex];
                                    if ((queryLine = this.getQryLine(queryLine)).isEmpty() || this.commentFlagWithComm) break block3;
                                    this.sqlStmtRead = this.commentSeparator(queryLine, commentList, this.queryListComment);
                                    singleQtCnt = QueryConversionUtility.countOccurrencesOfSubstring(this.sqlStmtRead, "'");
                                    if (this.singleQuoteFlag) break block4;
                                    if (singleQtCnt % 2 == 0) break block5;
                                    this.doChangeTheRestQryIfCntOdd();
                                    break block6;
                                }
                                if (singleQtCnt % 2 == 0) break block7;
                                this.doChangeTheRestQryBasedOnFlag(this.restQryRead);
                                break block5;
                            }
                            this.doChangeTheRestQryIfCntEven(this.restQryRead);
                            break block6;
                        }
                        this.sqlStmtRead = queryLine;
                    }
                    this.extractComments(migrateTask, commentList, sqlList, quoteMap, queryLine);
                    quoteMap.clear();
                }
                ++iIndex;
            }
            break;
        }
    }

    private void initializeReadWithComments() {
        this.innerSQLComment = new StringBuffer(128);
        this.queryListComment = new ArrayList<String>(10);
        this.promptMap = new LinkedHashMap<String, String>(10);
        this.commentFlagWithComm = false;
    }

    private void extractComments(String migrateTask, List<String> commentList, List<String> sqlList, LinkedHashMap<String, String> quoteMap, String queryLine) {
        String sqlWithQuotePattern = QueryConversionUtility.getSingleDoubleQuoteMap(this.sqlStmtRead, quoteMap);
        if (this.commentFlagWithComm && sqlWithQuotePattern.contains("*/")) {
            this.queryCommentRead = this.endHandleMultiLineComment(this.queryCountRead, this.sqlStmtRead, this.innerSQLComment, commentList, this.queryListComment);
            if (this.queryCommentRead != null) {
                Object[] objStore = this.doHandleCommentsInDifferentStages(this.queryCommentRead, this.queryListComment, commentList, this.doSelectTheDelimiterBasedOnMigTask(migrateTask), this.queryCountRead, sqlList);
                this.innerSQLComment = (StringBuffer)objStore[0];
                this.commentFlagWithComm = (Boolean)objStore[1];
                if (objStore[2] instanceof List) {
                    this.queryListComment = (List)objStore[2];
                }
            }
        } else if (this.commentFlagWithComm) {
            this.innerSQLComment.append(IGaussDBConstants.NEW_LINE).append(this.sqlStmtRead);
        } else if (sqlWithQuotePattern.contains("/*") || sqlWithQuotePattern.contains("/**")) {
            this.startHandleMultiLineComment(this.sqlStmtRead, this.innerSQLComment, true, this.queryListComment);
            this.commentFlagWithComm = true;
        } else if (!this.commentFlagWithComm) {
            this.commentFlagWithComm = this.handleCommentFlag(this.queryListComment, commentList, this.queryCountRead, this.sqlStmtRead, sqlWithQuotePattern, sqlList, this.getSeparatorPattern(migrateTask), this.doSelectTheDelimiterBasedOnMigTask(migrateTask), queryLine, this.commentFlagWithComm, this.getCommentQuery(queryLine));
        }
    }

    public String getQryLine(String qryLine) {
        String queryLine = qryLine;
        if (QueryConversionUtility.isGaus100() && QueryConversionUtility.containsCheck(queryLine, "parallel")) {
            queryLine = queryLine.replaceAll("(?i)(.*)\\/\\*\\s*\\+\\s*parallel\\s*\\(.*?\\*\\/(.*)", "$1 $2");
        }
        queryLine = this.doCheckForStartsWithPromptKeyword(queryLine);
        if (this.leftoverSqlStmt != null && !this.leftoverSqlStmt.trim().isEmpty()) {
            queryLine = this.doUpdateTheQueryLine(queryLine);
        }
        return queryLine;
    }

    private String doUpdateTheQueryLine(String queryLine) {
        String qryLine = queryLine;
        qryLine = this.leftoverSqlStmt + " " + qryLine;
        this.leftoverSqlStmt = "";
        return qryLine;
    }

    private String doSelectTheDelimiterBasedOnMigTask(String migrateTask) {
        boolean replaceSlash;
        String delimiter = ApplicationPropertyLoader.getStringProperty(migrateTask + "Delimiter");
        boolean bl = replaceSlash = "/".equals(ApplicationPropertyLoader.getStringProperty("queryDelimiter")) && migrateTask.equalsIgnoreCase("query");
        if (replaceSlash) {
            delimiter = ";";
        }
        return delimiter;
    }

    private void doChangeTheRestQryIfCntEven(String restQry) {
        this.restQryRead = this.sqlStmtRead = this.restQryRead + this.sqlStmtRead;
    }

    private void doChangeTheRestQryIfCntOdd() {
        this.singleQuoteFlag = true;
        this.restQryRead = this.sqlStmtRead;
    }

    private void doChangeTheRestQryBasedOnFlag(String restQry) {
        this.singleQuoteFlag = false;
        this.sqlStmtRead = this.restQryRead + this.sqlStmtRead;
        this.restQryRead = "";
    }

    private String doCheckForStartsWithPromptKeyword(String input) {
        String output = input.trim();
        if (!QueryConversionUtility.isGaus100() && QueryConversionUtility.toLower(output).startsWith("spool")) {
            output = output.trim().replaceFirst("(?i)spool\\s+.*", "/*$0*/");
        }
        if (QueryConversionUtility.toLower(output).startsWith("prompt")) {
            if (!QueryConversionUtility.isGaus100()) {
                output = output.replaceFirst("(?i)prompt", "echo");
                output = "\\" + output;
            }
            output = this.doPutUserDefinedQuoteIntoMap(output);
        }
        return output;
    }

    private String doPutUserDefinedQuoteIntoMap(String inputSql) {
        String quote = null;
        int size = this.promptMap.size();
        if (inputSql != null) {
            quote = "##~PR" + size + "~##";
            this.promptMap.put(quote, inputSql);
        }
        return quote;
    }

    private Object[] doHandleCommentsInDifferentStages(String queryComment, List<String> queryList, List<String> commentList, String delimiter, int queryCount, List<String> sqlList) {
        StringBuffer innerSQL = new StringBuffer();
        boolean commentFlag = false;
        ++this.commentCount;
        if ((queryComment = QueryConversionUtility.canonicalizeString(queryComment)).contains("/*") || queryComment.contains("--")) {
            commentFlag = this.doHandleMultiLineComments(queryList, commentList, queryComment, innerSQL, commentFlag);
        } else {
            if (!queryComment.trim().isEmpty()) {
                queryList.add(queryComment);
            }
            if (queryComment.trim().endsWith(delimiter)) {
                queryList = this.handleDelimiterCase(queryList, commentList, queryCount, sqlList);
                commentFlag = false;
            }
        }
        Object[] objStore = new Object[]{innerSQL, commentFlag, queryList};
        return objStore;
    }

    private boolean doHandleMultiLineComments(List<String> queryList, List<String> commentList, String queryComment, StringBuffer innerSQL, boolean commentFlag) {
        boolean flag = commentFlag;
        if (queryComment.contains("*/") || queryComment.contains("--")) {
            this.commentSeparator(queryComment, commentList, queryList);
        } else {
            this.startHandleMultiLineComment(queryComment, innerSQL, false, queryList);
            flag = true;
        }
        return flag;
    }

    private void updateCommentMap(String lastComment, List<String> queryList, List<String> commentList, int queryCount, List<String> sqlList) {
        List<String> commentListQry = commentList;
        if (lastComment == null) {
            if (!queryList.isEmpty()) {
                sqlList.add(String.join((CharSequence)" ", queryList));
                this.commentMap.put(queryCount, commentListQry);
            }
        } else if (!lastComment.isEmpty() && this.commentMap != null && queryCount < commentListQry.size()) {
            commentListQry = this.commentMap.get(queryCount);
            String query = sqlList.get(sqlList.size() - 1);
            sqlList.remove(sqlList.size() - 1);
            query = query + "#S#1000##E#";
            sqlList.add(query);
            commentListQry.add("#S#1000##E##~#" + IGaussDBConstants.NEW_LINE + lastComment);
            this.commentMap.put(queryCount, commentListQry);
        }
    }

    private boolean handleCommentFlag(List<String> queryList, List<String> commentList, int queryCount, String sqlStmt, String sqlWithQuotePattern, List<String> sqlList, String separatorPattern, String delimiter, String queryLine, boolean flagComment, String commentQuery) {
        boolean commentFlag = flagComment;
        String sqlStmtQry = sqlStmt;
        if (queryLine.replace(commentQuery, "").matches(separatorPattern) && !commentQuery.trim().endsWith(delimiter) || sqlStmtQry.replace(commentQuery, "").trim().contains(delimiter)) {
            if ("*/".equals(queryLine.trim()) && !queryList.isEmpty()) {
                sqlStmtQry = queryList.remove(queryList.size() - 1).replace("*/", "");
                queryList.add(sqlStmtQry);
            }
            String sqlQuery = String.join((CharSequence)" ", queryList);
            if (sqlWithQuotePattern.trim().contains(delimiter) && (sqlQuery.trim().matches(separatorPattern) || ";".equals(delimiter))) {
                if (!sqlStmtQry.trim().endsWith(delimiter)) {
                    String origInput = queryList.size() > 0 ? queryList.get(queryList.size() - 1) : sqlStmtQry;
                    int semiColonIndex = origInput.indexOf(";") + 1;
                    this.leftoverSqlStmt = origInput.substring(semiColonIndex);
                    int sqlIndex = sqlQuery.lastIndexOf(";");
                    sqlQuery = sqlQuery.substring(0, sqlIndex + 1);
                }
                this.updateSqlList(commentList, sqlQuery, queryCount, sqlList, queryList);
                commentFlag = false;
            }
        }
        if (sqlWithQuotePattern.contains("*/") && !queryList.isEmpty()) {
            sqlStmtQry = queryList.remove(queryList.size() - 1).replace("*/", "");
            queryList.add(sqlStmtQry);
        }
        return commentFlag;
    }

    private void updateSqlList(List<String> commentList, String sqlQuery, int queryCount, List<String> sqlList, List<String> queryList) {
        if (!commentList.isEmpty()) {
            this.commentMap.put(queryCount, commentList);
        }
        if (sqlList.size() % 100 == 0) {
            ProgressUtil.printProgress();
        }
        sqlList.add(sqlQuery);
        queryList.clear();
    }

    private List<String> handleDelimiterCase(List<String> queryList, List<String> commentList, int queryCount, List<String> sqlList) {
        this.commentMap.put(queryCount, commentList);
        sqlList.add(String.join((CharSequence)" ", queryList));
        queryList.clear();
        return queryList;
    }

    private String getCommentQuery(String queryLine) {
        Pattern pattern;
        Matcher matcher;
        String commentQuery = "";
        if (queryLine.contains("--") && !queryLine.contains("/*") && (matcher = (pattern = Pattern.compile("(--.*)")).matcher(queryLine)).find()) {
            commentQuery = matcher.group(1);
        }
        return commentQuery;
    }

    private String[] getSplitQuery(String sqlQry) {
        String sqlQuery = sqlQry;
        Matcher commentMatcher = this.splitPattern.matcher(sqlQuery);
        if (commentMatcher.find()) {
            String group1 = commentMatcher.group(1);
            String group2 = commentMatcher.group(2);
            sqlQuery = sqlQuery.replace(group1 + group2, group1 + IGaussDBConstants.NEW_LINE + group2);
        }
        String[] splitQry = sqlQuery.split(IGaussDBConstants.NEW_LINE);
        return splitQry;
    }

    private String getSeparatorPattern(String migrateTask) {
        String separatorPattern = ".*?(;)\\s*\\/?";
        if (migrateTask.equalsIgnoreCase("blogic")) {
            separatorPattern = "(?i).*end\\s*(\\w+\\s*)?;\\s*(?:#s#\\d+#e#\\s*)*?\\/";
        }
        return separatorPattern;
    }

    public static List<String> replacementForQuote(List<String> inputSqlList, Map<String, String> quoteMap, String quotePattern) {
        for (int jIndex = 0; jIndex < inputSqlList.size(); ++jIndex) {
            String query = inputSqlList.get(jIndex);
            query = QueryConversionUtility.getRplFromMap(query, quoteMap, quotePattern);
            inputSqlList.set(jIndex, query);
        }
        return inputSqlList;
    }
}

