/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.common.handlers;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.factory.MigrationFactoryProducer;
import com.huawei.db.migration.interfaces.IPostMigrationService;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrationPostProcessor
implements Runnable {
    private static final Logger logger = LogManager.getLogger(MigrationPostProcessor.class);
    private String srcFolder = null;
    private String targetFolder = null;
    private String sourceDb = null;
    private String fileName = null;
    private String migrationTask = null;
    private Set<String> packageChanges = null;
    private String changeType = null;

    public MigrationPostProcessor(String fileName, IMigrationInputBO objInputData, Set<String> packageChanges, String changeType) {
        this.fileName = fileName;
        this.srcFolder = objInputData.getSourceFolderLoc();
        this.targetFolder = objInputData.getTargetFolderLoc();
        this.sourceDb = objInputData.getSourceDb();
        this.migrationTask = objInputData.getMigTaskName();
        this.packageChanges = packageChanges;
        this.changeType = changeType;
    }

    @Override
    public void run() {
        List<String> inputStatements = null;
        List<String> outputList = null;
        FileHandler objFilehandler = new FileHandler();
        boolean postProcessor = true;
        File finTempFile = null;
        try {
            File src;
            String srcToString;
            String srcStr = FilenameUtils.normalize((String)this.srcFolder);
            if (srcStr != null && (srcToString = (src = new File(srcStr)).toString()).length() + 1 < this.fileName.length()) {
                String outFile = this.fileName.substring(srcToString.length() + 1);
                File outTempFile = new File(this.targetFolder, "output");
                finTempFile = new File(outTempFile, outFile = outFile.replace("dsql", "gsql"));
                String normalizeOutput = FilenameUtils.normalize((String)finTempFile.getCanonicalPath());
                if (normalizeOutput != null) {
                    inputStatements = objFilehandler.readInputFile(normalizeOutput, null, this.targetFolder, this.migrationTask, postProcessor);
                }
            }
            if (inputStatements != null && !inputStatements.isEmpty()) {
                MigrationAbstractFactory objAbtFactory = MigrationFactoryProducer.getDataBaseFactory(this.sourceDb);
                IPostMigrationService objMigTaskService = objAbtFactory.getPostMigrationService();
                if (objMigTaskService != null) {
                    outputList = objMigTaskService.handlePostMigration(this.fileName, inputStatements, this.packageChanges, this.changeType);
                }
                if (outputList != null && !outputList.isEmpty()) {
                    objFilehandler.writeOutputFile(this.fileName, outputList, this.targetFolder, true, this.srcFolder);
                }
            }
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + "IO Exception while post-processing the file:" + this.fileName);
        }
        catch (RuntimeException re) {
            String errorStr = re.getCause() instanceof InterruptedException ? "Thread interrupted due to Timeout." : ErrorLoggerUtility.getExceptionDetails(re) + " Error occurred in DSC Processor";
            logger.error(errorStr);
            ErrorLoggerUtility.failedFileCnt(this.fileName);
        }
    }
}

