/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.db2;

import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.db2.DB2PreQueryChanges;
import com.huawei.db.migration.db2.DB2QueryMigrationService;
import com.huawei.db.migration.db2.DB2SchemaMigrationService;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DB2BLogicHandler {
    private static final Logger logger = LogManager.getLogger(DB2BLogicHandler.class);
    private List<IQuerySplitterPatternsBO> querySplitterPatterns = null;
    private List<IQueryPatternsBO> queryPatterns = null;

    public List<String> doBLogicProcess(List<String> inputList, String fileName, List<?> bLogicPatterns) {
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        String output = null;
        String input = null;
        List<IBulkSplitPatternsBO> bLogicSplitPatterns = bLogicPatterns;
        for (int position = 0; position < inputList.size(); ++position) {
            try {
                input = inputList.get(position);
                output = QueryConversionUtility.doRemoveExtraSpace(input);
                output = this.doProcessFnProc(fileName, bLogicSplitPatterns, position, input);
                outputList.add(output);
            }
            catch (RuntimeException e) {
                this.handleException(e, fileName, position);
                outputList.add(input);
            }
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private void handleException(Exception e, String fileName, int position) {
        ErrorLoggerUtility.updateQryCnt();
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while processing input in BLogic Migration. " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + (position + 1));
    }

    private String doProcessFnProc(String fileName, List<IBulkSplitPatternsBO> bLogicSplitPatterns, int position, String input) {
        String output = input;
        output = DB2PreQueryChanges.doPreBLogicChanges(output);
        output = DB2PreQueryChanges.doAddCommonChangesForBothBulkAndBlogic(output);
        for (IBulkSplitPatternsBO typeBO : bLogicSplitPatterns) {
            HashMap<String, String> quoteList = new HashMap<String, String>(10);
            output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, quoteList, "'", "\\'.*?\\'", "~#~~#~~");
            boolean isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(typeBO.getExcludePattern(), output);
            output = QueryConversionUtility.getRplFromMap(output, quoteList, "(~#~~#~~\\d+#)");
            if (!isExcludePatternValidation) continue;
            output = this.doMigrateDBObjects(fileName, position, output, typeBO);
            break;
        }
        return output;
    }

    private String doMigrateDBObjects(String fileName, int position, String inputQuery, IBulkSplitPatternsBO typeBO) throws MigrationServiceException {
        String output = inputQuery;
        String taskName = typeBO.getName();
        if ("DML Pattern".equals(taskName)) {
            output = this.doHandleDMLPattern(fileName, position, inputQuery, typeBO);
        }
        output = output.replace("~EXT~SB~PTRN~", "EXTRACT");
        output = output.replace("~FRM~SB~PTRN~", "from");
        return output;
    }

    private String doHandleDMLPattern(String fileName, int position, String inputQuery, IBulkSplitPatternsBO typeBO) {
        String output = inputQuery;
        GenericJSONParser objJSONParser = new GenericJSONParser();
        this.queryPatterns = objJSONParser.getJSONObject("db2-query");
        this.querySplitterPatterns = objJSONParser.getJSONObject("db2-query-splitter");
        List<?> bLogicSplitter = objJSONParser.getJSONObject("db2-blogic-splitter");
        List<IQueryPatternsBO> schemaPatterns = objJSONParser.getJSONObject("db2-schema");
        Pattern pattern = Pattern.compile(typeBO.getFinderPattern(), 2);
        Matcher matcher = pattern.matcher(output);
        while (matcher.find()) {
            String tempQuery = matcher.group(2);
            boolean isExcludePatternValidation = false;
            String migrationType = "";
            for (IBulkSplitPatternsBO identifierBO : bLogicSplitter) {
                Pattern patternSplitter;
                Matcher matcherSplitter;
                isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(identifierBO.getExcludePattern(), tempQuery);
                if (!isExcludePatternValidation || !(matcherSplitter = (patternSplitter = Pattern.compile(identifierBO.getFinderPattern(), 2)).matcher(tempQuery)).find()) continue;
                migrationType = identifierBO.getName();
                break;
            }
            String outputSQL = this.doCallMigrationTypeService(migrationType, tempQuery, fileName, schemaPatterns, position);
            if (tempQuery.startsWith(" ") && !outputSQL.startsWith(" ")) {
                outputSQL = " " + outputSQL;
            }
            output = output.replace(tempQuery, outputSQL);
            ProgressUtil.printProgress();
        }
        return output;
    }

    private String doCallMigrationTypeService(String migrationtype, String inputSql, String fileName, List<IQueryPatternsBO> schemaPatterns, int position) throws MigrationServiceException {
        int queryCnt = 0;
        String outputSQL = inputSql;
        StringBuffer inputQuery = new StringBuffer(inputSql);
        inputQuery.append("~#~").append(position);
        IMigrationTaskService objTaskService = null;
        switch (migrationtype) {
            case "Query": {
                objTaskService = new DB2QueryMigrationService();
                outputSQL = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, this.queryPatterns, this.querySplitterPatterns);
                break;
            }
            case "Schema": {
                objTaskService = new DB2SchemaMigrationService();
                outputSQL = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, schemaPatterns, this.querySplitterPatterns);
                break;
            }
            case "Schema with Query": {
                Map<String, String> queryMap = new LinkedHashMap<String, String>(10);
                String input = QueryConversionUtility.doGetSchemaQueries(inputQuery.toString(), queryMap, queryCnt);
                objTaskService = new DB2SchemaMigrationService();
                outputSQL = objTaskService.handleMigrationTask(input, fileName, schemaPatterns, this.querySplitterPatterns);
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, this.queryPatterns, this.querySplitterPatterns, queryMap, new DB2QueryMigrationService());
                outputSQL = QueryConversionUtility.doReplaceFunctionVariables(outputSQL, queryMap, "##QUERY##");
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_004_023] " + MessageLoader.getMessage("DSC_ERR_004_023") + "." + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
            }
        }
        if (outputSQL.contains("~#~")) {
            outputSQL = outputSQL.split("~#~")[0];
        }
        return outputSQL;
    }
}

