/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.db2;

import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2PreQueryChanges {
    private static final Pattern DATE_SELECT = Pattern.compile("(?i)(?<!\\w)(date\\s*\\()\\s*(\\()?\\s*((?<!\\w)select(?!\\w))?");
    private static final Pattern VALUES_SELECT = Pattern.compile("(?i)(values\\s*\\()(.*?\\))\\s*select");
    private static final Pattern WITH_AS_SELECT = Pattern.compile("(?i)with\\s+rec.*?(\\(.*?\\)\\s*)as.*?select(.*?)from.*?;");
    private static final Pattern FETCH_FIRST_ONLY = Pattern.compile("(?i)(?i)(?<!\\w)fetch\\s+first\\s+(\\d+\\s+)?rows?\\s+only");
    private static final Pattern CREATE_INDEX_REVERSE_SCANS = Pattern.compile("(?i)(?<!\\w)Create\\s+Index .*?((ALLOW|DISALLOW)\\s+REVERSE\\s+SCANS)(?!\\w)");
    private static final Pattern WITH_DEFAULT = Pattern.compile("(?i)(?<!\\w)(with\\s+default)(?!\\w)\\s*(\\d+|\\'\\w+\\')?");

    public static String doPreSchemaChanges(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "GENERATED")) {
            output = DB2PreQueryChanges.doCreateSequence(output);
        }
        return output;
    }

    public static String doPreQueryChanges(String input) {
        String output = input;
        if (output.matches("(?i).*?(?<!\\w)(select)(?!\\w).*?(?<!\\w)(table\\s*\\().*")) {
            output = DB2PreQueryChanges.doRemoveTable(output);
        }
        return output;
    }

    private static String doReplaceDateFunc(String input) {
        String output = input;
        Matcher matcher = DATE_SELECT.matcher(output);
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        int endIndex = 0;
        int tempIndex = 0;
        while (matcher.find()) {
            String groupOneRegex = "(?i)(?<!\\w)(date\\s*\\()";
            String groupTwo = matcher.group(2);
            String groupThree = matcher.group(3);
            tempIndex = matcher.start(1);
            String sequenceStr = QueryUtilityExt.doGetStringFromGivenIndex(matcher.start(1), input);
            endIndex = matcher.start(1) + sequenceStr.length();
            sequenceStr = sequenceStr.replaceFirst(groupOneRegex, "");
            sb.append(output.substring(startIndex, tempIndex));
            if (groupThree == null || groupTwo != null) {
                sb.append("mig_db2_ext.mig_db2_fn_date(");
                sb.append(sequenceStr);
            } else {
                sb.append("mig_db2_ext.mig_db2_fn_date((");
                sb.append(sequenceStr).append(")");
            }
            startIndex = endIndex;
        }
        sb.append(output.substring(endIndex));
        output = sb.toString();
        return output;
    }

    public static String doPreBLogicChanges(String input) {
        String output = input;
        return output;
    }

    public static String doPreBulkChanges(String input) {
        String output = input;
        HashMap<String, String> map = new HashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, map);
        if (QueryConversionUtility.containsCheck(output = DB2PreQueryChanges.doPreKeywordChanges(output), "OPTIMIZATION")) {
            output = DB2PreQueryChanges.doCommentForeignKey(output);
        }
        if (QueryConversionUtility.containsCheck(output = DB2PreQueryChanges.schemaNameRemoval(output), "NICKNAME")) {
            output = output.replaceAll("(?i)(?<!\\w)(CREATE|ALTER)\\s+(NICKNAME)(?!\\w)", " $1 SYNONYM");
        }
        output = QueryConversionUtility.getRplFromMap(output, map, "(##QUOTE##\\d+#)");
        map.clear();
        if (QueryConversionUtility.containsCheck(output, "DEFAULT")) {
            output = DB2PreQueryChanges.doRemoveWithDefault(output);
        }
        return output;
    }

    private static String doRemoveTable(String input) {
        String output = input;
        output = output.replaceAll("(?i)(?<!\\w)(table\\s*\\()", "(");
        return output;
    }

    private static String doRemoveDiagnosticsWord(String input) {
        String output = input;
        output = output.replaceAll("(?i)(.*?)(?<!\\w)(GET\\s+DIAGNOSTICS)(?!\\w)(.*?)(=\\s+row_count)(.*)", "$1 $3 = SQL%ROWCOUNT $5");
        return output;
    }

    private static String doCreateSequence(String input) {
        String output = input;
        String regex = "(?i)(.*?)((GENERATED\\s+by\\s+default)(.*?))\\(";
        String tempStr = output;
        Matcher matcher = Pattern.compile(regex).matcher(tempStr);
        StringBuffer sb = new StringBuffer();
        String sequenceStr = "";
        String tableName = QueryConversionUtility.getTableName(output).trim();
        while (matcher.find()) {
            int startSequenceIndex = matcher.end(4);
            String groupTwo = matcher.group(2);
            String columnName = DB2PreQueryChanges.dogetColumnName(tempStr.substring(0, matcher.start(2)).trim());
            String sequenceName = "mseq_" + tableName + "_" + columnName;
            sb.append("CREATE SEQUENCE " + sequenceName);
            sequenceStr = QueryUtilityExt.doGetStringFromGivenIndex(startSequenceIndex, tempStr).trim();
            output = output.replace(groupTwo, "default " + sequenceName + "." + "NEXTVAL");
            if (sequenceStr.startsWith("(") && sequenceStr.endsWith(")")) {
                output = output.replace(sequenceStr, "");
                sequenceStr = sequenceStr.substring(1, sequenceStr.length() - 1);
            } else {
                output = output.replace(sequenceStr, "");
            }
            if (QueryConversionUtility.containsCheck(sequenceStr, "\"order\"")) {
                sequenceStr = sequenceStr.replaceAll("(?i)(?<!\\w)(\"\\s*(order)\\s*\")(?!\\w)", "$2");
            }
            sequenceStr = DB2PreQueryChanges.removeSpace(sequenceStr);
            sb.append(sequenceStr);
            sb.append(";");
        }
        sb.append(" ").append(output);
        return sb.toString();
    }

    private static String removeSpace(String input) {
        String output = input;
        output = output.replaceAll("(?i)(?<!\\w)(no)(?:\\s+)(cycle|order|cache)(?!\\w)", "$1$2");
        return output;
    }

    private static String dogetColumnName(String substring) {
        String columName = "";
        String str = substring;
        int bracketCount = 0;
        for (int index = str.length() - 1; index >= 0; --index) {
            if (str.charAt(index) == ')') {
                ++bracketCount;
                continue;
            }
            if (str.charAt(index) == '(') {
                if (--bracketCount >= 0) continue;
                str = str.substring(index + 1, str.length()).trim();
                return str.substring(0, str.indexOf(" "));
            }
            if (str.charAt(index) != ',') continue;
            str = str.substring(index + 1, str.length()).trim();
            return str.substring(0, str.indexOf(" "));
        }
        return columName;
    }

    public static String doPreKeywordChanges(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "CURRENT") && QueryConversionUtility.containsCheck(output, "DATE")) {
            output = output.replaceAll("(?<!\\w)(CURRENT\\s+DATE)(?!\\w)", "CURRENT_DATE");
        }
        if (QueryConversionUtility.containsCheck(output = DB2PreQueryChanges.doPutQuoteOnGaussKeyword(output), "LOGGED")) {
            output = output.replaceAll("((?<!\\w)(?:LOGGED|UNLOGGED)(?!\\w))", "/* $1 */");
        }
        if (QueryConversionUtility.containsCheck(output, "COMPACT")) {
            output = output.replaceAll("((?<!\\w)(?:COMPACT|NOT\\s+COMPACT)(?!\\w))", "/* $1 */");
        }
        if (QueryConversionUtility.containsCheck(output, "ORGANIZE")) {
            output = output.replaceFirst("(?i)(ORGANIZE\\s+BY\\s*.*?);", "/* $1 */;");
        }
        if (QueryConversionUtility.containsCheck(output, "CURRENT") && QueryConversionUtility.containsCheck(output, "TIMESTAMP")) {
            output = output.replaceAll("(?<!\\w)(CURRENT\\s+TIMESTAMP)(?!\\w)", "CURRENT_TIMESTAMP");
        }
        if (QueryConversionUtility.containsCheck(output, "IN")) {
            output = DB2PreQueryChanges.doInChange(output);
        }
        return output;
    }

    public static String doAddCommonChangesForBothBulkAndBlogic(String input) {
        String output = input;
        HashMap<String, String> map = new HashMap<String, String>(10);
        if ((output = QueryConversionUtility.getSingleDoubleQuoteMap(output, map)).matches("(?i).*(?<!\\w)(LONG\\s+(?:VARCHAR|VARGRAPHIC))(?!\\w).*")) {
            output = output.replaceAll("(?i)(?<!\\w)(LONG\\s+(?:VARCHAR|VARGRAPHIC))(?!\\w)", "CLOB");
        }
        if (QueryConversionUtility.containsCheck(output, "BLOB") || QueryConversionUtility.containsCheck(output, "CLOB")) {
            output = output.replaceAll("(?i)(?<!\\w)(BLOB|CLOB)\\s*(\\(\\s*\\d+\\s*\\w*\\s*\\))", "$1");
        }
        if (output.matches("(?i)(?<!\\w)(?:select|(?:create|alter)\\s+table|insert|update|delete)(?!\\w).*?\\(?\\s*(?:month|year)\\s*\\((.*?)\\).*?;")) {
            output = output.replaceAll("(?i)(?<!\\w)((?:month|year))\\s*\\((.*?)(?!\\w)", "~EXT~SB~PTRN~ ( $1 ~FRM~SB~PTRN~ $2");
        }
        if (output.matches("(?i)(?<!\\w)(?:select|(?:create|alter)\\s+table|insert|update|delete)(?!\\w).*?(?<!\\w)posstr\\s*\\(.*?\\).*?;")) {
            output = output.replaceAll("(?i)(?<!\\w)posstr\\s*\\(", "INSTR(");
        }
        if (output.matches("(?i)(?<!\\w)(?:select|(?:create|alter)\\s+table|insert|update|delete)(?!\\w).*?(?<!\\w)value\\s*\\(.*?\\).*?;")) {
            output = output.replaceAll("(?i)(?<!\\w)value\\s*\\(", "COALESCE(");
        }
        if (QueryConversionUtility.containsCheck(output, "fetch")) {
            output = DB2PreQueryChanges.changeFetchToLimit(output);
        }
        if (QueryConversionUtility.containsCheck(output, "DIAGNOSTICS")) {
            output = DB2PreQueryChanges.doRemoveDiagnosticsWord(output);
        }
        if (output.matches("(?i).*?(?<!\\w)(date\\s*\\().*")) {
            output = DB2PreQueryChanges.doReplaceDateFunc(output);
        }
        output = DB2PreQueryChanges.replaceValWithSel(output);
        output = DB2PreQueryChanges.doWithAsInColList(output);
        output = QueryConversionUtility.getRplFromMap(output, map, "(##QUOTE##\\d+#)");
        return output;
    }

    public static String replaceValWithSel(String input) {
        String output = input;
        Matcher withVal = VALUES_SELECT.matcher(output);
        String valList = "";
        if (withVal.find()) {
            valList = withVal.group(2);
            output = output.replace(withVal.group(1), "select");
            output = output.replace(valList, valList.substring(0, valList.length() - 1));
            valList = valList.replace(valList, valList.substring(0, valList.length() - 1)).trim();
            output = output.replace(valList, valList.substring(0, valList.length() - 1) + "FROM DUAL" + valList.substring(valList.length() - 1));
        }
        return output;
    }

    public static String doWithAsInColList(String input) {
        String output = input;
        Matcher withRec = WITH_AS_SELECT.matcher(output);
        StringBuffer sb = new StringBuffer();
        String alias = "";
        String tempAlias = "";
        String column = "";
        int tempIdx = 0;
        int endIdx = 0;
        if (withRec.find()) {
            alias = withRec.group(1);
            tempIdx = withRec.start(2);
            endIdx = withRec.end(2);
            column = withRec.group(2);
            tempAlias = alias.trim();
            tempAlias = tempAlias.substring(1, tempAlias.length() - 1);
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> colList = splitter.doGetAllColumns(column);
            List<String> aliasListCols = QueryConversionUtility.getColList(colList);
            List<String> aliasListRec = splitter.doGetAllColumns(tempAlias);
            for (int i = 0; i < aliasListCols.size() && i < aliasListRec.size(); ++i) {
                String mergedElements = aliasListCols.get(i) + " " + "AS" + " " + aliasListRec.get(i);
                aliasListCols.set(i, mergedElements);
            }
            sb.append(output.substring(0, tempIdx));
            column = String.join((CharSequence)", ", aliasListCols);
            sb.append(" ").append(column).append(" ");
        }
        sb.append(output.substring(endIdx));
        output = sb.toString();
        output = output.replace(alias, "");
        return output;
    }

    public static String changeFetchToLimit(String input) {
        String output = input;
        Matcher fetch = FETCH_FIRST_ONLY.matcher(output);
        String digit = "";
        while (fetch.find()) {
            String matcherGroup = fetch.group();
            digit = fetch.group(1);
            if (digit == null) {
                digit = "1";
            }
            output = output.replaceFirst(matcherGroup, "LIMIT " + digit);
        }
        return output;
    }

    public static String schemaNameRemoval(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "INDEX")) {
            output = DB2PreQueryChanges.doRemoveSchemaName(output);
            output = DB2PreQueryChanges.doCommentReversScan(output);
        }
        return output;
    }

    private static String doCommentReversScan(String input) {
        String output = input;
        if (output.matches("(?i).*(?<!\\w)Create\\s+Index.*?((ALLOW|DISALLOW)\\s+REVERSE\\s+SCANS)(?!\\w).*")) {
            Matcher matcher = CREATE_INDEX_REVERSE_SCANS.matcher(output);
            StringBuffer buffer = new StringBuffer();
            int endIndex = 0;
            int startIndex = 0;
            while (matcher.find()) {
                int beginIndex = matcher.start();
                buffer.append(output.substring(startIndex, beginIndex));
                endIndex = matcher.end();
                String matcherFullGrp = matcher.group();
                buffer.append(matcherFullGrp.replace(matcher.group(1), " /* " + matcher.group(1) + " */ "));
                startIndex = endIndex;
            }
            buffer.append(input.substring(endIndex));
            output = buffer.toString();
        }
        return output;
    }

    private static String doRemoveSchemaName(String input) {
        String output = input;
        output = output.replaceAll("(?i)(?<!\\w)(create\\s+index)(?!\\w)(\\s+)(.*?)(?:\\.)(.*)", "$1$2$4");
        return output;
    }

    private static String doRemoveWithDefault(String input) {
        String output = input;
        if (output.matches("(?i)(.*?)(?<!\\w)(?:create|alter)\\s+table(?!\\w)(?:.*?)(?<!\\w)(with\\s+default)(?!\\w)\\s*(\\d+|\\'\\w+\\')?(.*)")) {
            Matcher matcher = WITH_DEFAULT.matcher(output);
            while (matcher.find()) {
                String withDefault = matcher.group(1);
                String defaultValues = matcher.group(2);
                if (defaultValues == null) {
                    output = output.replaceFirst(withDefault, "");
                    continue;
                }
                output = output.replaceFirst(withDefault, "default");
            }
        }
        return output;
    }

    private static String doInChange(String input) {
        String output = input;
        output = output.replaceAll("(?i)(?<!\\w)(create\\s+table(?:.*?))(?<!\\w)(in)(?!\\w)(.*)", "$1 TABLESPACE $3");
        return output;
    }

    private static String doCommentForeignKey(String input) {
        String output = input;
        output = output.replaceAll("(?i)(?<!\\w)(ON\\s+UPDATE\\s+RESTRICT\\s+ENFORCED\\s+ENABLE\\s+QUERY\\s+OPTIMIZATION)(?!\\w)", "/* $1 */");
        return output;
    }

    private static String doPutQuoteOnGaussKeyword(String input) {
        String output = input;
        if (output.matches("(?i).*?(?<!\\w)((?:create|alter)\\s+table|select|update|insert|(?:create\\s+(?:view|index)))(?!\\w)(.*?)(?<!\\w)(order(?!\\s+by)|user|date)(?!\\w)(.*)")) {
            output = output.replaceAll("(?i)(?<!\\w)(order(?!\\s+by)|user)(?!\\w)", "\"$1\"");
            output = output.replaceAll("(?i)(?<!\\w)(date)(?!\\w|\\s*\\()", "\"$1\"");
        }
        return output;
    }
}

