/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.db2;

import com.huawei.db.migration.db2.DB2PreQueryChanges;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DB2SchemaHandler {
    private static final Logger logger = LogManager.getLogger(DB2SchemaHandler.class);

    public List<String> doSchemaProcess(List<String> inputList, String fileName, List<?> patterns) throws MigrationServiceException {
        String output = null;
        int position = 0;
        ArrayList<String> outputList = new ArrayList<String>(10);
        for (String input : inputList) {
            try {
                String[] inputSplit;
                ++position;
                if (input.contains("~#~") && (inputSplit = input.split("~#~")).length > 1) {
                    input = inputSplit[0];
                    position = Integer.parseInt(inputSplit[1].trim());
                }
                output = QueryConversionUtility.doRemoveExtraSpace(input);
                output = DB2PreQueryChanges.doPreSchemaChanges(output);
                outputList.add(output);
            }
            catch (MigrationServiceException e) {
                this.printException(e, fileName, output, outputList, MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
                logger.error(e.getMessage());
            }
            catch (RuntimeException e) {
                this.printException(e, fileName, output, outputList, MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
            }
        }
        return outputList;
    }

    private void printException(Exception e, String fileName, String output, List<String> outputList, String message) {
        ErrorLoggerUtility.failedQryCnt();
        outputList.add(output);
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + message);
    }
}

