/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.factory;

import com.huawei.db.migration.db2.DB2BLogicMigrationService;
import com.huawei.db.migration.db2.DB2BulkMigrationService;
import com.huawei.db.migration.db2.DB2PostMigrationService;
import com.huawei.db.migration.db2.DB2QueryMigrationService;
import com.huawei.db.migration.db2.DB2SchemaMigrationService;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.interfaces.IDBMigrationService;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.interfaces.IPostMigrationService;
import com.huawei.db.migration.services.DB2MigrationService;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;

public class DB2MigrationFactory
implements MigrationAbstractFactory {
    @Override
    public IMigrationTaskService getMigrationTaskService(String taskName) throws MigrationServiceException {
        String task;
        IMigrationTaskService objMigStrategy = null;
        switch (task = QueryConversionUtility.toUpper(taskName)) {
            case "QUERY": {
                objMigStrategy = new DB2QueryMigrationService();
                break;
            }
            case "SCHEMA": {
                objMigStrategy = new DB2SchemaMigrationService();
                break;
            }
            case "BLOGIC": {
                objMigStrategy = new DB2BLogicMigrationService();
                break;
            }
            case "BULK": {
                objMigStrategy = new DB2BulkMigrationService();
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_004_025] " + MessageLoader.getMessage("DSC_ERR_004_025"));
            }
        }
        return objMigStrategy;
    }

    @Override
    public IDBMigrationService getDBMigrationService() throws MigrationServiceException {
        return new DB2MigrationService();
    }

    @Override
    public IPostMigrationService getPostMigrationService() {
        return new DB2PostMigrationService();
    }
}

