/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.factory;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.interfaces.IDBMigrationService;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.interfaces.IPostMigrationService;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.TeradataBulkMigrationService;
import com.huawei.db.migration.teradata.TeradataPostMigrationService;
import com.huawei.db.migration.teradata.TeradataQueryMigrationService;
import com.huawei.db.migration.teradata.TeradataSchemaMigrationService;
import com.huawei.db.migration.util.MessageLoader;

public class TeradataMigrationFactory
implements MigrationAbstractFactory {
    @Override
    public IMigrationTaskService getMigrationTaskService(String taskName) throws MigrationServiceException {
        IMigrationTaskService objMigStrategy = null;
        switch (taskName) {
            case "QUERY": {
                objMigStrategy = new TeradataQueryMigrationService();
                break;
            }
            case "SCHEMA": {
                objMigStrategy = new TeradataSchemaMigrationService();
                break;
            }
            case "BULK": {
                objMigStrategy = new TeradataBulkMigrationService();
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_004_025] " + MessageLoader.getMessage("DSC_ERR_004_025"));
            }
        }
        return objMigStrategy;
    }

    @Override
    public IDBMigrationService getDBMigrationService() {
        return new TeradataMigrationService();
    }

    @Override
    public IPostMigrationService getPostMigrationService() {
        return new TeradataPostMigrationService();
    }
}

