/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.filemerger;

import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.splitter.CustomFileWriter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileMerger
implements Runnable {
    private static final Logger logger = LogManager.getLogger(FileMerger.class);
    private String outPath;
    private String inputFile;
    private int fileCounter;
    private String scrPath;

    public FileMerger(String inputFile, String outPathStr, String scrPath, int fileCounter) {
        this.inputFile = inputFile;
        this.outPath = outPathStr;
        this.scrPath = scrPath;
        this.fileCounter = fileCounter;
    }

    @Override
    public void run() {
        String charsetName = new FileHandler().getEncodingFormat(new File(this.inputFile));
        File file = new File(this.inputFile);
        String fileName = file.getName();
        String inFile = this.inputFile.substring(this.scrPath.length());
        String fileToWrite = this.outPath + File.separator + inFile;
        boolean isAppend = false;
        for (int i = 0; i <= this.fileCounter; ++i) {
            String fileNameWOextn = fileName.substring(0, fileName.lastIndexOf("."));
            String extn = fileName.substring(fileName.lastIndexOf("."));
            String splitName = fileNameWOextn + "_sp_" + i + extn;
            String intermediatePath = inFile.substring(0, inFile.lastIndexOf(File.separator) + 1);
            String fileToRead = this.outPath + intermediatePath + File.separator + splitName;
            this.readAndWrite(fileToRead, fileToWrite, charsetName, isAppend);
            isAppend = true;
        }
    }

    private void readAndWrite(String fileToRead, String fileToWrite, String charsetName, boolean isAppend) {
        File file = new File(fileToRead);
        try {
            List lines = FileUtils.readLines((File)file, (String)charsetName);
            Path finalOutPath = Paths.get(fileToWrite, new String[0]).normalize();
            CustomFileWriter.writeContent(lines, finalOutPath, charsetName, isAppend);
            if (!file.delete()) {
                logger.error("Error while deleting split file :" + file.getName());
            }
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " IOException occurred. [DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044") + " " + "while reading the splitted file");
        }
    }
}

