/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.Gauss100Preprocessor;
import com.huawei.db.migration.oracle.OraclePostProcessing;
import com.huawei.db.migration.oracle.OraclePreQueryProcessing;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacer;
import com.huawei.db.migration.oracle.OracleQueryMigrationService;
import com.huawei.db.migration.oracle.OracleSchemaMigrationService;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleBulkHandler {
    private static boolean bulkHandlerFlag = false;
    private static final Logger logger = LogManager.getLogger(OracleBulkHandler.class);
    private static final Pattern CREATE_SYNONYM_PAT = Pattern.compile("(?i)(create.*(synonym)\\s+(.*)\\s+for\\s+(.*);)");
    private List<String> partitionInTableList = null;
    private Map<String, String> createType = null;
    private List<IQueryPatternsBO> queryPatterns = null;
    private List<IQuerySplitterPatternsBO> querySplitterPatterns = null;
    private List<IQueryPatternsBO> schemaPatterns = null;
    private List<IBulkSplitPatternsBO> bulkSplitPatterns = null;
    private String migrationType = null;
    private Pattern patternTable = Pattern.compile("(?i)(?<!\\w)CREATE(?!\\w).*?(?<!\\w)TABLE(?!\\w).*?(\\w*\\.?\\w+).*?;");
    private Pattern patternAlter = Pattern.compile("(?i).*alter.*(?<!\\w)table\\s+(\\w*\\.?\\w+)(?:(?!add).)*?(?:(?<!\\w)add(?!\\w))?\\s*\\(?((?:(?!add).)*?(?:(?<!\\w)primary\\s+key(?!\\w)|(?<!\\w)unique(?!\\w))\\s*\\(.*?\\))\\s*((?<!\\w)using\\s+index(?:\\s+tablespace\\s+\\w+\\s+)?)?");

    public static void setBulkHandlerFlag(boolean bulkHandlerFlag) {
        OracleBulkHandler.bulkHandlerFlag = bulkHandlerFlag;
    }

    public static boolean isBulkHandlerFlag() {
        return bulkHandlerFlag;
    }

    public List<String> doBulkProcess(List<String> inputList, String fileName, List<?> bulkPatterns) throws MigrationServiceException, InterruptedException {
        this.initializeJsonParser(bulkPatterns);
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        int position = 0;
        Iterator<String> iterator = inputList.iterator();
        while (iterator.hasNext()) {
            String input;
            String output = input = iterator.next();
            try {
                OracleBulkHandler.setBulkHandlerFlag(true);
                if (QueryConversionUtility.isGaus100()) {
                    output = Gauss100Preprocessor.doMigrateForGaussHundred(input);
                } else {
                    input = this.replaceInput(input);
                    ++position;
                    if (input.isEmpty()) continue;
                    output = input;
                    input = this.handleSpaceAndColon(input);
                    input = this.updatePkgName(input);
                    String unSupportedCheck = QueryConversionUtility.supportedValidator(input);
                    if (QueryConversionUtility.preQueryValidator(input) && unSupportedCheck.equals(input)) {
                        this.migrationType = QueryUtilityExt.findMigrationType(this.bulkSplitPatterns, this.migrationType, input);
                        output = this.doMigrateBulk(inputList, fileName, position, this.patternAlter, input);
                        if (QueryConversionUtility.containsCheck(this.migrationType, "schema")) {
                            output = this.migrateSchema(fileName, position, output, this.migrationType, this.patternAlter);
                        }
                        output = OracleQueryKeywordReplacer.doReplacePromptKeywordToEcho(output);
                    }
                }
            }
            catch (MigrationServiceException msg) {
                QueryUtilityExt.handleInterruptedException(fileName, msg);
                logger.error(ErrorLoggerUtility.getExceptionDetails(msg) + " " + msg.getMessage());
                this.handleRunTimeException(fileName, outputList, position, output);
            }
            outputList.add(output);
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private void initializeJsonParser(List<?> bulkPatterns) {
        GenericJSONParser objJSONParser = new GenericJSONParser();
        this.queryPatterns = objJSONParser.getJSONObject("oracle-query");
        this.querySplitterPatterns = objJSONParser.getJSONObject("oracle-query-splitter");
        this.schemaPatterns = objJSONParser.getJSONObject("oracle-schema");
        this.bulkSplitPatterns = bulkPatterns;
        if (!QueryConversionUtility.isGaus100()) {
            this.createType = new LinkedHashMap<String, String>(10);
            this.partitionInTableList = new ArrayList<String>(10);
        }
    }

    public String doMigrateBulk(List<String> inputList, String fileName, int position, Pattern patternAlter, String input) {
        String output = OraclePreQueryProcessing.doPreBulkChanges(input);
        this.doCheckConsWithPartition(inputList, position, output, this.patternTable, patternAlter);
        output = this.doCallMigrationTypeService(this.migrationType, output, fileName, this.queryPatterns, position);
        output = OraclePostProcessing.doPostBulkChanges(output);
        return output;
    }

    public String migrateSchema(String fileName, int position, String output, String migrationType, Pattern patternAlter) {
        output = this.doHandleConstraintName(output);
        output = this.doPrimaryKeyConstraint(position, output, patternAlter);
        output = this.doModOutput(output, migrationType, fileName);
        return output;
    }

    private String doHandleConstraintName(String input) {
        String output = input;
        String tableName = QueryConversionUtility.finderGroup(output, "(?i).*(?:create|alter)\\s+(?:TABLE|SEQUENCE|INDEX)\\s+((?:\\\"?\\w+\\\"?\\s+ON\\s+)?((\\w*|\\\"\\w*\\\")\\.)?(\\w+|\\\"[\\w\\W\\s]+?\\\")).*", 4);
        if (tableName != null) {
            String replacement = "CONSTRAINT " + tableName + "_MIG";
            output = QueryConversionUtility.replaceAll(output, "(?i)CONSTRAINT\\s+" + QueryConversionUtility.santizePattern(tableName), replacement);
        }
        return output;
    }

    private void doCheckConsWithPartition(List<String> outputList, int position, String output, Pattern patternTable, Pattern patternAlter) {
        Matcher matcherTable = null;
        if (QueryConversionUtility.isExactMatch(output, "CREATE") && (matcherTable = patternTable.matcher(output)).find()) {
            if (output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+(?:LIST|HASH|RANGE)(?!\\w).*")) {
                for (int pos = position + 1; pos <= outputList.size(); ++pos) {
                    String outputQury = outputList.get(pos - 1);
                    Matcher matcherAlter = patternAlter.matcher(outputQury);
                    if (!QueryConversionUtility.isExactMatch(outputQury, "alter") || !matcherAlter.find()) continue;
                    OracleMigrationService.addConstraintWithPartition(matcherTable.group(1));
                    break;
                }
            }
        }
    }

    private String handleSpaceAndColon(String input) {
        String inputQry = input;
        String tempInput = inputQry.replaceAll("(?i)#S#\\d+##?E#", "").trim();
        if (!tempInput.endsWith(";") && !tempInput.isEmpty()) {
            inputQry = inputQry + ";";
        }
        inputQry = QueryConversionUtility.doRemoveExtraSpace(inputQry);
        return inputQry;
    }

    private String replaceInput(String input) {
        String inputQry = input;
        if (QueryConversionUtility.containsCheck(inputQry, "EDITIONABLE")) {
            inputQry = inputQry.replaceFirst("(?i)(?<!\\w)EDITIONABLE(?!\\w)", "");
        }
        if ((inputQry = inputQry.trim()).startsWith("/") && inputQry.length() > 1) {
            inputQry = inputQry.substring(1);
        }
        if (inputQry.endsWith("/")) {
            inputQry = inputQry.substring(0, inputQry.length() - 1);
        }
        this.migrationType = "";
        return inputQry;
    }

    private String doModOutput(String outQry, String migrationType, String fileName) {
        Pattern pattern;
        Matcher matcher;
        String output = outQry;
        if (migrationType.equalsIgnoreCase("schema")) {
            output = this.doPartitionInIndex(output);
        }
        if (QueryConversionUtility.isExactMatch(output, "index") && (matcher = (pattern = Pattern.compile("(?i)(?<!\\w)CREATE(?!\\w).*?(?<!\\w)INDEX(?!\\w).*?\\w+.*?(?<!\\w)on\\s+(\\w*\\.?\\w+).*?(?<!\\w)LOCAL(?!\\w).*?;")).matcher(output)).find() && QueryConversionUtility.containsCheckCollec(OracleMigrationService.getConstraintWithPartition(), matcher.group(1)) && FeatureLoader.getStringProperty("uniqueConsForPartitonedTable").equalsIgnoreCase("comment_partition")) {
            output = output.replaceFirst("(?i)(?<!\\w)LOCAL(?!\\w)", "/*LOCAL*/");
        }
        output = this.doCreateType(output, fileName);
        return output;
    }

    private String updatePkgName(String input) {
        String inputQry = input;
        Pattern packageFinder = Pattern.compile("(?i).*(?:create|alter)\\s+(?:TABLE|SEQUENCE|INDEX)\\s+((?:\\\"?\\w+\\\"?\\s+ON\\s+)?((\\w*|\\\"\\w*\\\")\\.)?(\\w+|\\\"[\\w\\W\\s]+?\\\")).*");
        Matcher packageMatcher = packageFinder.matcher(inputQry);
        if (packageMatcher.find()) {
            String packageName = packageMatcher.group(1);
            String tableName = packageMatcher.group(4);
            if (tableName.contains("\"") && !QueryConversionUtility.containsCheck(tableName.trim(), " ") && tableName.matches("^\"[a-zA-Z].*") && tableName.matches("\"[a-zA-z0-9#$]+\"") && !FeatureLoaderExtended.getBooleanProperty("GaussSupForIndexname")) {
                String packageNameWithoutQuote = packageName.replaceAll("\"", "");
                inputQry = inputQry.replace(packageName, packageNameWithoutQuote);
                packageName = packageNameWithoutQuote;
            }
            if (FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
                String schemaName = null;
                if (packageName.contains(".")) {
                    schemaName = packageName.substring(0, packageName.indexOf(46) + 1);
                    schemaName = schemaName.replace(".", "\\.");
                }
            }
        }
        return inputQry;
    }

    private void handleRunTimeException(String fileName, List<String> outputList, int position, String output) {
        ErrorLoggerUtility.failedFileCnt(fileName);
        ErrorLoggerUtility.failedQryCnt();
        logger.error("[DSC_ERR_004_039] " + MessageLoader.getMessage("DSC_ERR_004_039") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
    }

    private String doCallMigrationTypeService(String migtype, String inputSql, String fileName, List<IQueryPatternsBO> queryPatterns, int position) throws MigrationServiceException {
        String output = inputSql;
        OracleQueryMigrationService objTaskService = null;
        OracleSchemaMigrationService schemaService = null;
        Map<String, String> queryMap = null;
        String input = null;
        int queryCount = 0;
        StringBuffer inputQuery = new StringBuffer(inputSql);
        inputQuery.append("~#~").append(position);
        switch (migtype) {
            case "Query": {
                objTaskService = new OracleQueryMigrationService();
                output = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, queryPatterns, this.querySplitterPatterns);
                break;
            }
            case "Schema": {
                output = this.migForSchema(fileName, this.querySplitterPatterns, this.schemaPatterns, inputQuery);
                break;
            }
            case "Schema with Query": {
                queryMap = new LinkedHashMap<String, String>(10);
                input = QueryConversionUtility.doGetSchemaQueries(inputQuery.toString(), queryMap, queryCount);
                schemaService = new OracleSchemaMigrationService();
                schemaService.setUniqueConsPartition(OracleMigrationService.getConstraintWithPartition());
                output = schemaService.handleMigrationTask(input, fileName, this.schemaPatterns, this.querySplitterPatterns);
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, queryPatterns, this.querySplitterPatterns, queryMap, new OracleQueryMigrationService());
                output = QueryConversionUtility.doReplaceFunctionVariables(output, queryMap, "##QUERY##");
                break;
            }
            case "Comments": {
                output = this.migForComments(inputQuery);
                break;
            }
        }
        output = this.getSplitOutput(output);
        return output;
    }

    private String migForSchema(String fileName, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IQueryPatternsBO> schemaPatterns, StringBuffer inputQuery) {
        OracleSchemaMigrationService schemaService = new OracleSchemaMigrationService();
        schemaService.setUniqueConsPartition(OracleMigrationService.getConstraintWithPartition());
        String output = schemaService.handleMigrationTask(inputQuery.toString(), fileName, schemaPatterns, querySplitterPatterns);
        return output;
    }

    private String migForComments(StringBuffer inputQuery) {
        Map<String, String> globalMap = OracleMigrationService.getGlobalTempMap();
        String output = inputQuery.toString();
        output = QueryConversionUtility.doRplFromMap(output, globalMap);
        return output;
    }

    private String getSplitOutput(String input) {
        String output = input;
        if ((output = QueryConversionUtility.canonicalizeString(output)).contains("~#~")) {
            output = output.split("~#~")[0];
        }
        return output;
    }

    private String doPrimaryKeyConstraint(int position, String output, Pattern patternAlter) {
        String outputQry = output;
        String schemaTableNme = null;
        Matcher matcherTable = null;
        if (QueryConversionUtility.isExactMatch(outputQry, "alter") && (matcherTable = patternAlter.matcher(outputQry)).find()) {
            Set<String> primaryKeySet;
            schemaTableNme = QueryConversionUtility.toLower(matcherTable.group(1).trim());
            String primaryKey = matcherTable.group(2);
            String primaryKeyIndex = matcherTable.group(3);
            if (primaryKeyIndex == null) {
                primaryKeyIndex = "";
            }
            if ((primaryKeySet = OracleMigrationService.getPrimaryKeyAlter(schemaTableNme)) == null) {
                primaryKeySet = new LinkedHashSet<String>(2);
            } else if (!QueryConversionUtility.containsCheck(primaryKey, "unique")) {
                String[] primaryKeyArray = primaryKeySet.toArray(new String[0]);
                if (!primaryKeyArray[0].isEmpty()) {
                    primaryKey = primaryKeyArray[0] + "," + primaryKey;
                }
                if (!primaryKeyArray[1].isEmpty()) {
                    primaryKeyIndex = primaryKeyArray[1] + "," + primaryKeyIndex;
                }
                primaryKeySet.clear();
            }
            primaryKeySet.add(primaryKey);
            primaryKeySet.add(primaryKeyIndex);
            primaryKeySet.add("false");
            OracleMigrationService.addPrimaryKeyAlter(schemaTableNme, primaryKeySet);
        }
        return outputQry;
    }

    private String doPartitionInIndex(String input) {
        Pattern pattern;
        Matcher matcher;
        String output = input;
        StringBuffer outbuff = new StringBuffer();
        if (QueryConversionUtility.isExactMatch(input, "table") && QueryConversionUtility.containsCheck(input, "range") && QueryConversionUtility.containsCheck(input, "partition")) {
            Pattern pattern2 = Pattern.compile("(?i)(?<!\\w)CREATE(?!\\w).*?(?<!\\w)TABLE(?!\\w).*?((?:\\w*\\.)?(\\w+)).*?partition\\s+by\\s+range(.*?);");
            Matcher matcher2 = pattern2.matcher(input);
            if (matcher2.find()) {
                this.partitionInTableList.add(QueryConversionUtility.toUpper(matcher2.group(1).trim()));
            }
        } else if (QueryConversionUtility.isExactMatch(input, "index") && (matcher = (pattern = Pattern.compile("(?i)(?<!\\w)CREATE(?!\\w).*?(?<!\\w)INDEX(?!\\w).*?\\w+.*?(?<!\\w)on\\s+(\\w*\\.?\\w+).*?;")).matcher(input)).find()) {
            String tableNme = QueryConversionUtility.toUpper(matcher.group(1).trim());
            if (this.partitionInTableList != null && this.partitionInTableList.contains(tableNme)) {
                output = this.doGetPartitionIndex(input);
            } else if (QueryConversionUtility.isExactMatch(input, "global")) {
                String patternStr = "(?i)((?<!\\w)global(?!\\w))";
                int idx = QueryConversionUtility.getStartIndex(input, patternStr, 1);
                outbuff.append(input.substring(0, idx)).append(" ").append(";");
                output = outbuff.toString();
            } else if (QueryConversionUtility.isExactMatch(input, "local")) {
                String patternStr = "(?i)((?<!\\w)local(?!\\w))";
                int idx = QueryConversionUtility.getStartIndex(input, patternStr, 1);
                outbuff.append(input.substring(0, idx)).append(" ").append(";");
                output = outbuff.toString();
            }
        }
        return output;
    }

    private String doGetPartitionIndex(String input) {
        StringBuffer output = new StringBuffer();
        if (QueryConversionUtility.isExactMatch(input, "global\\s*\\(")) {
            String sessionRpl = FeatureLoader.getStringProperty("globalTempTable");
            String defaultRpl = "LOCAL";
            if (sessionRpl.equalsIgnoreCase("global")) {
                defaultRpl = "global";
            }
            String patternStr = "(?i)((?<!\\w)global\\s*\\((?!\\w))";
            int idx = QueryConversionUtility.getStartIndex(input, patternStr, 1);
            String globalString = QueryConversionUtility.doGetReplaceString(input.substring(idx));
            String globalBracketStr = globalString.substring(globalString.indexOf(40));
            output.append(input.substring(0, idx)).append(" ").append(defaultRpl).append(globalBracketStr).append(";");
        } else if (QueryConversionUtility.isExactMatch(input, "global")) {
            String sessionRpl = FeatureLoader.getStringProperty("globalTempTable");
            String defaultRpl = "LOCAL";
            if (sessionRpl.equalsIgnoreCase("global")) {
                defaultRpl = "global";
            }
            String patternStr = "(?i)((?<!\\w)global(?!\\w))";
            int idx = QueryConversionUtility.getStartIndex(input, patternStr, 1);
            output.append(input.substring(0, idx)).append(" ").append(defaultRpl).append(";");
        } else if (QueryConversionUtility.isExactMatch(input, "local\\s*\\(")) {
            String patternStr = "(?i)((?<!\\w)local\\s*\\((?!\\w))";
            int idx = QueryConversionUtility.getStartIndex(input, patternStr, 1);
            String localString = QueryConversionUtility.doGetReplaceString(input.substring(idx));
            output.append(input.substring(0, idx)).append(" ").append(localString).append(";");
        } else if (QueryConversionUtility.isExactMatch(input, "local")) {
            String patternStr = "(?i)((?<!\\w)local(?!\\w))";
            int idx = QueryConversionUtility.getStartIndex(input, patternStr, 1);
            output.append(input.substring(0, idx)).append(" ").append("local").append(";");
        } else {
            int idx = input.indexOf(59);
            output.append(input.substring(0, idx)).append(" ").append("local").append(";");
        }
        return output.toString();
    }

    private String doCreateType(String input, String fileName) {
        String output = input;
        if (input.matches("(?i).*(?<!\\w)(?:I|A)S\\s+OBJECT(?!\\w).*")) {
            if (!input.matches(".*MEMBER\\s+FUNCTION.*")) {
                Pattern pattern = Pattern.compile("(?i).*CREATE\\s+.*?(?<!\\w)TYPE\\s+.*?((?:\"?\\w*\\.)?(\"?\\w+\"?)).*?(?:I|A)S\\s+OBJECT\\s*\\((.*?)\\)\\s*;");
                Matcher matcher = pattern.matcher(input);
                if (matcher.find()) {
                    String tblNme = matcher.group(1).trim();
                    String cols = matcher.group(3).trim();
                    this.createType.put(QueryConversionUtility.toUpper(tblNme), cols);
                    if (QueryConversionUtility.containsCheck(output, "OBJECT")) {
                        if ((output = output.matches("(?i).*(?<!\\w)IS\\s+OBJECT(?!\\w).*") ? output.replaceFirst("(?i)(?<!\\w)IS\\s+OBJECT(?!\\w)", "AS") : output.replaceFirst("(?i)OBJECT", "")).matches("(?i).*create\\s+or\\s+replace\\s+.*")) {
                            output = output.replaceFirst("(?i)or\\s+replace", "");
                        }
                        OracleUtility oracleUtil = new OracleUtility();
                        output = oracleUtil.doRplPercentageType(output, "");
                        if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "VARRAY")) {
                            OracleMigrationService.addCreateTypeMap(QueryConversionUtility.toUpper(tblNme + "_" + "record"), "RECORD_DATATYPE");
                        }
                    } else {
                        output = "";
                    }
                }
            } else if (input.matches(".*PRAGMA\\s+RESTRICT_REFERENCES.*")) {
                logger.info("MEMBER FUNCTION or PRAGMA RESTRICT_REFERENCES is not supported by Gauss, so it not migrated: {}", (Object)fileName);
            } else {
                logger.info("MEMBER FUNCTION is not supported by Gauss, so it not migrated: {}", (Object)fileName);
            }
        } else if (input.matches("(?i).*(?<!\\w)(?:IS|AS)\\s+(?:TABLE|VARRAY\\s*\\(\\s*\\d+\\s*\\))\\s+OF(?!\\w).*")) {
            output = this.handleCreateTableOrVarray(input, output);
        }
        output = this.checkSynonyms(output);
        return output;
    }

    private String checkSynonyms(String input) {
        String output = input;
        boolean synonymSupport = FeatureLoader.getBooleanProperty("GaussSupForSynonym");
        if (QueryConversionUtility.containsCheck(output, "SYNONYM")) {
            output = synonymSupport ? output.replaceAll("(?i)(?<!\\w)(PUBLIC|NOEDITIONABLE|EDITIONABLE)(?!\\w)", "") : this.handleSynonymKeyword(output);
        }
        return output;
    }

    private String handleCreateTableOrVarray(String input, String output) {
        String outputQry = output;
        Pattern pattern = Pattern.compile("(?i)(.*)CREATE\\s+.*?(?<!\\w)TYPE\\s+.*?(\"?\\w*\"?\\.?\"?\\w+\"?).*?(?:IS|AS)\\s+(?:TABLE|VARRAY\\s*\\(\\s*\\d+\\s*\\))\\s+OF\\s+(.*?)\\/?;(.*)");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            outputQry = this.migrateVarrayCreateTable(output, outputQry, matcher);
        }
        return outputQry;
    }

    private String migrateVarrayCreateTable(String output, String outputQry, Matcher matcher) {
        String schemaTblNme = matcher.group(2).trim();
        String dataTypeNme = matcher.group(3).trim();
        String colTypeValue = null;
        String schema = null;
        String tblNme = null;
        colTypeValue = this.getColTypeValue(dataTypeNme);
        ColumnSplitter splitter = new ColumnSplitter();
        String columns = this.getCols(colTypeValue, splitter);
        if (schemaTblNme.contains(".")) {
            int dotIdx = schemaTblNme.lastIndexOf(46);
            schema = schemaTblNme.substring(0, dotIdx);
            tblNme = schemaTblNme.substring(dotIdx + 1);
        } else {
            tblNme = schemaTblNme;
        }
        tblNme = this.rplQuoteOfTblNme(tblNme);
        if (!QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "none")) {
            if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "VARRAY")) {
                this.addTblNmeToMap(schemaTblNme, dataTypeNme, tblNme);
                outputQry = output.substring(0, matcher.end(1)) + "/*" + output.substring(matcher.end(1), matcher.start(4)) + "*/" + output.substring(matcher.start(4));
            } else {
                OracleMigrationService.addCreateTypeMap(tblNme, columns);
                StringBuffer createTypeBuff = new StringBuffer();
                createTypeBuff.append(matcher.group(1));
                createTypeBuff.append("CREATE TABLE ");
                if (schema == null) {
                    createTypeBuff.append("MIG_").append(tblNme);
                } else {
                    this.typeWithSchema(schema, tblNme, columns, createTypeBuff);
                }
                outputQry = this.getOutQry(matcher, colTypeValue, createTypeBuff);
            }
        }
        return outputQry;
    }

    private String getCols(String colTypeValue, ColumnSplitter splitter) {
        List<String> colsLst = splitter.doGetAllColumns(colTypeValue);
        StringBuffer columnsBuff = new StringBuffer();
        this.appendCols(colsLst, columnsBuff);
        int len = columnsBuff.length();
        columnsBuff.deleteCharAt(len - 1);
        String columns = columnsBuff.toString();
        return columns;
    }

    private String getOutQry(Matcher matcher, String colTypeValue, StringBuffer createTypeBuff) {
        createTypeBuff.append("(").append(colTypeValue).append(")");
        createTypeBuff.append(";");
        createTypeBuff.append(matcher.group(4));
        String outputQry = createTypeBuff.toString();
        return outputQry;
    }

    private void typeWithSchema(String schInput, String tblNme, String columns, StringBuffer createTypeBuff) {
        String schema = schInput;
        schema = QueryConversionUtility.toUpper(schema);
        OracleMigrationService.addCreateTypeMap(schema + "." + tblNme, columns);
        createTypeBuff.append(schema).append(".").append("MIG_").append(tblNme);
    }

    private void addTblNmeToMap(String schemaTblNme, String dataTypeNme, String tblNme) {
        OracleMigrationService.addCreateTypeMap(schemaTblNme + "_VARRAY", dataTypeNme);
        OracleMigrationService.addCreateTypeMap(tblNme + "_VARRAY", dataTypeNme);
    }

    private String rplQuoteOfTblNme(String table) {
        String tblNme = table;
        tblNme = (tblNme = QueryConversionUtility.toUpper(tblNme)).contains("\"") ? tblNme.replace("\"", "") : tblNme;
        return tblNme;
    }

    private void appendCols(List<String> colsLst, StringBuffer columnsBuff) {
        int idx = 0;
        for (String col : colsLst) {
            idx = col.indexOf(32);
            columnsBuff.append(col.substring(0, idx));
            columnsBuff.append(",");
        }
    }

    private String getColTypeValue(String dataTypeNme) {
        String colTypeValue = null;
        colTypeValue = this.createType != null && this.createType.containsKey(QueryConversionUtility.toUpper(dataTypeNme)) ? this.createType.get(QueryConversionUtility.toUpper(dataTypeNme)) : "typ_col " + dataTypeNme;
        return colTypeValue;
    }

    private String handleSynonymKeyword(String output) {
        String outputQry = output;
        Matcher matcher = CREATE_SYNONYM_PAT.matcher(outputQry);
        String synonym = null;
        String tableName = null;
        String cmntQry = null;
        if (matcher.find()) {
            cmntQry = matcher.group(1);
            synonym = matcher.group(3);
            tableName = matcher.group(4);
            OracleMigrationService.addCreateTypeMap(synonym + "_SYNONYM", tableName);
            outputQry = outputQry.replace(cmntQry, "/*" + cmntQry + "*/");
        }
        return outputQry;
    }
}

