/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OraclePatternHandler;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleConnectBy {
    private static final Pattern RELATION_OPERATOR_PAT = Pattern.compile("(?i)(?!#|\\()(.*?)(?<!\\w)(\\!|=|<|>|IS|IN|BETWEEN|LIKE)(.*)");
    private static final Pattern COL_PAT = Pattern.compile("(?i)((\\w+\\.)?(\\w+))");
    private static final Pattern OR_PAT = Pattern.compile("(?i)(?<!('|\"))\\s*(\\w+)(\\.\\w+)?(?!\\s*(\\(|'|\")|\\w)");
    private Map<String, String> subQueryConnectByMap = new TreeMap<String, String>();
    private StringBuffer sb;
    private StringBuffer connectByOn;
    private List<String> fullColList;
    private String joinAlias;
    private String tblAlias;
    private String[] tablNameSplit;
    private String tblNm;
    private boolean subQueryFlag;
    private boolean colLevelFlag;
    private boolean multiTblFlag;
    private StringBuffer multiTblWhereClause = new StringBuffer();

    public String doHandleConnectBy(String inputQuery, Map<String, String> subQueryTrackMap) throws MigrationServiceException {
        String outputQry = inputQuery;
        this.multiTblFlag = false;
        String connectByStr = OracleConnectBy.doGetConnectByString(outputQry);
        String startWithStr = "";
        if (connectByStr != null) {
            String tableName = QueryConversionUtility.doGetTableName(outputQry);
            List<String> columnList = QueryConversionUtility.doGetColumnNameList(outputQry);
            startWithStr = OracleConnectBy.doGetStartWithString(outputQry);
            if (startWithStr != null) {
                outputQry = outputQry.replace(startWithStr, "");
            }
            outputQry = outputQry.replace(connectByStr, "");
            connectByStr = QueryConversionUtility.doReplaceExactStr("nocycle", "", connectByStr);
            if (QueryConversionUtility.containsCheck(tableName, ",") || QueryConversionUtility.containsCheck(tableName, "JOIN")) {
                this.multiTblFlag = true;
                HashSet<String> aliasSet = new HashSet<String>(10);
                if (startWithStr != null) {
                    OracleConnectBy.getTableAliasName(startWithStr, aliasSet);
                }
                OracleConnectBy.getTableAliasName(connectByStr, aliasSet);
                if (aliasSet.size() == 1 && !QueryConversionUtility.containsCheck(tableName, "JOIN")) {
                    OraclePatternHandler oraclePatternHandler = new OraclePatternHandler();
                    outputQry = oraclePatternHandler.doCnsrtConnectBySubQry(outputQry, tableName, columnList, startWithStr, connectByStr, aliasSet, subQueryTrackMap);
                    return outputQry;
                }
                if (QueryConversionUtility.containsCheck(tableName, "JOIN")) {
                    tableName = this.doHandleInnerJoin(tableName);
                }
            }
            this.tblAlias = "";
            this.tablNameSplit = QueryConversionUtility.replace(tableName, "(?i)#S#\\d+#E#", "", false).trim().split(" ");
            if (this.tablNameSplit.length > 1 && !this.multiTblFlag) {
                this.tblAlias = this.tablNameSplit[this.tablNameSplit.length - 1];
            }
            List<String> whereClauseList = this.doGetWhereClauseList(outputQry, this.tblAlias, tableName);
            List<String> orderByClauseList = QueryConversionUtility.doGetOrderByClauseList(outputQry);
            whereClauseList.addAll(orderByClauseList);
            outputQry = this.doConstructConnectByQuery(inputQuery, outputQry, tableName, columnList, startWithStr, connectByStr, whereClauseList, subQueryTrackMap);
        }
        return outputQry;
    }

    private String doHandleInnerJoin(String tblName) {
        String tableName = tblName;
        if (QueryConversionUtility.containsCheck(tableName, "INNER JOIN")) {
            this.tblNm = tableName;
            Pattern pattern = Pattern.compile("(?i)(?<!\\w)INNER\\s+JOIN.*?(ON.*?)((INNER|LEFT|RIGHT|FULL)?\\s+JOIN|START\\s+WITH|CONNECT\\sBY|WHERE|GROUP\\s+BY|ORDER\\s+BY|LIMIT|;|$)");
            Matcher matcher = pattern.matcher(tableName);
            StringBuffer strBuf = new StringBuffer();
            StringBuffer joinClause = new StringBuffer();
            int tempIndex = 0;
            while (matcher.find()) {
                String grp = matcher.group(1);
                joinClause.append(grp);
                int startIndex = matcher.start(1);
                int endIndex = matcher.end(1);
                strBuf.append(tableName.substring(tempIndex, startIndex));
                tempIndex = endIndex;
            }
            strBuf.append(tableName.substring(tempIndex));
            tableName = strBuf.toString();
            tableName = QueryConversionUtility.replaceAll(tableName, "(?i)(?<!\\w)INNER\\s+JOIN(?!\\w)", ",");
            this.multiTblWhereClause.append(QueryConversionUtility.replace(joinClause.toString(), "(?i)(?<!\\w)ON(?!\\w)", "", true));
        }
        return tableName;
    }

    public List<String> doGetWhereClauseList(String inputQry, String tabAlias, String tableName) {
        String input = inputQry;
        ArrayList<String> whereList = new ArrayList<String>(10);
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String group = this.getGroupValue(input = QueryConversionUtility.getSingleQuoteMap(input, quoteMap), quoteMap);
        if (group != null) {
            String[] whereArray = group.split("(?i)(AND|OR)");
            for (int iIndex = 0; iIndex < whereArray.length; ++iIndex) {
                String arrElement = whereArray[iIndex];
                if (QueryConversionUtility.containsCheck(arrElement, "between")) {
                    arrElement = arrElement + " and " + whereArray[iIndex + 1];
                    ++iIndex;
                }
                arrElement = QueryConversionUtility.replaceAll(arrElement, "(?i)(?<!\\w)(AND|OR|NOT)(?!\\w)|#S#\\d+#E#", "").trim();
                if (this.multiTblFlag) {
                    String[] tablNameArr;
                    HashSet<String> tblAliasSet = new HashSet<String>(10);
                    for (String tab : tablNameArr = tableName.trim().split(",")) {
                        String[] tablAliasSplit = tab.trim().split(" ");
                        if (tablAliasSplit.length <= 1) continue;
                        String alias = tablAliasSplit[tablAliasSplit.length - 1];
                        tblAliasSet.add(alias);
                    }
                    Matcher matcher = RELATION_OPERATOR_PAT.matcher(arrElement);
                    if (matcher.find()) {
                        arrElement = this.handleMatch(arrElement, tblAliasSet, matcher);
                    }
                } else {
                    arrElement = QueryConversionUtility.finderGroup(arrElement, "(?i)(?!#|\\()(.*?)(?<!\\w)(\\!|=|<|>|IS|IN|BETWEEN|LIKE)", 1);
                }
                if (arrElement == null || arrElement.trim().matches("(?i).*(?<!\\w)(SYSDATE|CURRENT_DATE|TIMESTAMP|LOCALTIMESTAMP|NEXTVAL|CURRVAL|CURRENT_TIMESTAMP|DBTIMEZONE|SESSIONTIMEZONE|SYSTIMESTAMP)(?!\\w).*")) continue;
                if (QueryConversionUtility.toUpper(arrElement = arrElement.trim()).startsWith("CASE ")) {
                    List<String> varList = QueryConversionUtility.doGetVarsInCaseStmt(arrElement);
                    whereList.addAll(varList);
                    continue;
                }
                whereList.add(arrElement);
            }
        }
        return whereList;
    }

    private String handleMatch(String arrayElmnt, Set<String> tblAliasSet, Matcher matcher) {
        String arrElement = arrayElmnt;
        String leftGrp = matcher.group(1);
        String rightGrp = matcher.group(3);
        HashSet<String> aliasSet = new HashSet<String>(10);
        OracleConnectBy.getTableAliasName(leftGrp, aliasSet);
        if (aliasSet.size() == 1) {
            Optional value = aliasSet.stream().findFirst();
            leftGrp = value.isPresent() ? (String)value.get() : "";
            aliasSet = new HashSet(10);
            OracleConnectBy.getTableAliasName(rightGrp, aliasSet);
            if (aliasSet.size() == 1) {
                Optional value1 = aliasSet.stream().findFirst();
                String string = rightGrp = value1.isPresent() ? (String)value1.get() : "";
                if (!QueryConversionUtility.equalCheck(leftGrp, rightGrp) && tblAliasSet.contains(leftGrp) && tblAliasSet.contains(rightGrp)) {
                    if (this.multiTblWhereClause.length() != 0) {
                        this.multiTblWhereClause.append(" and ");
                    }
                    this.multiTblWhereClause.append(arrElement);
                }
            }
        }
        arrElement = matcher.group(1);
        return arrElement;
    }

    private String getGroupValue(String input, Map<String, String> quoteMap) {
        Pattern fromPattern = Pattern.compile("(?i)(?<!\\w)WHERE\\s+(((AND|OR)\\s+)?.*?(?:!|<|>|=|NOT\\s+|IN|IS)+\\s.*?)(?:(UNION|START\\s+WITH|CONNECT\\s+BY|;|ORDER\\s+(SIBLINGS\\s+)?BY|GROUP\\s+BY|HAVING|LIMIT|$))");
        Matcher fromMatch = fromPattern.matcher(input);
        String group = null;
        if (fromMatch.find()) {
            group = fromMatch.group(1);
            group = QueryConversionUtility.getRplFromMap(group, quoteMap, "(##QUOTE##\\d+#)");
        }
        return group;
    }

    private static String doGetStartWithString(String input) {
        String startWith = null;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)(START\\s+WITH\\s+((AND|OR)\\s+)?.*?(?:==|<>|!=|<=|>=|=|IN|IS|NOT\\s+IN)\\s*.*?)((UNION|WHERE|CONNECT\\s+BY|ORDER\\s+(SIBLINGS\\s+)?BY|GROUP\\s+BY|HAVING|LIMIT|;|$))");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            startWith = matcher.group(1);
        }
        return startWith;
    }

    private static String doGetConnectByString(String input) {
        String connectByStr = null;
        Pattern fromPattern = Pattern.compile("(?i)(?<!\\w)(CONNECT\\s+BY\\s+.*?(?:=|<|>|!|=|NOT\\sIN|IN|IS)+\\s*.*?)((UNION|WHERE|START\\s+WITH|ORDER\\s+(SIBLINGS\\s+)?BY|GROUP\\s+BY|HAVING|LIMIT|;|$))");
        Matcher fromMatch = fromPattern.matcher(input);
        if (fromMatch.find()) {
            connectByStr = fromMatch.group(1).trim();
        }
        return connectByStr;
    }

    private String doConstructConnectByQuery(String inputQuery, String outputQryStr, String tblNme, List<String> columnListNames, String startWithStr, String connectByString, List<String> whereClauseList, Map<String, String> subQueryTrackMap) {
        String outputQry = outputQryStr;
        this.subQueryConnectByMap = new TreeMap<String, String>();
        this.sb = new StringBuffer();
        this.connectByOn = new StringBuffer();
        this.fullColList = new ArrayList<String>(10);
        this.joinAlias = "mig_ora_cte_join_alias";
        this.tblAlias = "";
        String tableName = tblNme;
        String tblName = QueryConversionUtility.replaceAll(tableName, "(?i)#S#\\d+#E#", "").trim();
        this.tablNameSplit = tblName.trim().split(" ");
        this.subQueryFlag = false;
        this.colLevelFlag = false;
        this.tblNm = tableName;
        if (!this.multiTblFlag) {
            tableName = this.getSubQryAlias(tableName);
        }
        List<String> columnList = columnListNames;
        columnList = this.getUpdQryList(connectByString, whereClauseList, subQueryTrackMap, columnList);
        StringBuffer colList1SB = new StringBuffer();
        List<String> columnAliasList = QueryConversionUtility.doGetAliasList(this.fullColList);
        outputQry = this.replaceWhereClauseAliasName(outputQry);
        StringBuffer colList2SB = new StringBuffer();
        columnAliasList = this.doConstructColumns(colList1SB, colList2SB);
        if (!this.colLevelFlag) {
            colList1SB.append(", 1 AS LEVEL");
            colList2SB.append(", ").append("mig_ora_cte_tab_alias").append(".LEVEL + 1 AS LEVEL");
        }
        String tableComment = QueryConversionUtility.doGetPatternMatch("(?i)#S#\\d+#E#", this.tblNm);
        this.doConstructInnerQuery(tableName, startWithStr, colList1SB.toString(), colList2SB.toString(), tableComment);
        StringBuffer outBuf = this.doConstructOuterQuery(outputQry, columnList, columnAliasList);
        return outBuf.toString();
    }

    private List<String> getUpdQryList(String connectByString, List<String> whereClauseList, Map<String, String> subQueryTrackMap, List<String> columnList) {
        if (columnList.size() == 1 && QueryConversionUtility.containsCheck(columnList.get(0), "*") && this.tablNameSplit.length > 0 && this.tablNameSplit[0].matches("##SUBQUERY##\\d+__")) {
            columnList = this.doGetSubQryColList(this.tablNameSplit[0], subQueryTrackMap);
        }
        String connectByStr = connectByString;
        connectByStr = QueryConversionUtility.replaceAll(connectByStr, "(?i)CONNECT\\s+BY", "");
        this.addPriorColumnToWhereList(connectByStr, whereClauseList);
        this.sb.append("WITH RECURSIVE ").append("migora_cte").append(" AS ( SELECT ");
        this.removeDistinctAliasInColumn(columnList);
        this.doGetFullColumnList(whereClauseList);
        String key = null;
        for (String col : this.fullColList) {
            if (!col.equalsIgnoreCase("level")) continue;
            key = col;
            this.colLevelFlag = false;
            break;
        }
        if (key != null) {
            this.fullColList.remove(key);
        }
        return columnList;
    }

    private void doGetFullColumnList(List<String> whereClauseList) {
        List<String> columnAliasList = null;
        String str = null;
        if (whereClauseList != null) {
            for (int jIndex = 0; jIndex < whereClauseList.size(); ++jIndex) {
                str = whereClauseList.get(jIndex).trim();
                str = QueryConversionUtility.doSplitcolNameDotALias(str, this.tblAlias);
                boolean flag = false;
                columnAliasList = new ArrayList<String>(10);
                columnAliasList.addAll(this.fullColList);
                columnAliasList = QueryConversionUtility.doGetAliasList(columnAliasList);
                for (int i = 0; i < this.fullColList.size(); ++i) {
                    String listStr = this.fullColList.get(i);
                    if (!QueryConversionUtility.containsCheck(listStr = QueryConversionUtility.doSplitcolNameDotALias(listStr, this.tblAlias), str) || !QueryConversionUtility.equalCheck(columnAliasList.get(i), str) && !QueryConversionUtility.toLower(listStr).startsWith(QueryConversionUtility.toLower(str))) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                this.fullColList.add(whereClauseList.get(jIndex).trim());
            }
        }
    }

    private String replaceWhereClauseAliasName(String outputQry) {
        String whereClause;
        String outputQuery = outputQry;
        if (this.multiTblFlag) {
            if (this.multiTblWhereClause.length() != 0) {
                outputQuery = QueryConversionUtility.replaceAll(outputQuery, "(?i)(WHERE|AND|ON)\\s+" + QueryConversionUtility.santizePattern(this.multiTblWhereClause.toString().trim()), "");
            }
            if (QueryConversionUtility.containsCheck(outputQuery, "JOIN")) {
                outputQuery = QueryConversionUtility.replaceAll(outputQuery, "(?i)((INNER|LEFT|RIGHT|FULL)?\\s+JOIN)", ",");
            }
        }
        if ((whereClause = QueryConversionUtility.finderGroup(outputQuery, "(?i)(?<!\\w)WHERE\\s+(((AND|OR)\\s+)?.*?(?:!|<|>|=|NOT\\s+|IN|IS)+\\s.*?)(?:(UNION|START\\s+WITH|CONNECT\\s+BY|;|ORDER\\s+(SIBLINGS\\s+)?BY|GROUP\\s+BY|HAVING|LIMIT|$))", 0)) != null) {
            String dupString = whereClause;
            for (String columnString : this.fullColList) {
                if (!columnString.matches("(?i).*(?<!\\w)columnalias\\d+(?!\\w).*")) continue;
                String aliasColumn = QueryConversionUtility.doGetPatternMatch("(?i)(?<!\\w)columnalias\\d+(?!\\w)", columnString);
                columnString = QueryConversionUtility.replaceAll(columnString, aliasColumn, "").trim();
                dupString = QueryConversionUtility.replaceAll(dupString, "(?i)" + QueryConversionUtility.santizePattern(columnString) + "\\s*=", aliasColumn + " " + "=");
            }
            if (this.multiTblFlag) {
                dupString = dupString.replaceAll("(?i)\\w+\\.", "");
            }
            outputQuery = outputQuery.replace(whereClause, dupString);
        }
        return outputQuery;
    }

    private StringBuffer doConstructOuterQuery(String outputQry, List<String> columnList, List<String> columnAliasList) {
        Pattern pattern = Pattern.compile("(?i)(.*?(?<!\\w)select(?!\\w).*?(?<!\\w)from)(?!\\w)(.*?)(((ORDER\\s+(SIBLINGS\\s+)?BY).*?)?(;|$))");
        Matcher matcher = pattern.matcher(outputQry);
        StringBuffer outBuf = new StringBuffer();
        if (matcher.find()) {
            StringBuffer colAliasList = new StringBuffer();
            String group = this.getColAlias(columnList, columnAliasList, matcher, colAliasList);
            colAliasList.append("FROM ");
            this.sb.append(colAliasList);
            String grp = this.getOutBufAndGroup(matcher, outBuf, colAliasList, group);
            this.handleOrderBy(outBuf, grp);
        } else {
            outBuf.append(this.sb.toString());
        }
        return outBuf;
    }

    private String getOutBufAndGroup(Matcher matcher, StringBuffer outBuf, StringBuffer colAliasList, String group) {
        if (this.joinAlias.equalsIgnoreCase("mig_ora_cte_join_alias")) {
            this.sb.append(QueryConversionUtility.replaceAll(group, this.tblNm, " migora_cte "));
        } else {
            this.sb.append(QueryConversionUtility.replaceAll(group, this.tblNm, " migora_cte " + this.joinAlias + " "));
        }
        if (this.subQueryFlag) {
            outBuf.append("Select * FROM ( ");
            if (!this.subQueryConnectByMap.isEmpty()) {
                for (Map.Entry<String, String> entry : this.subQueryConnectByMap.entrySet()) {
                    outBuf.append("WITH ").append(entry.getKey()).append(" AS ").append(entry.getValue()).append(" ");
                }
            }
            outBuf.append(QueryConversionUtility.replaceAll(colAliasList.toString(), "DISTINCT", "")).append(" (" + this.sb.toString()).append(") ");
            outBuf.append(") ");
        } else {
            outBuf.append(this.sb.toString());
        }
        String grp = matcher.group(3);
        if (!this.tblAlias.equalsIgnoreCase(this.joinAlias)) {
            grp = QueryConversionUtility.replaceAll(grp, "(?i)" + QueryConversionUtility.santizePattern(this.tblAlias) + "\\.", "");
        }
        return grp;
    }

    private String getColAlias(List<String> columnList, List<String> columnAliasList, Matcher matcher, StringBuffer colAliasList) {
        colAliasList.append("SELECT ");
        String group = matcher.group(2);
        for (int iIndex = 0; iIndex < columnList.size(); ++iIndex) {
            if (columnList.get(iIndex).startsWith("DISTINCT")) {
                colAliasList.append("DISTINCT").append(" ");
            } else if ("LEVEL".equalsIgnoreCase(columnList.get(iIndex))) {
                columnAliasList.add(iIndex, "LEVEL");
            }
            colAliasList.append(QueryConversionUtility.replaceAll(columnAliasList.get(iIndex), "(?i)(?<!\\w)\\w+\\.", "")).append(" ");
            if (iIndex + 1 >= columnList.size()) continue;
            colAliasList.append(",");
        }
        return group;
    }

    private void handleOrderBy(StringBuffer outBuf, String grp) {
        if (!QueryConversionUtility.containsCheck(grp, "ORDER BY") && !QueryConversionUtility.containsCheck(grp, "ORDER SIBLINGS BY")) {
            if (outBuf.lastIndexOf(";") != -1) {
                outBuf.deleteCharAt(outBuf.lastIndexOf(";"));
                outBuf.append(" ORDER BY LEVEL;");
            } else {
                outBuf.append(" ORDER BY LEVEL");
                outBuf.append(grp);
            }
        } else {
            outBuf.append(grp);
        }
    }

    private void doConstructInnerQuery(String tableName, String startWithStr, String column1, String column2, String tableComment) {
        this.sb.append(column1);
        this.sb.append(" FROM ").append(tableName).append(" ");
        if (!this.multiTblFlag && !this.joinAlias.equalsIgnoreCase("mig_ora_cte_join_alias")) {
            this.sb.append(this.joinAlias).append(" ");
        }
        this.sb.append(tableComment).append(" ");
        if (startWithStr != null) {
            this.sb.append(" WHERE ").append(QueryConversionUtility.replaceAll(startWithStr, "(?i)START\\s+WITH", ""));
        }
        if (this.multiTblFlag && this.multiTblWhereClause.length() != 0) {
            String strMultiTbl = startWithStr != null ? " and " : " WHERE ";
            this.sb.append(strMultiTbl).append(this.multiTblWhereClause.toString()).append(" ");
        }
        this.sb.append(" UNION ALL SELECT ");
        this.sb.append(column2);
        this.sb.append(" FROM ").append("migora_cte").append(" ").append("mig_ora_cte_tab_alias");
        if (!this.multiTblFlag) {
            this.sb.append(" INNER JOIN ").append(tableName).append(" ").append(this.joinAlias).append(" ON ");
        } else {
            this.sb.append(",").append(tableName).append(" ").append(" WHERE ");
        }
        String connectByOnStr = QueryConversionUtility.replaceAll(this.connectByOn.toString(), "(?i)(?<!\\w)level(?!\\w)", "(mig_ora_cte_tab_alias.LEVEL + 1)");
        this.sb.append(connectByOnStr);
        if (this.multiTblFlag && this.multiTblWhereClause.length() != 0) {
            this.sb.append(" and ").append(this.multiTblWhereClause.toString()).append(" ");
        }
        this.sb.append(" ) ");
    }

    private List<String> doConstructColumns(StringBuffer colList1SB, StringBuffer colList2SB) {
        List<String> columnAliasList = QueryConversionUtility.doGetAliasList(this.fullColList);
        for (int iIndex = 0; iIndex < this.fullColList.size(); ++iIndex) {
            String fullColName = this.getFullColName(iIndex);
            if (!OracleConnectBy.doCheckAggregateFunctions(fullColName)) {
                if (!QueryConversionUtility.containsCheck(fullColName, "SYS_CONNECT_BY_PATH")) {
                    HashMap<String, String> quoteList = new HashMap<String, String>(5);
                    String replacement = QueryConversionUtility.getSingleOrDoubleQuoteMap(fullColName, quoteList, "'", "\\'.*?\\'", "~#~~#~~");
                    replacement = QueryConversionUtility.replaceAll(replacement, "(?i)(?<!\\w)LEVEL(?!\\w)", "1");
                    replacement = QueryConversionUtility.getRplFromMap(replacement, quoteList, "(~#~~#~~\\d+#)");
                    colList1SB.append(" ").append(replacement);
                    String columnNameWithAlias = QueryConversionUtility.doGetColumnNameWithAlias(fullColName, columnAliasList.get(iIndex), this.joinAlias, this.multiTblFlag);
                    columnNameWithAlias = QueryConversionUtility.replaceAll(columnNameWithAlias, "(?i)(?<!\\w)LEVEL(?!\\w)", "(mig_ora_cte_tab_alias.LEVEL + 1)");
                    colList2SB.append(" ").append(columnNameWithAlias);
                } else {
                    this.doHandleSysConnectByPath(fullColName, this.joinAlias, colList1SB, colList2SB, columnAliasList.get(iIndex));
                }
                this.appendCommaToBuffers(colList1SB, colList2SB, iIndex);
                continue;
            }
            String colStr = OracleConnectBy.doGetColForAggr(fullColName);
            this.getTwoBuffers(colList1SB, colList2SB, iIndex, colStr);
            this.setItemInList(columnAliasList, iIndex, fullColName);
        }
        return columnAliasList;
    }

    private String getFullColName(int iIndex) {
        String fullColName = this.fullColList.get(iIndex);
        fullColName = QueryConversionUtility.doSplitcolNameDotALias(fullColName, this.tblAlias);
        fullColName = QueryConversionUtility.doReplaceExactStr("AS", "", fullColName);
        return fullColName;
    }

    private void appendCommaToBuffers(StringBuffer colList1SB, StringBuffer colList2SB, int iIndex) {
        if (iIndex + 1 < this.fullColList.size()) {
            colList1SB.append(",");
            colList2SB.append(",");
        }
    }

    private void getTwoBuffers(StringBuffer colList1SB, StringBuffer colList2SB, int iIndex, String colStr) {
        if (colStr != null) {
            colList1SB.append(" ").append(colStr);
            if (colStr.matches("\\d+") || this.multiTblFlag) {
                colList2SB.append(" ").append(colStr);
            } else {
                colList2SB.append(" ").append(this.joinAlias).append(".").append(colStr);
            }
            this.appendCommaToBuffers(colList1SB, colList2SB, iIndex);
        }
    }

    private void setItemInList(List<String> columnAliasList, int index, String fullColName) {
        if (index >= 0 && index < columnAliasList.size()) {
            columnAliasList.set(index, fullColName);
        }
    }

    private void doHandleSysConnectByPath(String fullColNameStr, String joinAliasName, StringBuffer colListFirstQry, StringBuffer colListSecondQry, String aliasName) {
        String fullColName = fullColNameStr;
        ColumnSplitter splitter = new ColumnSplitter();
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)SYS_CONNECT_BY_PATH\\s*\\(");
        Matcher matcher = pattern.matcher(fullColName);
        StringBuffer sbuff = new StringBuffer();
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String patternStr = QueryConversionUtility.doGetReplaceString(fullColName.substring(endIndex - 1));
            String prefixStr = fullColName.substring(0, startIndex);
            int patternLen = patternStr.length();
            if (endIndex - 1 + patternLen > fullColName.length()) continue;
            String suffixStr = fullColName.substring(endIndex - 1 + patternLen);
            patternStr = patternStr.substring(1, patternStr.length() - 1);
            List<String> argList = splitter.doGetAllColumns(patternStr);
            for (int iIndex = argList.size() - 1; iIndex >= 0; --iIndex) {
                String listElement = argList.get(iIndex);
                if (!listElement.startsWith("'") && !listElement.startsWith("\"")) {
                    sbuff.append(joinAliasName).append(".");
                }
                sbuff.append(listElement);
                if (iIndex == 0) continue;
                sbuff.append("||");
            }
            colListFirstQry.append(prefixStr).append(sbuff.toString()).append(suffixStr);
            colListSecondQry.append(prefixStr).append("mig_ora_cte_tab_alias").append(".").append(aliasName.trim()).append("||").append(sbuff.toString()).append(suffixStr);
        }
    }

    private void removeDistinctAliasInColumn(List<String> columnList) {
        for (int iIndex = 0; iIndex < columnList.size(); ++iIndex) {
            StringBuffer colBuf = new StringBuffer();
            if (!OracleConnectBy.doCheckAggregateFunctions(columnList.get(iIndex))) {
                String[] eleArr = columnList.get(iIndex).split(" ");
                int index = 0;
                if (eleArr.length > 0) {
                    index = eleArr[0].trim().equalsIgnoreCase("DISTINCT") ? 1 : 0;
                }
                for (int jIndex = index; jIndex < eleArr.length; ++jIndex) {
                    if (!eleArr[jIndex].matches("(?i)#S#\\d+#E#")) {
                        colBuf.append(" ").append(QueryConversionUtility.doSplitcolNameDotALias(eleArr[jIndex].trim(), this.tblAlias));
                        continue;
                    }
                    colBuf.append(" ").append(eleArr[jIndex].trim());
                }
                if (!this.colLevelFlag && QueryConversionUtility.containsCheck(colBuf.toString().trim(), "LEVEL") && "LEVEL".equalsIgnoreCase(eleArr[0].trim())) {
                    this.colLevelFlag = true;
                }
            } else {
                colBuf.append(" ").append(columnList.get(iIndex));
            }
            this.fullColList.add(colBuf.toString().trim());
        }
    }

    private void addPriorColumnToWhereList(String connectByStr, List<String> whereClauseList) {
        String[] clauseSplit = QueryConversionUtility.doGetArrSplit(QueryConversionUtility.toLower(connectByStr), "and");
        HashSet<String> priorCol = new HashSet<String>(10);
        for (int iIndex = 0; iIndex < clauseSplit.length; ++iIndex) {
            if (iIndex != 0) {
                this.connectByOn.append(" AND ");
            }
            boolean flag = true;
            String clause = clauseSplit[iIndex];
            String prior = null;
            String nonPrior = null;
            for (String clauseStr : clause.split("(?i)(=|<|>|!)+")) {
                if (QueryConversionUtility.toLower(clauseStr).lastIndexOf("prior") != -1) {
                    prior = QueryConversionUtility.replaceAll(clauseStr, "(?i)PRIOR", "");
                    prior = QueryConversionUtility.doSplitcolNameDotALias(prior.trim(), this.tblAlias);
                    priorCol.add(prior);
                    this.connectByOn.append(" ");
                    if (this.multiTblFlag) {
                        prior = QueryConversionUtility.replaceAll(prior, "(?i)\\w+(?=\\.\\w+)", "mig_ora_cte_tab_alias");
                    } else {
                        this.connectByOn.append("mig_ora_cte_tab_alias").append(".");
                    }
                    this.connectByOn.append(prior).append(" ");
                } else {
                    nonPrior = clauseStr;
                    nonPrior = QueryConversionUtility.doSplitcolNameDotALias(nonPrior.trim(), this.tblAlias);
                    this.connectByOn.append(" ");
                    if (!(nonPrior.startsWith("'") || nonPrior.startsWith("\"") || QueryConversionUtility.equalCheck("LEVEL", nonPrior))) {
                        this.connectByOn.append(QueryConversionUtility.doGetColumnNameWithAlias(nonPrior, "", this.joinAlias, this.multiTblFlag));
                    } else {
                        this.connectByOn.append(nonPrior).append(" ");
                    }
                }
                if (!flag) continue;
                String operator = QueryConversionUtility.finderGroup(clause, "(?i)(prior)?.*?((!|=|<|>)+)", 2);
                this.connectByOn.append(" ").append(operator).append(" ");
                flag = false;
            }
        }
        if (whereClauseList != null) {
            whereClauseList.addAll(priorCol);
        }
    }

    private String getSubQryAlias(String tblNme) {
        String tableName = tblNme;
        if (this.tablNameSplit.length == 1 && this.tablNameSplit[0].matches("##SUBQUERY##\\d+__")) {
            this.subQueryFlag = true;
            tableName = "mig_ora_cte_sq_tab";
            this.subQueryConnectByMap.put(tableName, this.tablNameSplit[0]);
        } else if (this.tablNameSplit.length > 1) {
            if (this.tablNameSplit[0].matches("##SUBQUERY##\\d+__")) {
                this.subQueryFlag = true;
                this.tblAlias = tableName = this.tablNameSplit[this.tablNameSplit.length - 1];
                this.subQueryConnectByMap.put(tableName, this.tablNameSplit[0]);
            } else {
                this.tblAlias = this.joinAlias = this.tablNameSplit[this.tablNameSplit.length - 1];
                tableName = this.tablNameSplit[0];
            }
        }
        return tableName;
    }

    private static String doGetColForAggr(String column) {
        String str = null;
        ArrayList<String> patternList = new ArrayList<String>(10);
        patternList.add("(?i)(COUNT|AVG|SUM|MAX|MIN|RANK)(?=\\s*\\().*?\\)");
        patternList.add("(?i)(?<!\\w).*?(INTO)");
        for (String patternStr : patternList) {
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(column);
            if (!matcher.find()) continue;
            String grp = matcher.group();
            Matcher colmatcher = COL_PAT.matcher(grp = grp.replace(matcher.group(1), "").trim());
            if (colmatcher.find()) {
                str = colmatcher.group(3);
            }
            return str;
        }
        return str;
    }

    private static boolean doCheckAggregateFunctions(String column) {
        ArrayList<String> patternList = new ArrayList<String>(10);
        patternList.add("(?i)(COUNT|AVG|SUM|MAX|MIN|RANK)(?=\\s*\\().*?\\)");
        patternList.add("(?i)(?<!\\w).*?(INTO)");
        for (String patternStr : patternList) {
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(column);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private List<String> doGetSubQryColList(String mapKey, Map<String, String> subQueryTrackMap) {
        List<String> colList = new ArrayList<String>(10);
        if (subQueryTrackMap != null && !subQueryTrackMap.isEmpty() && subQueryTrackMap.containsKey(mapKey)) {
            for (Map.Entry<String, String> entry : subQueryTrackMap.entrySet()) {
                if (!entry.getKey().matches(mapKey)) continue;
                colList = QueryConversionUtility.doGetColumnNameList(entry.getValue());
                colList = QueryConversionUtility.doGetAliasList(colList);
            }
        } else {
            colList.add("*");
        }
        return colList;
    }

    private static void getTableAliasName(String inputQry, Set<String> aliasSet) {
        String input = inputQry;
        input = QueryConversionUtility.replaceAll(input, "(?i)(?<!\\w)(CONNECT\\s+BY|START\\s+WITH|AND|OR|PRIOR|LEVEL|\\d+|==|<>|!=|<=|>=|=|BETWEEN|IN|IS|NOT\\s+IN)(?!\\w)", "");
        Matcher matcher = OR_PAT.matcher(input);
        while (matcher.find()) {
            String grp = matcher.group(2);
            if (grp == null || grp.matches("(?i).*(?<!\\w)(SYSDATE|CURRENT_DATE|TIMESTAMP|LOCALTIMESTAMP|NEXTVAL|CURRVAL|CURRENT_TIMESTAMP|DBTIMEZONE|SESSIONTIMEZONE|SYSTIMESTAMP)(?!\\w).*") || grp.matches("(?i)null")) continue;
            aliasSet.add(grp);
        }
    }
}

