/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.common.features.GroupingFeature;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.oracle.OracleMapHelperExt;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.PlaceHolderUtility;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleMapHelper {
    private static final Logger logger = LogManager.getLogger(OracleMapHelper.class);
    private static final Pattern ALIAS_PAT = Pattern.compile("(?i)(aggDistAlias\\d+)");
    private Map<String, String> replaceValMap = null;
    private Map<String, String> aliasColumnMap = null;
    private String withClause = null;
    private String colString = null;
    private String distinctCol = null;
    private String distinctMatchgroup = null;
    private String partitionByCols = null;
    private String modifiedPartBycols = null;
    private String aliasNme = "aggDistAlias";
    private String queryAlias = "aggDistQuery";
    private int aliasCnt = 1;
    private int queryCnt = 1;
    private boolean isContains = false;
    private boolean isPartByColPresent = false;
    private List<String> distinctColsLst = new ArrayList<String>(10);
    private List<String> withClauseLst = new ArrayList<String>(10);
    private StringBuffer selectClause = null;
    private String with = "with";
    private Map<String, String> distinctMap = new LinkedHashMap<String, String>(10);
    private Map<String, String> qryNoWithClauseMap = new LinkedHashMap<String, String>(10);
    private Pattern distinctPat = Pattern.compile("(?i)((?:COUNT|MIN|MAX|AVG|SUM|STDDEV)\\s*\\(\\s*DISTINCT\\s+.*?\\))\\s*over\\s*\\((.*?)\\)");
    private Matcher distinctMatch = null;
    private Map<String, String> partByColsQryMap = null;
    private Map<String, String> distinctAliasQryMap = null;
    private String distinctMatchgroupUpper = "";

    public void doColumnSplit(IQueryPatternsBO objReplaceBO, Map<String, String> queryDataMap) {
        this.replaceValMap = new LinkedHashMap<String, String>(10);
        this.aliasColumnMap = new LinkedHashMap<String, String>(10);
        logger.debug("In doColumnSplit function");
        String columnNames = queryDataMap.get(objReplaceBO.getConstraintInput());
        if (columnNames != null && !columnNames.trim().equals("*") && !columnNames.trim().replace(" ", "").endsWith(".*")) {
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> columnArrays = splitter.doGetAllColumns(columnNames);
            String modifiedPlaceholderColumns = columnNames;
            if (!columnArrays.isEmpty()) {
                PlaceHolderUtility placeHolder = new PlaceHolderUtility();
                modifiedPlaceholderColumns = placeHolder.doGetPlaceholderColumns(columnArrays, "(?:\\(\\s*)?((?<!\\w)case\\s+|to_date\\s*\\(|to_char\\s*\\(|lpad\\s*?\\(|rpad\\s*?\\(|nvl\\s*\\(|cast\\s*?\\(|row_number\\s*\\(|COALESCE\\s*?\\(|MAX\\s*?\\(|MIN\\s*?\\(|length\\s*?\\(|SUBSTR\\s*?\\(|SUM\\s*?\\(|avg\\s*?\\(|count\\s*?\\(|rank\\s*?\\(|substring\\s*?\\(|lower\\s*?\\(|upper\\s*?\\(|ltrim\\s*?\\(|rtrim\\s*?\\(|trim\\s*?\\(|ZEROIFNULL\\s*?\\(|NULLIFZERO\\s*?\\(|mod\\s*\\(|(?<!\\w)char\\s*\\(|MaxDate\\s*\\(|TRANSACCTNUM\\s*\\(|ABS\\s*\\(|ROWIDTOCHAR\\s*\\(|decode\\s*\\(|RATIO_TO_REPORT\\s*\\()", this.replaceValMap, false, false);
            }
            queryDataMap.put("aliascolumnname", modifiedPlaceholderColumns);
            this.doConstructAliasColumnMap(objReplaceBO, queryDataMap);
        }
    }

    private void doConstructAliasColumnMap(IQueryPatternsBO objReplaceBO, Map<String, String> queryDataMap) {
        Pattern pattern = Pattern.compile(objReplaceBO.getConstraintPattern(), 2);
        String aliasColumns = queryDataMap.get(objReplaceBO.getConstraintInput());
        if (QueryConversionUtility.toUpper((aliasColumns = aliasColumns.replaceAll("(?i)#S#\\d+#E#", "")).trim()).startsWith("DISTINCT")) {
            aliasColumns = aliasColumns.trim().substring(8);
        }
        Matcher matcher = pattern.matcher(aliasColumns);
        String columnNme = null;
        String aliasName = null;
        while (matcher.find()) {
            columnNme = matcher.group(2).trim();
            if (columnNme.equals(aliasName = matcher.group(10).trim())) continue;
            this.doPutAliasAndColumnInMap(columnNme, aliasName);
        }
    }

    private void doPutAliasAndColumnInMap(String column, String alias) {
        String columnName = column;
        boolean isColumnContainsAlias = true;
        String columnExprKey = null;
        boolean isColExpr = false;
        if (columnName.trim().startsWith("_COLUMN__")) {
            columnExprKey = columnName;
            columnName = QueryConversionUtility.doReplaceFunctionVariables(columnName, this.replaceValMap, "_COLUMN__");
            isColExpr = true;
        }
        if (QueryConversionUtility.containsCheck(columnName, alias)) {
            isColumnContainsAlias = QueryConversionUtility.isContainsExactMatch(" " + columnName + " ", alias);
            if (!isColumnContainsAlias) {
                columnName = isColExpr ? columnExprKey : columnName;
                this.aliasColumnMap.put(alias, columnName);
            }
        } else {
            columnName = isColExpr ? columnExprKey : columnName;
            this.aliasColumnMap.put(alias, columnName);
        }
    }

    public boolean doGrpingFn(Map<String, String> parserMap) {
        boolean isValid = false;
        GroupingFeature groupingFeature = new GroupingFeature();
        isValid = groupingFeature.doGrpingFn(parserMap, this.replaceValMap, this.aliasColumnMap);
        return isValid;
    }

    public static String doReplaceSubpartitionFn(String inputQry, String subPartitionPattern) {
        String outputQry = inputQry;
        Pattern pattern = Pattern.compile(subPartitionPattern);
        Matcher matcher = pattern.matcher(inputQry);
        while (matcher.find()) {
            int subPartIndex = QueryConversionUtility.getIndex(inputQry, matcher.group(), matcher.start());
            String subPartStr = QueryConversionUtility.doGetReplaceString(inputQry.substring(subPartIndex));
            outputQry = outputQry.replace(subPartStr, "/*" + subPartStr + "*/");
        }
        return outputQry;
    }

    public static String doReplaceSubPartitionClause(String input, Map<String, String> functionMap) {
        boolean tCondition;
        String output = input;
        boolean counter = false;
        boolean fCondition = output.matches("(?i).*(?<!\\w)SUBPARTITION\\s+BY\\s+RANGE(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveRangeSubPartition"));
        boolean sCondition = output.matches("(?i).*(?<!\\w)SUBPARTITION\\s+BY\\s+HASH(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveHashSubPartition"));
        boolean bl = tCondition = output.matches("(?i).*(?<!\\w)SUBPARTITION\\s+BY\\s+LIST(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveListSubPartition"));
        if (fCondition || sCondition || tCondition) {
            output = QueryConversionUtility.replaceSubPartitionWithCommonPattern(output, "(?i)(?<!\\w)(SUBPARTITIONS\\s+\\d+\\s+STORE\\s+IN\\s+\\w+)", functionMap, "##SUBPART##", "#1");
            output = QueryConversionUtility.replaceSubPartitionWithCommonPatternFn(output, "(?i)(?<!\\w)(SUBPARTITIONS\\s+\\d+\\s+STORE\\s+IN\\s*\\()", functionMap, "##SUBPART##", "#2");
            output = QueryConversionUtility.replaceSubPartitionWithCommonPatternFn(output, "(?i)(?<!\\w)(SUBPARTITION\\s+TEMPLATE)(?!\\w)", functionMap, "##SUBPART##", "#3");
            output = QueryConversionUtility.replaceSubPartitionWithCommonPattern(output, "(?i)(?<!\\w|\\/\\*)(SUBPARTITIONS\\s+\\d+\\s*)(?!\\w)", functionMap, "##SUBPART##", "#4");
            output = QueryConversionUtility.replaceSubPartitionWithCommonPatternFn(output, "(?i)(\\(\\s*SUBPARTITION)(?!\\w)", functionMap, "##SUBPART##", "#5");
        }
        return output;
    }

    public boolean bulkCollectFn(Map<String, String> parserMap) {
        boolean isValid = false;
        String modifiedColumns = parserMap.get("aliascolumnname").trim();
        if (QueryConversionUtility.toUpper(modifiedColumns).startsWith("DISTINCT")) {
            modifiedColumns = modifiedColumns.substring(8);
            modifiedColumns = this.doPutColumnAlias(modifiedColumns);
            modifiedColumns = "DISTINCT " + modifiedColumns;
        } else if (!modifiedColumns.equals("*")) {
            modifiedColumns = this.doPutColumnAlias(modifiedColumns);
        }
        this.doColumnFunctionReplacer(parserMap, "aliascolumnname", modifiedColumns);
        List<String> colsList = Arrays.asList(modifiedColumns.split("\\s*,\\s*"));
        int colSize = colsList.size();
        for (int iIndex = 0; iIndex < colSize; ++iIndex) {
            String col = colsList.get(iIndex);
            int colIndex = col.lastIndexOf(32);
            if (colIndex == -1) continue;
            colsList.set(iIndex, col.substring(colIndex));
        }
        String bulkTables = parserMap.get("bulktables");
        List<String> tblsList = Arrays.asList(bulkTables.split("\\s*,\\s*"));
        int tblSize = tblsList.size();
        StringBuffer insQry = new StringBuffer();
        String insertQry = null;
        if (tblSize == colSize && colSize > 0) {
            isValid = true;
            for (int iIndex = 0; iIndex < colSize; ++iIndex) {
                String tblNme = tblsList.get(iIndex);
                String colNme = colsList.get(iIndex);
                insertQry = OracleMapHelper.doGetInsQry(tblNme, colNme);
                if (iIndex < colSize - 1) {
                    insQry.append(",").append("ins").append(iIndex + 1).append("(col1) as(").append(insertQry).append(" returning ").append(iIndex + 1).append(")");
                    continue;
                }
                insQry.append(insertQry).append(";");
            }
        }
        parserMap.put("insertQry", insQry.toString());
        return isValid;
    }

    private String doPutColumnAlias(String columnNames) {
        String inputCols = columnNames;
        String inputQry = columnNames;
        inputCols = QueryConversionUtility.doRemDotOrAppendAlias(inputCols, true);
        String colName = columnNames;
        String patternInputToMatch = inputCols.replaceAll("(?i)#S#\\d+#E#", "");
        List<String> list = Arrays.asList(patternInputToMatch.split(","));
        HashSet<String> uniqueWords = new HashSet<String>(list);
        for (String wordfrequency : uniqueWords) {
            if (Collections.frequency(list, wordfrequency) <= 1) continue;
            String neededStr = "." + wordfrequency.trim() + " ";
            inputQry = inputQry.replaceAll("(?i)#S#\\d+#E#", "");
            String[] commaSplitArr = inputQry.split(",");
            for (int iIndex = 0; iIndex < commaSplitArr.length; ++iIndex) {
                commaSplitArr[iIndex] = commaSplitArr[iIndex].trim();
            }
            List<String> uniqueColumns = Arrays.asList(commaSplitArr);
            HashSet<String> uniqueColSet = new HashSet<String>(uniqueColumns);
            for (String column : uniqueColSet) {
                String rqdString;
                if (!(column = column + " ").contains(neededStr) || !(rqdString = column.trim()).contains(".")) continue;
                String changedStr = rqdString.replace(".", "_").trim();
                if (!colName.contains(rqdString)) continue;
                colName = colName.replace(rqdString, rqdString + " " + "AS" + " " + changedStr);
            }
        }
        String output = QueryConversionUtility.doRemDotOrAppendAlias(colName, false);
        return output;
    }

    private void doColumnFunctionReplacer(Map<String, String> queryDataMap, String key, String keyInput) {
        String keyInp = keyInput;
        keyInp = QueryConversionUtility.doReplaceFunctionVariables(keyInp, this.replaceValMap, "COLUMN__");
        queryDataMap.put(key, keyInp);
    }

    public static String doChangeOnCommitRows(String inputStr) {
        String output = inputStr;
        String sessionReplace = FeatureLoader.getStringProperty("onCommitDeleteRows");
        String defaultRpl = "PRESERVE";
        if (sessionReplace.trim().equalsIgnoreCase("delete")) {
            defaultRpl = "delete";
        }
        output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?<!\\w)on\\s+commit\\s+(delete)\\s+rows", "", defaultRpl, 1, false);
        return output;
    }

    public boolean distinctAnalyticFn(Map<String, String> queryDataMap) {
        boolean isValid = false;
        this.partByColsQryMap = new LinkedHashMap<String, String>(10);
        this.distinctAliasQryMap = new LinkedHashMap<String, String>(10);
        ArrayList<String> partByColsLst = new ArrayList<String>(10);
        String columns = queryDataMap.get("aliascolumnname");
        String from = queryDataMap.get("from");
        String where = queryDataMap.get("where");
        List<String> colsLst = QueryConversionUtility.getLstFrmStringWithComma(columns, false);
        String withClauseFn = this.getWithClause(this.partByColsQryMap, this.distinctAliasQryMap, partByColsLst, from, where);
        if (!withClauseFn.isEmpty()) {
            isValid = true;
        }
        queryDataMap.put("withClause", withClauseFn);
        String selectStmt = this.getSlctStmt(queryDataMap, partByColsLst, colsLst, from, where);
        queryDataMap.put("selectStmt", selectStmt);
        return isValid;
    }

    private String getSlctStmt(Map<String, String> queryDataMap, List<String> partByColsLst, List<String> colsLst, String from, String where) {
        String fromTemp = from.substring(4).trim();
        String groupByClause = QueryConversionUtility.doGetSpecficClause(fromTemp, "(?i)((?<!\\w)group\\s+by\\s+.*?)(?:(?<!\\w)having|$)");
        String havingClause = QueryConversionUtility.doGetSpecficClause(fromTemp, "(?i)((?<!\\w)having\\s+.*?)(?:(?<!\\w)group\\s+by\\s+|$)");
        if (!(fromTemp = fromTemp.replaceAll("(?i)((?<!\\w)(group\\s+by|having)\\s+.*)", "").trim()).contains(",") && !fromTemp.trim().contains(" ") && partByColsLst.size() != 0) {
            fromTemp = fromTemp + " " + "MigTblAlias";
        }
        for (int iIndex = 0; iIndex < colsLst.size(); ++iIndex) {
            this.getColLIst(this.partByColsQryMap, this.distinctAliasQryMap, colsLst, iIndex);
        }
        StringBuffer selectStment = new StringBuffer();
        this.appendSelStatement(colsLst, selectStment, fromTemp);
        String orderby = queryDataMap.get("orderby");
        this.appendSelStmntWhereClause(where, orderby, selectStment, groupByClause, havingClause);
        return selectStment.toString();
    }

    private void getColLIst(Map<String, String> partByColsQryMap, Map<String, String> distinctAliasQryMap, List<String> colsLst, int iIndex) {
        String colStr = null;
        String colStringTemp = null;
        String col = colsLst.get(iIndex);
        colStringTemp = colStr = OracleMapHelper.getColNmeWhnAliasExists(col);
        if (colStr.contains("COLUMN__")) {
            if ((colStr = QueryConversionUtility.doReplaceFunctionVariables(colStr, this.replaceValMap, "COLUMN__")).matches("\\s*aggDistAlias\\d+.*")) {
                colStr = this.getColString(partByColsQryMap, distinctAliasQryMap, colStr);
            }
            String colTemp = col;
            colTemp = colTemp.replace(colStringTemp, colStr);
            colsLst.set(iIndex, colTemp);
        }
    }

    private String getColString(Map<String, String> partByColsQryMap, Map<String, String> distinctAliasQryMap, String colStr) {
        HashSet<String> querySet = null;
        StringBuffer queryBuff = null;
        querySet = new HashSet<String>(10);
        queryBuff = new StringBuffer();
        Matcher match = ALIAS_PAT.matcher(colStr);
        while (match.find()) {
            String alias = match.group(1);
            querySet.add(distinctAliasQryMap.get(alias));
        }
        this.fillQueryBuffer(colStr, querySet, queryBuff);
        Iterator itr = querySet.iterator();
        while (itr.hasNext()) {
            String partByCol = OracleMapHelperExt.getKey((String)itr.next(), partByColsQryMap);
            if (partByCol == null) continue;
            queryBuff.append(partByCol).append(" ").append("and").append(" ");
        }
        if (queryBuff.toString().trim().endsWith("and")) {
            queryBuff.delete(queryBuff.length() - 4, queryBuff.length());
        }
        if (queryBuff.toString().trim().endsWith("where")) {
            String tempQuery = queryBuff.toString().trim();
            tempQuery = tempQuery.substring(0, tempQuery.length() - 6);
            queryBuff = new StringBuffer(tempQuery);
        }
        queryBuff.append(")");
        colStr = queryBuff.toString();
        return colStr;
    }

    private void fillQueryBuffer(String colStr, Set<String> querySet, StringBuffer queryBuff) {
        queryBuff.append("(").append("select").append(" ").append(colStr);
        queryBuff.append(" ").append("from").append(" ");
        for (String query : querySet) {
            queryBuff.append(query).append(",");
        }
        queryBuff.deleteCharAt(queryBuff.length() - 1);
        queryBuff.append(" where ");
    }

    private void appendSelStatement(List<String> colsLst, StringBuffer selectStment, String fromTemp) {
        selectStment.append("select").append(" ");
        selectStment.append(QueryConversionUtility.doGetStrFrmListWithComma(colsLst)).append(" ");
        selectStment.append("from").append(" ").append(fromTemp).append(" ");
    }

    private void appendSelStmntWhereClause(String where, String orderby, StringBuffer selectStment, String groupByClause, String havingClause) {
        selectStment.append(where).append(" ");
        selectStment.append(groupByClause).append(" ");
        selectStment.append(havingClause).append(" ");
        selectStment.append(orderby).append(" ");
    }

    private String getWithClause(Map<String, String> partByColsQryMap, Map<String, String> distinctAliasQryMap, List<String> partByColsLst, String from, String where) {
        this.withClause = null;
        this.colString = null;
        this.distinctCol = null;
        this.distinctMatchgroup = null;
        this.partitionByCols = null;
        this.modifiedPartBycols = null;
        this.aliasNme = "aggDistAlias";
        this.queryAlias = "aggDistQuery";
        this.aliasCnt = 1;
        this.queryCnt = 1;
        this.isContains = false;
        this.isPartByColPresent = false;
        this.distinctColsLst = new ArrayList<String>(10);
        this.withClauseLst = new ArrayList<String>(10);
        this.selectClause = null;
        this.with = "with";
        this.distinctMap = new LinkedHashMap<String, String>(10);
        this.qryNoWithClauseMap = new LinkedHashMap<String, String>(10);
        this.distinctMatch = null;
        for (Map.Entry<String, String> col : this.replaceValMap.entrySet()) {
            this.colString = col.getValue();
            this.distinctMatch = this.distinctPat.matcher(this.colString);
            while (this.distinctMatch.find()) {
                this.distinctMatchgroup = this.distinctMatch.group();
                this.distinctMatchgroupUpper = QueryConversionUtility.toUpper(QueryConversionUtility.doRemoveExtraSpace(this.distinctMatchgroup));
                String distinctColTemp = this.distinctMatch.group(1);
                this.partitionByCols = this.distinctMatch.group(2).trim();
                this.distinctCol = QueryConversionUtility.doGetReplaceString(distinctColTemp);
                if (!distinctColTemp.equals(this.distinctCol)) continue;
                this.removePartitionByString(col, partByColsQryMap, distinctAliasQryMap, partByColsLst, from);
                if (this.isContains) continue;
                this.getQry(partByColsQryMap, from, where);
            }
            this.modifiedPartBycols = null;
            this.isPartByColPresent = false;
        }
        return this.withClause();
    }

    private String withClause() {
        for (Map.Entry<String, String> qryMap : this.qryNoWithClauseMap.entrySet()) {
            this.withClauseLst.add(qryMap.getValue());
        }
        this.withClause = QueryConversionUtility.doGetStrFrmListWithComma(this.withClauseLst);
        return this.withClause;
    }

    private void getQry(Map<String, String> partByColsQryMap, String from, String where) {
        this.isContains = false;
        String qryNo = partByColsQryMap.get(this.modifiedPartBycols);
        String query = this.qryNoWithClauseMap.get(qryNo);
        if (this.isPartByColPresent && query != null || this.modifiedPartBycols == null && query != null) {
            StringBuffer buff = new StringBuffer();
            buff.append(",").append(this.distinctCol).append(" ").append(this.aliasNme).append(this.aliasCnt++).append(" ");
            int idx = QueryConversionUtility.toLower(query).indexOf("from");
            query = query.substring(0, idx) + buff.toString() + query.substring(idx);
            this.qryNoWithClauseMap.put(qryNo, query);
        } else {
            this.selectDistinctColumn(from, where);
        }
    }

    private void selectDistinctColumn(String from, String where) {
        this.selectClause = new StringBuffer();
        this.selectClause.append(this.with).append(" ").append(this.queryAlias).append(this.queryCnt);
        this.selectClause.append(" ").append("AS").append("(");
        this.selectClause.append("select").append(" ");
        if (!this.partitionByCols.isEmpty()) {
            this.selectClause.append(this.partitionByCols).append(",");
        }
        this.selectClause.append(this.distinctCol).append(" ").append(this.aliasNme).append(this.aliasCnt++);
        this.selectClause.append(" ").append(from).append(" ");
        if (where != null) {
            this.selectClause.append(where);
        }
        if (!(this.partitionByCols.isEmpty() || from.matches("(?i).*(?<!\\w)group\\s+by(?!\\w).*") || where == null || where.matches("(?i).*(?<!\\w)group\\s+by(?!\\w).*"))) {
            this.selectClause.append(" ").append("group by").append(" ").append(this.partitionByCols);
        }
        this.selectClause.append(")");
        this.qryNoWithClauseMap.put(this.queryAlias + this.queryCnt++, this.selectClause.toString());
        if ("with".equals(this.with)) {
            this.with = "";
        }
    }

    private void updateDistinctWithReplaceMap(String distinctMatchgroupUpper, Map.Entry<String, String> col, Map<String, String> partByColsQryMap, Map<String, String> distinctAliasQryMap, List<String> partByColsLst) {
        if (this.distinctColsLst.contains(distinctMatchgroupUpper)) {
            this.isContains = true;
            String aliasVal = this.distinctMap.get(distinctMatchgroupUpper);
            this.replaceValMap.put(col.getKey(), col.getValue().replace(this.distinctMatchgroup, aliasVal));
        } else {
            this.distinctColsLst.add(distinctMatchgroupUpper);
            this.distinctMap.put(distinctMatchgroupUpper, this.aliasNme + this.aliasCnt);
            if (partByColsLst.isEmpty() && partByColsQryMap.get(this.modifiedPartBycols) != null) {
                distinctAliasQryMap.put(this.aliasNme + this.aliasCnt, partByColsQryMap.get(this.modifiedPartBycols));
            } else if (partByColsLst.isEmpty()) {
                partByColsQryMap.put(this.modifiedPartBycols, this.queryAlias + this.queryCnt);
                distinctAliasQryMap.put(this.aliasNme + this.aliasCnt, this.queryAlias + this.queryCnt);
            } else if (this.isPartByColPresent) {
                distinctAliasQryMap.put(this.aliasNme + this.aliasCnt, partByColsQryMap.get(this.modifiedPartBycols));
            } else if (!partByColsLst.isEmpty() && this.partitionByCols.isEmpty()) {
                distinctAliasQryMap.put(this.aliasNme + this.aliasCnt, partByColsQryMap.get(this.modifiedPartBycols));
            } else if (!partByColsLst.isEmpty() && !this.partitionByCols.isEmpty()) {
                partByColsQryMap.put(this.modifiedPartBycols, this.queryAlias + this.queryCnt);
                distinctAliasQryMap.put(this.aliasNme + this.aliasCnt, this.queryAlias + this.queryCnt);
            }
            this.replaceValMap.put(col.getKey(), col.getValue().replace(this.distinctMatchgroup, this.aliasNme + this.aliasCnt));
        }
    }

    private void removePartitionByString(Map.Entry<String, String> col, Map<String, String> partByColsQryMap, Map<String, String> distinctAliasQryMap, List<String> partByColsLst, String from) {
        if (!this.partitionByCols.isEmpty()) {
            this.partitionByCols = this.partitionByCols.replaceAll("(?i)partition\\s+by\\s+", "");
            if (partByColsLst.contains(this.partitionByCols)) {
                this.isPartByColPresent = true;
            } else {
                partByColsLst.add(this.partitionByCols);
            }
            this.modifiedPartBycols = this.getWhereUsingPartByCols(this.partitionByCols, from);
        }
        if (this.distinctColsLst.isEmpty()) {
            this.distinctColsLst.add(this.distinctMatchgroupUpper);
            this.distinctMap.put(this.distinctMatchgroupUpper, this.aliasNme + this.aliasCnt);
            partByColsQryMap.put(this.modifiedPartBycols, this.queryAlias + this.queryCnt);
            this.replaceValMap.put(col.getKey(), col.getValue().replace(this.distinctMatchgroup, this.aliasNme + this.aliasCnt));
            distinctAliasQryMap.put(this.aliasNme + this.aliasCnt, this.queryAlias + this.queryCnt);
        } else {
            this.updateDistinctWithReplaceMap(this.distinctMatchgroupUpper, col, partByColsQryMap, distinctAliasQryMap, partByColsLst);
        }
    }

    private String getWhereUsingPartByCols(String partitionByColsParam, String from) {
        String fromQry = from;
        String tblAlias = null;
        String column = null;
        String columnTmp = null;
        StringBuffer sbuff = new StringBuffer();
        fromQry = fromQry.substring(4).trim();
        fromQry = fromQry.replaceAll("(?i)((?<!\\w)(group\\s+by|having)\\s+.*)", "").trim();
        List<String> partByColLst = QueryConversionUtility.getLstFrmStringWithComma(partitionByColsParam, false);
        int size = partByColLst.size();
        for (int iIndex = 0; iIndex < size; ++iIndex) {
            columnTmp = column = partByColLst.get(iIndex);
            if (column.contains(".")) {
                columnTmp = column.substring(column.indexOf(46) + 1);
                tblAlias = column.substring(0, column.indexOf(46));
            }
            tblAlias = this.doGetDistinctTblAlias(fromQry, tblAlias);
            sbuff.append(columnTmp).append(" ").append("=");
            sbuff.append(" ").append(tblAlias).append(".").append(columnTmp);
            sbuff.append(" ").append("and").append(" ");
        }
        sbuff.delete(sbuff.length() - 4, sbuff.length());
        String modifiedPartByColumn = sbuff.toString();
        return modifiedPartByColumn;
    }

    private String doGetDistinctTblAlias(String from, String tblAlias) {
        String alias = tblAlias;
        if (tblAlias == null) {
            int spaceIndex = from.indexOf(32);
            alias = spaceIndex != -1 && !from.contains(",") ? from.substring(spaceIndex) : "MigTblAlias";
        }
        return alias;
    }

    private static String getColNmeWhnAliasExists(String col) {
        String column = col;
        String colStringIn = null;
        if (column.contains(" ")) {
            int idx;
            colStringIn = (column = column.trim()).substring(0, idx = column.lastIndexOf(32)).trim();
            if (QueryConversionUtility.toLower(colStringIn).endsWith(" as") || QueryConversionUtility.toUpper(colStringIn).endsWith(" INTO")) {
                colStringIn = colStringIn.substring(0, colStringIn.lastIndexOf(32));
            }
        } else {
            colStringIn = column;
        }
        return colStringIn;
    }

    private static String doGetInsQry(String tblNme, String colNme) {
        StringBuffer insQry = new StringBuffer();
        insQry.append("INSERT INTO ").append(tblNme).append(" ").append("select").append(" ").append(colNme).append(",").append("ROW_NUMBER").append("()").append(" ").append("over").append("()").append(" ").append("from").append(" ").append("multi_udt");
        return insQry.toString();
    }
}

