/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.common.features.MergeFeature;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationMapper;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.oracle.OracleMapHelper;
import com.huawei.db.migration.oracle.OracleMapHelperExt;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleMapper
implements IMigrationMapper {
    private static final Logger logger = LogManager.getLogger(OracleMapper.class);

    @Override
    public boolean doMapping(String sqlQuery, IQueryPatternsBO mapper, IReplacerMap parserMap) throws MigrationServiceException {
        boolean validationSuccess = false;
        boolean validation = false;
        OracleMapHelper oracleMapHelper = new OracleMapHelper();
        List<String> constChk = mapper.getConstraintList();
        Iterator<String> constChkItr = constChk.iterator();
        String chkName = null;
        while (constChkItr.hasNext()) {
            OracleMapHelperExt oracleMapperExt;
            chkName = constChkItr.next();
            if (StringUtils.isNotEmpty((CharSequence)chkName) && chkName.startsWith("do")) {
                validationSuccess = this.handleForStartingWithDo(chkName, mapper, parserMap, oracleMapHelper);
            } else if (chkName.equals("mergeFn")) {
                if (!FeatureLoader.getStringProperty("mergeImplementation").equalsIgnoreCase("none")) {
                    if (FeatureLoader.getStringProperty("mergeImplementation").equalsIgnoreCase("split")) {
                        mapper.setReplacementPattern(mapper.getAlternateReplacementPattern());
                    }
                    MergeFeature mergeFeature = new MergeFeature();
                    validationSuccess = mergeFeature.mergeFn(parserMap);
                }
            } else if (chkName.equals("insertAllFn")) {
                oracleMapperExt = new OracleMapHelperExt();
                validationSuccess = oracleMapperExt.insertAllFn(parserMap);
            } else if (chkName.equals("insertFirstFn")) {
                oracleMapperExt = new OracleMapHelperExt();
                validationSuccess = oracleMapperExt.insertFirstFn(parserMap);
            } else if (chkName.equals("bulkCollect") && QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "localtable")) {
                validationSuccess = oracleMapHelper.bulkCollectFn(parserMap);
            } else {
                logger.debug("No mapper has been selected");
            }
            if (!validationSuccess) continue;
            validation = true;
        }
        return validation;
    }

    private boolean handleForStartingWithDo(String chkName, IQueryPatternsBO mapper, IReplacerMap parserMap, OracleMapHelper oracleMapHelper) {
        boolean validationSuccess = false;
        if (chkName.equals("doColumnSplit")) {
            oracleMapHelper.doColumnSplit(mapper, parserMap);
        } else if (chkName.equals("doGrpingFn")) {
            validationSuccess = oracleMapHelper.doGrpingFn(parserMap);
        } else if (chkName.equals("doDistinctAnalyticFn")) {
            validationSuccess = oracleMapHelper.distinctAnalyticFn(parserMap);
        }
        return validationSuccess;
    }
}

